/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.converters;

import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.jira.model.querydsl.AuditLogDTO;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;

public final class AuditAuthors {
    private AuditAuthors() {
    }

    public static AuditAuthor from(ApplicationUser user) {
        return AuditAuthor.builder().id(String.valueOf(user.getId())).name(user.getName()).type("ApplicationUser").uri("/secure/ViewProfile.jspa?name=" + user.getName()).build();
    }

    public static AuditAuthor from(JiraAuthenticationContext context) {
        ApplicationUser loggedInUser;
        if (context != null && (loggedInUser = context.getLoggedInUser()) != null) {
            return AuditAuthors.from(loggedInUser);
        }
        return AuditAuthor.SYSTEM_AUTHOR;
    }

    public static AuditAuthor from(AuditLogDTO auditLogDTO, UserManager userManager) {
        try {
            ApplicationUser user = userManager.getUserByKey(auditLogDTO.getAuthorKey());
            String id = user.getId().toString();
            return AuditAuthor.builder().id(id).type("ApplicationUser").uri("/secure/ViewProfile.jspa?name=" + user.getName()).name(user.getName()).build();
        }
        catch (Exception ee) {
            return AuditAuthor.SYSTEM_AUTHOR;
        }
    }
}

