/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.IssueTypeSchemeHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@AuditExceptionSafe
public final class IssueTypeSchemeHandlerImpl
implements IssueTypeSchemeHandler {
    private static final AuditType TYPE_SCHEME_ASSOCIATION_CHANGED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.FIELD_CONFIG_SCHEME, "jira.auditing.issue.type.scheme.association.changed", CoverageLevel.ADVANCED);
    private static final AuditType ISSUE_TYPE_SCHEME_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.FIELD_CONFIG_SCHEME, "jira.auditing.issue.type.scheme.created", CoverageLevel.ADVANCED);
    private static final AuditType ISSUE_TYPE_SCHEME_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.FIELD_CONFIG_SCHEME, "jira.auditing.issue.type.scheme.updated", CoverageLevel.ADVANCED);
    private static final AuditType ISSUE_TYPE_SCHEME_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.FIELD_CONFIG_SCHEME, "jira.auditing.issue.type.scheme.deleted", CoverageLevel.ADVANCED);
    private final AuditService auditService;
    private final I18nHelper i18nHelper;

    public IssueTypeSchemeHandlerImpl(AuditService auditService, I18nHelper.BeanFactory i18nFactory) {
        this.auditService = auditService;
        this.i18nHelper = i18nFactory.getInstance(Locale.ENGLISH);
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeSchemeDeleted(FieldConfigScheme fieldConfigScheme) {
        AuditEvent auditEvent = AuditEvent.builder((AuditType)ISSUE_TYPE_SCHEME_DELETED).build();
        this.auditService.audit(auditEvent);
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeSchemeCreated(FieldConfigScheme fieldConfigScheme, OptionSet optionSet) {
        AuditEvent auditEvent = AuditEvent.builder((AuditType)ISSUE_TYPE_SCHEME_CREATED).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.priority.scheme.description", fieldConfigScheme.getDescription())).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.priority.scheme.issue.types", this.convertToJoinedOptions(optionSet))).affectedObject(AuditResource.builder((String)fieldConfigScheme.getName(), (String)AssociatedItem.Type.FIELD_CONFIG_SCHEME.name()).id(fieldConfigScheme.getId().toString()).build()).build();
        this.auditService.audit(auditEvent);
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeSchemeAssociationsChange(List<JiraContextNode> jiraContextNodes, IssueTypeSchemeManager issueTypeSchemeManager, FieldConfigScheme configScheme) {
        Set namesOfAffectedProjects = jiraContextNodes.stream().filter(context -> context.getProjectObject() != null).map(project -> project.getProjectObject().getName()).collect(Collectors.toSet());
        String issueTypeSchemeNewName = configScheme.getName();
        List changedValues = issueTypeSchemeManager.getAllSchemes().stream().map(schemeConfig -> this.convertToChangedValue((FieldConfigScheme)schemeConfig, namesOfAffectedProjects, issueTypeSchemeNewName)).flatMap(Collection::stream).collect(Collectors.toList());
        AuditEvent auditEvent = AuditEvent.builder((AuditType)TYPE_SCHEME_ASSOCIATION_CHANGED).changedValues(changedValues).affectedObject(AuditResource.builder((String)configScheme.getName(), (String)AssociatedItem.Type.SCHEME.toString()).id(configScheme.getId().toString()).build()).build();
        this.auditService.audit(auditEvent);
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeSchemeUpdated(FieldConfigScheme oldValue, FieldConfigScheme newValue, OptionSet oldSet, OptionSet newSet) {
        AuditEvent auditEvent = AuditEvent.builder((AuditType)ISSUE_TYPE_SCHEME_UPDATED).affectedObject(AuditResource.builder((String)newValue.getName(), (String)AssociatedItem.Type.FIELD_CONFIG_SCHEME.name()).id(newValue.getId().toString()).build()).changedValues(new ChangedValuesBuilder().addIfDifferent("jira.auditing.priority.scheme.name", oldValue.getName(), newValue.getName()).addIfDifferent("jira.auditing.priority.scheme.description", oldValue.getDescription(), newValue.getDescription()).addIfDifferent("jira.auditing.priority.scheme.issue.types", this.convertToJoinedOptions(oldSet), this.convertToJoinedOptions(newSet)).build()).build();
        this.auditService.audit(auditEvent);
    }

    private List<ChangedValue> convertToChangedValue(FieldConfigScheme issueTypeScheme, Set<String> namesOfAffectedProjects, String issueTypeSchemeNewName) {
        return issueTypeScheme.getAssociatedProjectObjects().stream().filter(its -> its.getName() != null).map(Project::getName).filter(namesOfAffectedProjects::contains).map(projectName -> this.toChangedValueBuilder((String)projectName, issueTypeScheme, issueTypeSchemeNewName)).map(ChangedValuesBuilder::build).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private ChangedValuesBuilder toChangedValueBuilder(String projectName, FieldConfigScheme issueTypeScheme, String issueTypeSchemeNewName) {
        return new ChangedValuesBuilder().addIfDifferent(this.i18nHelper.getText("jira.auditing.issue.type.scheme.association.project.changed", projectName), issueTypeScheme.getName(), issueTypeSchemeNewName);
    }

    private String convertToJoinedOptions(@Nonnull OptionSet optionSet) {
        Objects.requireNonNull(optionSet.getOptions());
        return optionSet.getOptions().stream().filter(Objects::nonNull).map(Option::getName).collect(Collectors.joining(", "));
    }
}

