/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.handlers.LoggingAndProfilingUpdatedEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.event.logging.LoggingUpdatedEvent;
import com.atlassian.jira.event.logging.ProfilingUpdatedEvent;
import com.google.common.annotations.VisibleForTesting;

@AuditExceptionSafe
public class LoggingAndProfilingUpdatedEventHandlerImpl
implements LoggingAndProfilingUpdatedEventHandler {
    public static final String I18N_LOGGING_PACKAGE = "jira.auditing.logging.package";
    public static final String I18N_LOGGING_LEVEL = "jira.auditing.logging.level";
    public static final String I18N_PROFILING_ENABLED = "jira.auditing.profiling.enabled";
    public static final String I18N_PROFILING_DISABLED = "jira.auditing.profiling.disabled";
    @VisibleForTesting
    static final AuditType LOGGING_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.logging", "jira.auditing.logging.settings.changed", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType PROFILING_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.profiling", "jira.auditing.profiling.settings.changed", CoverageLevel.BASE);
    private final AuditService auditService;

    public LoggingAndProfilingUpdatedEventHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    public void handleLoggingUpdated(LoggingUpdatedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)LOGGING_UPDATED).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_LOGGING_PACKAGE, event.getPackageName())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_LOGGING_LEVEL, event.getLevel())).build());
    }

    @Override
    public void handleProfilingUpdated(ProfilingUpdatedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PROFILING_UPDATED).actionI18nKey(event.isEnabled() ? I18N_PROFILING_ENABLED : I18N_PROFILING_DISABLED).build());
    }
}

