/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AffectedLicense;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.SystemAuditEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.config.FeatureDisabledEvent;
import com.atlassian.jira.config.FeatureEnabledEvent;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.license.ConfirmEvaluationLicenseEvent;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;

@AuditExceptionSafe
public class SystemAuditEventHandlerImpl
implements SystemAuditEventHandler {
    private static final String ADMIN_LICENSE_ORGANISATION = "admin.license.organisation";
    private static final String ADMIN_LICENSE_DATE_PURCHASED = "admin.license.date.purchased";
    private static final String ADMIN_LICENSE_TYPE = "admin.license.type";
    private static final String ADMIN_SERVER_ID = "admin.server.id";
    private static final String ADMIN_LICENSE_SEN = "admin.license.sen";
    @VisibleForTesting
    static final AuditType FEATURE_ENABLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.SYSTEM, "jira.auditing.feature.enabled", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType FEATURE_DISABLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.SYSTEM, "jira.auditing.feature.disabled", CoverageLevel.ADVANCED);
    private final I18nHelper i18nHelper;
    private final OutlookDateManager outlookDateManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final AuditService auditService;

    public SystemAuditEventHandlerImpl(I18nHelper i18nHelper, OutlookDateManager outlookDateManager, DateTimeFormatterFactory dateTimeFormatterFactory, AuditService auditService) {
        this.i18nHelper = i18nHelper;
        this.outlookDateManager = outlookDateManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.auditService = auditService;
    }

    @Override
    @Nonnull
    public RecordRequest onLicenseChangedEvent(@Nonnull LicenseChangedEvent event) {
        LicenseDetails licenseDetails;
        String eventMessageKey;
        Preconditions.checkNotNull((Object)event, (Object)"event");
        if (event.isLicenseRemoved()) {
            eventMessageKey = "jira.auditing.system.license.removed";
            licenseDetails = (LicenseDetails)event.getPreviousLicenseDetails().getOrNull();
        } else if (event.isLicenseUpdated()) {
            eventMessageKey = "jira.auditing.system.license.updated";
            licenseDetails = (LicenseDetails)event.getNewLicenseDetails().getOrNull();
        } else {
            eventMessageKey = "jira.auditing.system.license.added";
            licenseDetails = (LicenseDetails)event.getNewLicenseDetails().getOrNull();
        }
        Preconditions.checkNotNull((Object)licenseDetails);
        Preconditions.checkNotNull((Object)licenseDetails.getJiraLicense());
        return new RecordRequest(AuditingCategory.SYSTEM, eventMessageKey).withActionI18nKey(eventMessageKey).forObject((AssociatedItem)new AffectedLicense(licenseDetails)).withChangedValues(this.buildChangedValuesForNewLicense(licenseDetails));
    }

    @Override
    @Nonnull
    public RecordRequest onExtendTrialLicense(@Nonnull ConfirmEvaluationLicenseEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
        return new RecordRequest(AuditingCategory.SYSTEM, "jira.auditing.system.license.extend.evaluation").withActionI18nKey("jira.auditing.system.license.extend.evaluation").forObject((AssociatedItem)new AffectedLicense(event.getUserWhoConfirmed(), true)).withChangedValues(this.buildChangedValuesForEvaluationExtended(event.getExpiredLicenses()));
    }

    @Override
    @ThrowSafe
    public void handleFeatureEnabledEvent(FeatureEnabledEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)FEATURE_ENABLED).affectedObject(AuditResource.builder((String)event.feature(), (String)AssociatedItem.Type.FEATURE.name()).build()).build());
    }

    @Override
    public RecordRequest onFeatureEnabledEvent(FeatureEnabledEvent event) {
        return new RecordRequest(AuditingCategory.SYSTEM, "jira.auditing.feature.enabled").withActionI18nKey("jira.auditing.feature.enabled").forObject(AssociatedItem.Type.FEATURE, event.feature());
    }

    @Override
    @ThrowSafe
    public void handleFeatureDisabledEvent(FeatureDisabledEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)FEATURE_DISABLED).affectedObject(AuditResource.builder((String)event.feature(), (String)AssociatedItem.Type.FEATURE.name()).build()).build());
    }

    @Override
    public RecordRequest onFeatureDisabledEvent(FeatureDisabledEvent event) {
        return new RecordRequest(AuditingCategory.SYSTEM, "jira.auditing.feature.disabled").withActionI18nKey("jira.auditing.feature.disabled").forObject(AssociatedItem.Type.FEATURE, event.feature());
    }

    private List<ChangedValue> buildChangedValuesForNewLicense(LicenseDetails details) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.add(ADMIN_LICENSE_ORGANISATION, null, details.getOrganisation());
        changedValues.add(ADMIN_LICENSE_DATE_PURCHASED, null, details.getPurchaseDate(this.getDateTimeFormatter()));
        changedValues.add(ADMIN_LICENSE_TYPE, null, details.getDescription());
        changedValues.add(ADMIN_SERVER_ID, null, details.getJiraLicense().getServerId());
        changedValues.add(ADMIN_LICENSE_SEN, null, details.getSupportEntitlementNumber());
        this.buildUserLimitForNewRoles(details, changedValues);
        this.buildChangedValuesForNewRoles(details, changedValues);
        return changedValues.build();
    }

    private List<ChangedValue> buildChangedValuesForEvaluationExtended(Iterable<LicenseDetails> detailsBag) {
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE);
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        for (LicenseDetails details : detailsBag) {
            changedValues.add(ADMIN_LICENSE_ORGANISATION, null, details.getOrganisation());
            changedValues.add(ADMIN_LICENSE_DATE_PURCHASED, null, details.getPurchaseDate(this.getDateTimeFormatter()));
            changedValues.add("admin.license.date.expired", null, dateTimeFormatter.format(details.getJiraLicense().getMaintenanceExpiryDate()));
            changedValues.add(ADMIN_LICENSE_TYPE, null, details.getDescription());
            changedValues.add(ADMIN_SERVER_ID, null, details.getJiraLicense().getServerId());
            changedValues.add(ADMIN_LICENSE_SEN, null, details.getSupportEntitlementNumber());
            this.buildUserLimitForNewRoles(details, changedValues);
        }
        return changedValues.build();
    }

    private void buildChangedValuesForNewRoles(LicenseDetails details, ChangedValuesBuilder changedValues) {
        LicensedApplications licensedApplications = details.getLicensedApplications();
        for (ApplicationKey key : licensedApplications.getKeys()) {
            changedValues.add(key.value(), null, String.valueOf(licensedApplications.getUserLimit(key)));
        }
    }

    private void buildUserLimitForNewRoles(LicenseDetails details, ChangedValuesBuilder changedValues) {
        String userLimit = !details.isUnlimitedNumberOfUsers() ? String.valueOf(details.getJiraLicense().getMaximumNumberOfUsers()) : this.i18nHelper.getText("common.words.unlimited");
        changedValues.add("admin.license.user.limit", null, userLimit);
    }

    @Deprecated
    private OutlookDate getOutlookDate() {
        return this.outlookDateManager.getOutlookDate(this.i18nHelper.getLocale());
    }

    private DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatterFactory.formatter().withLocale(this.i18nHelper.getLocale());
    }
}

