/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.jira.auditing.AffectedProject;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.VersionEventHandler;
import com.atlassian.jira.event.project.AbstractVersionEvent;
import com.atlassian.jira.event.project.VersionArchiveEvent;
import com.atlassian.jira.event.project.VersionMergeEvent;
import com.atlassian.jira.event.project.VersionReleaseEvent;
import com.atlassian.jira.event.project.VersionUnarchiveEvent;
import com.atlassian.jira.event.project.VersionUnreleaseEvent;
import com.atlassian.jira.event.project.VersionUpdatedEvent;
import com.atlassian.jira.project.version.Version;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class VersionEventHandlerImpl
implements VersionEventHandler {
    @Override
    @Nonnull
    public RecordRequest onVersionCreateEvent(@Nonnull AbstractVersionEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.version.created").withActionI18nKey("jira.auditing.version.created").forObject(AssociatedItem.Type.VERSION, event.getVersion().getName(), Long.valueOf(event.getVersionId())).withAssociatedItems(new AssociatedItem[]{new AffectedProject(event.getVersion().getProjectObject())}).withChangedValues(this.computeChangedValues(null, event.getVersion()));
    }

    @Override
    @Nonnull
    public RecordRequest onVersionDeleteEvent(@Nonnull AbstractVersionEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.version.deleted").withActionI18nKey("jira.auditing.version.deleted").forObject(AssociatedItem.Type.VERSION, event.getVersion().getName(), Long.valueOf(event.getVersionId())).withAssociatedItems(new AssociatedItem[]{new AffectedProject(event.getVersion().getProjectObject())});
    }

    @Override
    @Nonnull
    public RecordRequest onVersionUnreleaseEvent(@Nonnull VersionUnreleaseEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.version.unreleased").withActionI18nKey("jira.auditing.version.unreleased").forObject(AssociatedItem.Type.VERSION, event.getVersion().getName(), Long.valueOf(event.getVersionId())).withAssociatedItems(new AssociatedItem[]{new AffectedProject(event.getVersion().getProjectObject())});
    }

    @Override
    @Nonnull
    public RecordRequest onVersionUnarchiveEvent(@Nonnull VersionUnarchiveEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.version.unarchived").withActionI18nKey("jira.auditing.version.unarchived").forObject(AssociatedItem.Type.VERSION, event.getVersion().getName(), Long.valueOf(event.getVersionId())).withAssociatedItems(new AssociatedItem[]{new AffectedProject(event.getVersion().getProjectObject())});
    }

    @Override
    @Nonnull
    public RecordRequest onVersionReleaseEvent(@Nonnull VersionReleaseEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.version.released").withActionI18nKey("jira.auditing.version.released").forObject(AssociatedItem.Type.VERSION, event.getVersion().getName(), Long.valueOf(event.getVersionId())).withAssociatedItems(new AssociatedItem[]{new AffectedProject(event.getVersion().getProjectObject())});
    }

    @Override
    @Nonnull
    public RecordRequest onVersionMergeEvent(@Nonnull VersionMergeEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.version.merged").withActionI18nKey("jira.auditing.version.merged").forObject(AssociatedItem.Type.VERSION, event.getMergedVersion().getName(), Long.valueOf(event.getMergedVersionId())).withAssociatedItems(new AssociatedItem[]{new AffectedProject(event.getVersion().getProjectObject())}).withChangedValues(this.computeChangedValues(event.getMergedVersion(), event.getVersion()));
    }

    @Override
    @Nonnull
    public Option<RecordRequest> onVersionUpdatedEvent(@Nonnull VersionUpdatedEvent event) {
        List<ChangedValue> values = this.computeChangedValues(event.getOriginalVersion(), event.getVersion());
        if (!values.isEmpty()) {
            return Option.some((Object)new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.version.updated").withActionI18nKey("jira.auditing.version.updated").forObject(AssociatedItem.Type.VERSION, event.getVersion().getName(), Long.valueOf(event.getVersionId())).withAssociatedItems(new AssociatedItem[]{new AffectedProject(event.getVersion().getProjectObject())}).withChangedValues(values));
        }
        return Option.none();
    }

    @Override
    @Nonnull
    public RecordRequest onVersionArchiveEvent(@Nonnull VersionArchiveEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.version.archived").withActionI18nKey("jira.auditing.version.archived").forObject(AssociatedItem.Type.VERSION, event.getVersion().getName(), Long.valueOf(event.getVersionId())).withAssociatedItems(new AssociatedItem[]{new AffectedProject(event.getVersion().getProjectObject())});
    }

    @Nullable
    String getReleaseDate(@Nullable Version version) {
        if (version == null || version.getReleaseDate() == null) {
            return null;
        }
        return new DateTime((Object)version.getReleaseDate()).toString(new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).toFormatter());
    }

    @Nullable
    String getStartDate(@Nullable Version version) {
        if (version == null || version.getStartDate() == null) {
            return null;
        }
        return new DateTime((Object)version.getStartDate()).toString(new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).toFormatter());
    }

    @Nonnull
    protected List<ChangedValue> computeChangedValues(@Nullable Version version, @Nonnull Version currentVersion) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.words.name", version == null ? null : version.getName(), currentVersion.getName()).addIfDifferent("common.words.description", version == null ? null : version.getDescription(), currentVersion.getDescription()).addIfDifferent("version.startdate", this.getStartDate(version), this.getStartDate(currentVersion)).addIfDifferent("version.releasedate", this.getReleaseDate(version), this.getReleaseDate(currentVersion));
        return changedValues.build();
    }
}

