/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.entity;

import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.spi.entity.AuditEntityTransformationService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraAuditEntityTransformationServiceImpl
implements AuditEntityTransformationService {
    private static final Logger log = LoggerFactory.getLogger(JiraAuditEntityTransformationServiceImpl.class);
    private final String baseUrl;
    static final String URI_PATH_USER = "/secure/ViewProfile.jspa?name=";
    static final String URI_PATH_PROJECT = "/secure/ViewProject.jspa?pid=";
    static final String URI_PATH_GROUP = "/secure/ViewGroup.jspa?name=";
    static final String URI_PATH_ISSUE = "/browse/";
    static final String URI_PATH_BOARD = "/secure/RapidView.jspa?rapidView=";
    static final String URI_PATH_DASHBOARD = "/secure/Dashboard.jspa?selectPageId=";
    static final String URI_PATH_FILTER = "/issues/?filter=";
    static final String URI_PATH_SCREEN = "/secure/admin/EditFieldScreen!default.jspa?id=";
    static final String URI_PATH_WORKFLOW = "/secure/admin/workflows/ViewWorkflowSteps.jspa?workflowMode=live&workflowName=";
    static final String URI_PATH_VERSION = "/secure/VersionEdit!default.jspa?versionId=";
    static final String URI_PATH_PROJECT_COMPONENT = "/secure/ComponentEdit!default.jspa?componentId=";
    static final String URI_PATH_RESOLUTION = "/secure/admin/EditResolution!default.jspa?id=";
    static final String URI_PATH_NOTIFICATIONS_SCHEME = "/secure/admin/EditNotifications!default.jspa?schemeId=";
    static final String URI_PATH_PERMISSIONS_SCHEME = "/secure/admin/EditPermissionScheme!default.jspa?schemeId=";
    static final String URI_PATH_WORKFLOW_SCHEME = "/secure/admin/EditWorkflowScheme.jspa?schemeId=";
    static final String URI_PATH_FIELD_CONFIGURATION_SCHEME = "/secure/admin/EditFieldLayoutScheme!default.jspa?id=";
    static final String URI_PATH_APPLICATION_LINK = "/plugins/servlet/applinks/edit/";
    static final String URI_PATH_PLUGIN = "/plugins/servlet/upm#manage/";
    static final String URI_PATH_CLUSTER_NODE = "/plugins/servlet/cluster-monitoring#/providers/com.atlassian.cluster.monitoring.cluster-monitoring-plugin/system-information/";
    static final String URI_PATH_STATUS = "/secure/admin/EditStatus!default.jspa?id=";
    static final String URI_PATH_PRIORITY = "/secure/admin/EditPriority!default.jspa?id=";
    static final String URI_PATH_CUSTOM_FIELD = "/secure/admin/ConfigureCustomField!default.jspa?customFieldId=";
    static final String URI_PATH_ISSUE_SECURITY_LEVEL = "/secure/admin/EditIssueSecurities!default.jspa?schemeId=";
    static final String URI_PATH_COMMENT = "/browse/%s?focusedId=%s&page=com.atlassian.jira.plugin.system.issuetabpanels%%3Acomment-tabpanel#comment-%s";
    static final String URI_PATH_ISSUE_TYPES = "/secure/admin/ViewIssueTypes.jspa#type";
    static final String URI_PATH_OPTION_CONFIG_SCHEMA = "/secure/admin/ConfigureOptionSchemes!default.jspa?schemeId=";
    private final Map<String, UriGenerator<AuditResource>> auditResourceUriGenerators = ImmutableMap.builder().put((Object)"user", (Object)new AuditResourceNameUriGenerator("/secure/ViewProfile.jspa?name=")).put((Object)"project", (Object)new AuditResourceIdUriGenerator("/secure/ViewProject.jspa?pid=")).put((Object)"group", (Object)new AuditResourceNameUriGenerator("/secure/ViewGroup.jspa?name=")).put((Object)"issue", (Object)new AuditResourceNameUriGenerator("/browse/")).put((Object)"board", (Object)new AuditResourceIdUriGenerator("/secure/RapidView.jspa?rapidView=")).put((Object)"dashboard", (Object)new AuditResourceIdUriGenerator("/secure/Dashboard.jspa?selectPageId=")).put((Object)"filter", (Object)new AuditResourceIdUriGenerator("/issues/?filter=")).put((Object)"screen", (Object)new AuditResourceIdUriGenerator("/secure/admin/EditFieldScreen!default.jspa?id=")).put((Object)"workflow", (Object)new AuditResourceNameUriGenerator("/secure/admin/workflows/ViewWorkflowSteps.jspa?workflowMode=live&workflowName=")).put((Object)"version", (Object)new AuditResourceIdUriGenerator("/secure/VersionEdit!default.jspa?versionId=")).put((Object)"project_component", (Object)new AuditResourceIdUriGenerator("/secure/ComponentEdit!default.jspa?componentId=")).put((Object)"resolution", (Object)new AuditResourceIdUriGenerator("/secure/admin/EditResolution!default.jspa?id=")).put((Object)"scheme", (Object)new AuditResourceIdUriGenerator("/secure/admin/EditNotifications!default.jspa?schemeId=")).put((Object)"scheme_permissions", (Object)new AuditResourceIdUriGenerator("/secure/admin/EditPermissionScheme!default.jspa?schemeId=")).put((Object)"scheme_workflows", (Object)new AuditResourceIdUriGenerator("/secure/admin/EditWorkflowScheme.jspa?schemeId=")).put((Object)"scheme_fields", (Object)new AuditResourceIdUriGenerator("/secure/admin/EditFieldLayoutScheme!default.jspa?id=")).put((Object)"application_link", (Object)new AuditResourceIdUriGenerator("/plugins/servlet/applinks/edit/")).put((Object)"plugin", (Object)new AuditResourceIdUriGenerator("/plugins/servlet/upm#manage/")).put((Object)"cluster_node", (Object)new AuditResourceIdUriGenerator("/plugins/servlet/cluster-monitoring#/providers/com.atlassian.cluster.monitoring.cluster-monitoring-plugin/system-information/")).put((Object)"status", (Object)new AuditResourceIdUriGenerator("/secure/admin/EditStatus!default.jspa?id=")).put((Object)"priority", (Object)new AuditResourceIdUriGenerator("/secure/admin/EditPriority!default.jspa?id=")).put((Object)"issue_security_level", (Object)new AuditResourceIdUriGenerator("/secure/admin/EditIssueSecurities!default.jspa?schemeId=")).put((Object)"custom_field", (Object)new AuditResourceCustomFieldIdUriGenerator("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=")).put((Object)"comment", (Object)new AuditResourceCommentUriGenerator()).put((Object)"issue_type", (Object)new AuditResourceIdUriGenerator("/secure/admin/ViewIssueTypes.jspa#type")).put((Object)"field_config_scheme", (Object)new AuditResourceIdUriGenerator("/secure/admin/ConfigureOptionSchemes!default.jspa?schemeId=")).build();
    private final UriGenerator<AuditAuthor> auditAuthorUriGenerator = new AuditAuthorNameUriGenerator("/secure/ViewProfile.jspa?name=");

    public JiraAuditEntityTransformationServiceImpl(ApplicationProperties applicationProperties) {
        this.baseUrl = applicationProperties.getString("jira.baseurl");
    }

    @Nonnull
    public List<AuditEntity> transform(@Nonnull List<AuditEntity> list) {
        return ImmutableList.copyOf(list).stream().map(this::transform).collect(Collectors.toList());
    }

    private AuditEntity transform(AuditEntity entity) {
        List transformedObjects = ImmutableList.copyOf((Collection)entity.getAffectedObjects()).stream().map(auditResource -> this.transform((AuditResource)auditResource, entity.getAuditType().getCategory())).collect(Collectors.toList());
        AuditAuthor transformedAuthor = this.transform(entity.getAuthor());
        return new AuditEntity.Builder(entity).affectedObjects(transformedObjects).author(transformedAuthor).build();
    }

    private AuditResource transform(AuditResource auditResource, String category) {
        if (StringUtils.isNotBlank((CharSequence)auditResource.getUri())) {
            return auditResource;
        }
        if (this.isScheme(auditResource.getType()) && category != null) {
            String adjustedSchemeType = this.adjustSchemeType(auditResource.getType().toLowerCase(), category.toLowerCase());
            return this.replicaWithUri(auditResource, this.getUriGenerator(adjustedSchemeType));
        }
        return this.replicaWithUri(auditResource, this.getUriGenerator(auditResource.getType()));
    }

    private AuditAuthor transform(AuditAuthor author) {
        if (StringUtils.isNotBlank((CharSequence)author.getUri()) || this.isNotUserAuthor(author)) {
            return author;
        }
        return this.replicaWithUri(author);
    }

    private boolean isScheme(String auditResourceType) {
        return "scheme".equalsIgnoreCase(auditResourceType);
    }

    private String adjustSchemeType(String type, String category) {
        String adjustedType = type + "_" + category;
        return this.auditResourceUriGenerators.containsKey(adjustedType) ? adjustedType : type;
    }

    private AuditResource replicaWithUri(AuditResource auditResource, Function<AuditResource, String> uriGenerator) {
        if (uriGenerator == null) {
            return auditResource;
        }
        String uriPart = uriGenerator.apply(auditResource);
        if ("".equals(uriPart)) {
            return auditResource;
        }
        return new AuditResource.Builder(auditResource).uri(this.baseUrl + uriPart).build();
    }

    private AuditAuthor replicaWithUri(AuditAuthor auditAuthor) {
        Object uriPart = this.auditAuthorUriGenerator.apply((Object)auditAuthor);
        if ("".equals(uriPart)) {
            return auditAuthor;
        }
        return new AuditAuthor.Builder(auditAuthor).uri(this.baseUrl + (String)uriPart).build();
    }

    private Function<AuditResource, String> getUriGenerator(String auditResourceType) {
        return this.auditResourceUriGenerators.get(auditResourceType.toLowerCase());
    }

    private boolean isNotUserAuthor(AuditAuthor author) {
        return author.getId().equals(AuditAuthor.ANONYMOUS_AUTHOR.getId()) || author.getId().equals(AuditAuthor.SYSTEM_AUTHOR.getId()) || author.getId().equals(AuditAuthor.UNKNOWN_AUTHOR.getId());
    }

    private static class AuditResourceCommentUriGenerator
    extends UriGenerator<AuditResource> {
        private AuditResourceCommentUriGenerator() {
            super(resource -> {
                String[] params = Objects.requireNonNull(resource.getId()).split(" ");
                if (params.length == 2) {
                    String issueKey = params[0];
                    String commentId = params[1];
                    return String.format(JiraAuditEntityTransformationServiceImpl.URI_PATH_COMMENT, issueKey, commentId, commentId);
                }
                return "";
            });
        }
    }

    private static class AuditResourceCustomFieldIdUriGenerator
    extends UriGenerator<AuditResource> {
        private AuditResourceCustomFieldIdUriGenerator(String basePath) {
            super(basePath, resource -> resource.getId().replace("customfield_", ""));
        }
    }

    private static class AuditAuthorNameUriGenerator
    extends UriGenerator<AuditAuthor> {
        private AuditAuthorNameUriGenerator(String basePath) {
            super(basePath, AuditAuthor::getName);
        }
    }

    private static class AuditResourceNameUriGenerator
    extends UriGenerator<AuditResource> {
        private AuditResourceNameUriGenerator(String basePath) {
            super(basePath, AuditResource::getName);
        }
    }

    private static class AuditResourceIdUriGenerator
    extends UriGenerator<AuditResource> {
        private AuditResourceIdUriGenerator(String basePath) {
            super(basePath, AuditResource::getId);
        }
    }

    private static class UriGenerator<T>
    implements Function<T, String> {
        private final String basePath;
        private final Function<T, String> uriParameterProvider;

        private UriGenerator(String basePath, Function<T, String> uriParameterProvider) {
            this.basePath = basePath;
            this.uriParameterProvider = uriParameterProvider;
        }

        private UriGenerator(Function<T, String> uriPathWithParametersProvider) {
            this.basePath = "";
            this.uriParameterProvider = uriPathWithParametersProvider;
        }

        @Override
        public String apply(T auditObject) {
            String uriParameter = this.uriParameterProvider.apply(auditObject);
            if (StringUtils.isBlank((CharSequence)uriParameter)) {
                log.info("Empty uri parameter for audit object {}", auditObject);
                return "";
            }
            return this.basePath + uriParameter;
        }
    }
}

