/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.migration;

import com.atlassian.audit.api.AuditConsumer;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.spi.migration.LegacyAuditEntityMigrator;
import com.atlassian.jira.auditing.spis.migration.AuditingMigratorLimitSupplier;
import com.atlassian.jira.auditing.spis.migration.MigrationAuditLog;
import com.atlassian.jira.auditing.spis.migration.MigrationAuditingDao;
import com.atlassian.jira.auditing.spis.migration.mapping.AuditEntityConverter;
import com.atlassian.jira.transaction.TransactionSupport;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditingMigrator
implements LegacyAuditEntityMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditingMigrator.class);
    private final AuditEntityConverter auditEntities;
    private final MigrationAuditingDao migrationAuditingDao;
    private final TransactionSupport transactionSupport;
    private final AuditingMigratorLimitSupplier recordLimitSupplier;
    private final int batchSize;

    public AuditingMigrator(@Nonnull AuditEntityConverter auditEntities, @Nonnull MigrationAuditingDao migrationAuditingDao, @Nonnull TransactionSupport transactionSupport, @Nonnull AuditingMigratorLimitSupplier recordLimitSupplier, int batchSize) {
        this.auditEntities = Objects.requireNonNull(auditEntities);
        this.migrationAuditingDao = Objects.requireNonNull(migrationAuditingDao);
        this.transactionSupport = Objects.requireNonNull(transactionSupport);
        this.recordLimitSupplier = Objects.requireNonNull(recordLimitSupplier);
        this.batchSize = batchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void migrate(@Nonnull AuditConsumer auditConsumer) {
        recordLimit = this.recordLimitSupplier.getLimit();
        if (recordLimit <= 0L) {
            AuditingMigrator.LOGGER.warn("Skipping migration because of record limit: {}", (Object)recordLimit);
            return;
        }
        sw = Stopwatch.createStarted();
        AuditingMigrator.LOGGER.info("==== starting audit migration (batch size {}, record limit {}) ====", (Object)this.batchSize, (Object)recordLimit);
        exceptionDuringBatchProcessing = null;
        try {
            auditLogIds = this.migrationAuditingDao.getAuditLogIds(recordLimit);
            AuditingMigrator.LOGGER.info("audit log count {}", (Object)auditLogIds.size());
            partitionedAuditLogIds = Lists.partition(auditLogIds, (int)this.batchSize);
            batchCount = partitionedAuditLogIds.size();
            batchNo = 0;
            for (List ids : partitionedAuditLogIds) {
                batchSw = Stopwatch.createStarted();
                AuditingMigrator.LOGGER.info("== starting batch processing ({}/{}) ==", (Object)(++batchNo), (Object)batchCount);
                try {
                    processedIds = this.transactionSupport.execute((Supplier<Collection>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$migrate$0(java.util.List com.atlassian.audit.api.AuditConsumer ), ()Ljava/util/Collection;)((AuditingMigrator)this, (List)ids, (AuditConsumer)auditConsumer));
                    this.recordLimitSupplier.addAlreadyMigratedCount(processedIds.size());
                    ** GOTO lbl29
                }
                catch (Exception e) {
                    try {
                        exceptionDuringBatchProcessing = e;
                        AuditingMigrator.LOGGER.warn("Exception during batch processing", (Throwable)e);
                    }
                    catch (Throwable var14_15) {
                        AuditingMigrator.LOGGER.info("== ending batch processing ({}/{}). Took {} ==", new Object[]{batchNo, batchCount, batchSw.stop()});
                        throw var14_15;
                    }
lbl29:
                    // 1 sources

                    AuditingMigrator.LOGGER.info("== ending batch processing ({}/{}). Took {} ==", new Object[]{batchNo, batchCount, batchSw.stop()});
                    continue;
                    AuditingMigrator.LOGGER.info("== ending batch processing ({}/{}). Took {} ==", new Object[]{batchNo, batchCount, batchSw.stop()});
                }
            }
        }
        catch (Exception e) {
            AuditingMigrator.LOGGER.error("Exception during audit log migration", (Throwable)e);
            throw new RuntimeException("Audit log migration upgrade task failed", e);
        }
        finally {
            AuditingMigrator.LOGGER.info("==== ending audit migration (batch size {}). Took {} ====", (Object)this.batchSize, (Object)sw.stop());
        }
        if (exceptionDuringBatchProcessing != null) {
            AuditingMigrator.LOGGER.warn("There was exception during processing at least one batch, failing upgrade task");
            throw new RuntimeException("Audit log migration upgrade task failed (processing batch)", exceptionDuringBatchProcessing);
        }
    }

    private Collection<Long> migrateRecords(Collection<MigrationAuditLog> auditLogs, AuditConsumer auditConsumer) {
        LOGGER.debug("transforming records");
        ImmutableSet.Builder convertedIds = ImmutableSet.builder();
        List auditLogsTransformed = auditLogs.stream().map(migrationAuditLog -> {
            AuditEntity converted = this.convert((MigrationAuditLog)migrationAuditLog);
            if (converted != null) {
                convertedIds.add((Object)migrationAuditLog.getAuditLog().getId());
            }
            return converted;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        LOGGER.debug("transforming records done");
        LOGGER.info("Storing entities");
        auditConsumer.accept(auditLogsTransformed);
        LOGGER.info("Storing entities done", auditLogsTransformed);
        return convertedIds.build();
    }

    @Nullable
    private AuditEntity convert(@Nonnull MigrationAuditLog auditLog) {
        try {
            return this.auditEntities.convert(auditLog.getAuditLog(), auditLog.getAuditItems(), auditLog.getChangedValues());
        }
        catch (Exception e) {
            LOGGER.warn("Exception during log conversion: {}", (Object)auditLog.toString(), (Object)e);
            return null;
        }
    }

    private /* synthetic */ Collection lambda$migrate$0(List ids, AuditConsumer auditConsumer) {
        Collection<MigrationAuditLog> auditLogs = this.migrationAuditingDao.getAuditLogs(ids);
        LOGGER.debug("audit logs size: {}", (Object)auditLogs.size());
        Collection<Long> convertedAuditLogIds = this.migrateRecords(auditLogs, auditConsumer);
        this.migrationAuditingDao.removeAuditLogs(auditLogs, convertedAuditLogIds);
        return convertedAuditLogIds;
    }
}

