/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.migration;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.util.Longs;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditingMigratorLimitSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditingMigratorLimitSupplier.class);
    @VisibleForTesting
    static final String JIRA_ADVANCED_AUDIT_LOG_ALREADY_MIGRATED = "jira.advanced.audit.log.already.migrated.count";
    @VisibleForTesting
    static final String JIRA_ADVANCED_AUDIT_LOG_MIGRATION_LIMIT = "jira.advanced.audit.log.migration.limit";
    public static final long MAXIMUM_SUPPORTED_RECORD_COUNT = 10000000L;
    public static final long MIN_FREE_AMOUNT = 1000L;
    private final JiraProperties jiraProperties;
    private final long minFreeRecordAmount;

    public AuditingMigratorLimitSupplier(@Nonnull JiraProperties jiraProperties, long minFreeRecordAmount) {
        this.jiraProperties = Objects.requireNonNull(jiraProperties);
        this.minFreeRecordAmount = minFreeRecordAmount;
    }

    public long getLimit() {
        long limit = this.getRecordLimitFromProperties();
        limit = Math.min(limit, this.getMaximumSupportedRecordCount());
        LOGGER.info("Computed max available record limit for audit log migration task (including minimum free record amount: {}): {}", (Object)this.minFreeRecordAmount, (Object)limit);
        long alreadyMigratedCount = this.getAlreadyMigratedCount();
        limit = Math.max(limit - alreadyMigratedCount, 0L);
        LOGGER.info("Computed record limit for audit log migration task (including minimum free record amount: {}): {}", (Object)this.minFreeRecordAmount, (Object)limit);
        return limit;
    }

    private long getRecordLimitFromProperties() {
        Long limit = this.jiraProperties.getLong(JIRA_ADVANCED_AUDIT_LOG_MIGRATION_LIMIT, Long.valueOf(10000000L));
        if (limit == null) {
            limit = 10000000L;
        }
        if (limit < 0L) {
            limit = 0L;
        }
        limit = Math.min(limit, 10000000L);
        LOGGER.info("Base record limit for audit log migration task: {}", (Object)limit);
        return limit;
    }

    public void addAlreadyMigratedCount(long count) {
        try {
            PluginSettings pluginSettings = this.getGlobalSettings();
            if (pluginSettings != null) {
                pluginSettings.put(JIRA_ADVANCED_AUDIT_LOG_ALREADY_MIGRATED, (Object)Long.toString(this.getAlreadyMigratedCount() + count));
            } else {
                LOGGER.warn("Can't obtain plugin settings");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception during adding migrated record number", (Throwable)e);
        }
    }

    private long getAlreadyMigratedCount() {
        PluginSettings pluginSettings = this.getGlobalSettings();
        if (pluginSettings != null) {
            long alreadyMigrated = Longs.toLongMaybe((String)((String)pluginSettings.get(JIRA_ADVANCED_AUDIT_LOG_ALREADY_MIGRATED))).orElse(0L);
            LOGGER.info("Already migrated record count: {}", (Object)alreadyMigrated);
            return alreadyMigrated;
        }
        LOGGER.warn("Can't obtain plugin settings");
        return 0L;
    }

    private long getMaximumSupportedRecordCount() {
        return 10000000L - this.minFreeRecordAmount;
    }

    @Nullable
    private PluginSettings getGlobalSettings() {
        PluginSettingsFactory pluginSettingsfactory = (PluginSettingsFactory)ComponentAccessor.getOSGiComponentInstanceOfType(PluginSettingsFactory.class);
        if (pluginSettingsfactory != null) {
            return pluginSettingsfactory.createGlobalSettings();
        }
        return null;
    }
}

