/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.migration.mapping;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.jira.auditing.spis.migration.AuditMigrationUtils;
import com.atlassian.jira.model.querydsl.AuditLogDTO;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AuditExtraAttributesConverter
implements Function<AuditLogDTO, Collection<AuditAttribute>> {
    public static final String EVENT_DESCRIPTION_I18N_KEY = "jira.auditing.extra.parameters.event.description";
    @VisibleForTesting
    public static final String EVENT_SOURCE_NAME_I18N_KEY = "jira.auditing.extra.parameters.event.source.name";
    @VisibleForTesting
    public static final String EVENT_LONG_DESCRIPTION_I18N_KEY = "jira.auditing.extra.parameters.event.long.description";
    private final JiraAuthenticationContext authContext;

    public AuditExtraAttributesConverter(JiraAuthenticationContext authContext) {
        this.authContext = authContext;
    }

    @Override
    @Nonnull
    public Collection<AuditAttribute> apply(@Nonnull AuditLogDTO auditLog) {
        ImmutableList.Builder attributesBuilder = ImmutableList.builder();
        if (StringUtils.isNotBlank((CharSequence)auditLog.getEventSourceName())) {
            attributesBuilder.add((Object)AuditMigrationUtils.newAuditAttributeWithNameTranslation(EVENT_SOURCE_NAME_I18N_KEY, this.translate(EVENT_SOURCE_NAME_I18N_KEY), auditLog.getEventSourceName()));
        }
        if (StringUtils.isNotBlank((CharSequence)auditLog.getDescription())) {
            attributesBuilder.add((Object)AuditMigrationUtils.newAuditAttributeWithNameTranslation(EVENT_DESCRIPTION_I18N_KEY, this.translate(EVENT_DESCRIPTION_I18N_KEY), auditLog.getDescription()));
        }
        if (StringUtils.isNotBlank((CharSequence)auditLog.getLongDescription())) {
            attributesBuilder.add((Object)AuditMigrationUtils.newAuditAttributeWithNameTranslation(EVENT_LONG_DESCRIPTION_I18N_KEY, this.translate(EVENT_LONG_DESCRIPTION_I18N_KEY), auditLog.getLongDescription()));
        }
        return attributesBuilder.build();
    }

    private String translate(String i18nKey) {
        return this.getI18nHelper().getText(i18nKey);
    }

    private I18nHelper getI18nHelper() {
        return this.authContext.getI18nHelper();
    }
}

