/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFileStoreProvider;
import com.atlassian.jira.avatar.AvatarFilenames;
import com.atlassian.jira.avatar.AvatarImageDataProvider;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEventPublisher;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarImageDataStorage {
    private static final Logger log = LoggerFactory.getLogger(AvatarImageDataStorage.class);
    private final AvatarFileStoreProvider avatarFileStoreProvider;
    private final JiraHomeChangeEventPublisher jiraHomeChangeEventPublisher;

    public AvatarImageDataStorage(AvatarFileStoreProvider avatarFileStoreProvider, JiraHomeChangeEventPublisher jiraHomeChangeEventPublisher) {
        this.avatarFileStoreProvider = Objects.requireNonNull(avatarFileStoreProvider);
        this.jiraHomeChangeEventPublisher = Objects.requireNonNull(jiraHomeChangeEventPublisher);
    }

    public String getNextFilenameStub() {
        return UUID.randomUUID().toString();
    }

    public void storeAvatarFiles(Avatar avatar, AvatarImageDataProvider imageDataProvider) throws IOException {
        ArrayList storedFiles = Lists.newArrayList();
        try {
            for (Avatar.Size size : Avatar.Size.values()) {
                FileStore.Path imagePath = this.getAvatarPath(avatar, size);
                storedFiles.add(imagePath);
                imagePath.fileWriter().write(outputStream -> imageDataProvider.storeImage(size, outputStream));
            }
        }
        catch (IOException | RuntimeException e) {
            this.cleanup(storedFiles);
            throw e;
        }
        this.jiraHomeChangeEventPublisher.publishIfApplicable(JiraHomeChangeEvent.Action.FILE_ADD, JiraHomeChangeEvent.FileType.AVATAR, storedFiles);
    }

    private void cleanup(List<FileStore.Path> files) {
        for (FileStore.Path path : files) {
            try {
                path.deleteFile();
            }
            catch (IOException e) {
                log.warn(String.format("Created avatar images but then failed to store and then failed to delete '%s' in cleanup.", path));
            }
        }
    }

    private FileStore.Path getAvatarPath(Avatar avatar, Avatar.Size size) {
        return this.avatarFileStoreProvider.getBasePath().path(new String[]{AvatarFilenames.getAvatarFilename(avatar, size)});
    }
}

