/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.avatar.AvatarFileStoreProvider;
import com.atlassian.jira.config.filestore.FileStoreAssociationTarget;
import com.atlassian.jira.config.filestore.FileStoreConfig;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.filestore.FileStoreAnalyticInfo;
import com.atlassian.jira.filestore.FileStoreInformation;
import java.util.Objects;
import javax.annotation.Nonnull;

public class FileSystemAvatarFileStoreProvider
implements AvatarFileStoreProvider {
    private static final String JIRA_HOME_HEADING_KEY = "admin.avatarsettings.avatar.shared.home";
    private final FileStores fileStores;
    private static final String AVATAR_DIRECTORY = "avatars";

    public FileSystemAvatarFileStoreProvider(FileStores fileStores) {
        this.fileStores = Objects.requireNonNull(fileStores);
    }

    @Override
    @Nonnull
    public FileStore.Path getBasePath() {
        return this.fileStores.getHomePath().path(new String[]{"data", AVATAR_DIRECTORY});
    }

    @Override
    public boolean isStoreInJiraHome() {
        return true;
    }

    @Override
    public FileStoreInformation getInformation() {
        String avatarPath = this.fileStores.getHomeFilesystemPath().path(new String[]{"data", AVATAR_DIRECTORY}).asJavaFile().getAbsolutePath();
        return new FileStoreInformation.Builder().setHeadingKey(JIRA_HOME_HEADING_KEY).addStringEntry(avatarPath).build();
    }

    @Override
    @Nonnull
    public FileStoreAnalyticInfo getFileStoreAnalyticInfo() {
        return FileStoreAnalyticInfo.fileSystemAnalyticInfo();
    }

    @Override
    public FileStoreConfig getFileStoreConfig() {
        return null;
    }

    @Override
    public FileStoreAssociationTarget getAssociationTarget() {
        return FileStoreAssociationTarget.AVATARS;
    }
}

