/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.admin;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.admin.ApplicationProperty;
import com.atlassian.jira.bc.admin.ApplicationPropertyMetadata;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationPropertiesStore;
import com.atlassian.jira.event.config.ApplicationPropertyChangeEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.validation.Validated;
import com.atlassian.validation.Validator;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationPropertiesServiceImpl
implements ApplicationPropertiesService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationPropertiesServiceImpl.class);
    private final ApplicationPropertiesStore applicationPropertiesStore;
    private EventPublisher eventPublisher;
    private PermissionManager permissionManager;
    private JiraAuthenticationContext authenticationContext;
    private final Predicate<ApplicationProperty> featurePredicate;
    private FeatureManager featureManager;

    public ApplicationPropertiesServiceImpl(ApplicationPropertiesStore applicationPropertiesStore, EventPublisher eventPublisher, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, FeatureManager featureManager) {
        this.applicationPropertiesStore = applicationPropertiesStore;
        this.eventPublisher = eventPublisher;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.featureManager = featureManager;
        this.featurePredicate = input -> {
            if (input.getMetadata().getRequiredFeatureKey() == null) {
                return true;
            }
            if (((Boolean)input.getMetadata().getRequiredFeatureKey().second()).booleanValue()) {
                return this.featureManager.isEnabled((String)input.getMetadata().getRequiredFeatureKey().first());
            }
            return !this.featureManager.isEnabled((String)input.getMetadata().getRequiredFeatureKey().first());
        };
    }

    @Override
    public List<ApplicationProperty> getEditableApplicationProperties(String permissionLevel, String keyFilter) {
        ApplicationPropertiesService.EditPermissionLevel editPermission;
        if (permissionLevel == null || permissionLevel.isEmpty()) {
            if (this.isSysAdmin()) {
                return this.getEditableApplicationProperties(ApplicationPropertiesService.EditPermissionLevel.SYSADMIN, keyFilter);
            }
            if (this.isNormalAdmin()) {
                return this.getEditableApplicationProperties(ApplicationPropertiesService.EditPermissionLevel.ADMIN, keyFilter);
            }
            return null;
        }
        try {
            editPermission = ApplicationPropertiesService.EditPermissionLevel.valueOf(permissionLevel.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            log.error("Unexpected", (Throwable)iae);
            return null;
        }
        return this.getEditableApplicationProperties(editPermission, keyFilter);
    }

    @Override
    public List<ApplicationProperty> getEditableAdvancedProperties() throws DataAccessException {
        if (!this.hasAdministrativePermissions()) {
            return Collections.emptyList();
        }
        return this.applicationPropertiesStore.getEditableAdvancedProperties(this.isSysAdmin() ? ApplicationPropertiesService.EditPermissionLevel.SYSADMIN : ApplicationPropertiesService.EditPermissionLevel.ADMIN);
    }

    @Override
    public boolean hasAdministrativePermissions() {
        return this.isNormalAdmin();
    }

    private boolean isNormalAdmin() {
        return this.permissionManager.hasPermission(0, this.authenticationContext.getUser());
    }

    private boolean isSysAdmin() {
        return this.permissionManager.hasPermission(44, this.authenticationContext.getLoggedInUser());
    }

    @Override
    public boolean hasPermissionForLevel(String permissionLevel) {
        ApplicationPropertiesService.EditPermissionLevel editPermission;
        if (StringUtils.isBlank((CharSequence)permissionLevel)) {
            return this.hasAdministrativePermissions();
        }
        try {
            editPermission = ApplicationPropertiesService.EditPermissionLevel.valueOf(permissionLevel.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            log.error("Unexpected", (Throwable)iae);
            return false;
        }
        if (editPermission == ApplicationPropertiesService.EditPermissionLevel.SYSADMIN || editPermission == ApplicationPropertiesService.EditPermissionLevel.SYSADMIN_ONLY) {
            return this.isSysAdmin();
        }
        if (editPermission == ApplicationPropertiesService.EditPermissionLevel.ADMIN) {
            return this.hasAdministrativePermissions();
        }
        return false;
    }

    @Override
    public List<ApplicationProperty> getEditableApplicationProperties(ApplicationPropertiesService.EditPermissionLevel permissionLevel, String keyFilter) throws DataAccessException {
        return Lists.newArrayList((Iterable)Iterables.filter(this.applicationPropertiesStore.getEditableApplicationProperties(permissionLevel, keyFilter), this.featurePredicate));
    }

    @Override
    public ApplicationProperty getApplicationProperty(String key) {
        return this.applicationPropertiesStore.getApplicationPropertyFromKey(key);
    }

    @Override
    public Validated<ApplicationProperty> setApplicationProperty(String key, String value) {
        ApplicationProperty applicationProperty = this.applicationPropertiesStore.getApplicationPropertyFromKey(key);
        String oldValue = applicationProperty.getCurrentValue();
        log.debug("validating value: " + value);
        ApplicationPropertyMetadata metadata = applicationProperty.getMetadata();
        Validator.Result result = metadata.validate(value);
        if (result.isValid()) {
            applicationProperty = this.applicationPropertiesStore.setApplicationProperty(key, value);
            this.eventPublisher.publish((Object)this.createEvent(metadata, oldValue, value));
        }
        return new Validated<ApplicationProperty>(result, applicationProperty);
    }

    protected ApplicationPropertyChangeEvent createEvent(ApplicationPropertyMetadata metadata, String oldValue, String newValue) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("metadata", Assertions.notNull((String)"metadata", (Object)metadata));
        params.put("oldValue", oldValue);
        params.put("newValue", newValue);
        return new ApplicationPropertyChangeEvent(params);
    }
}

