/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.config;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.issue.status.category.StatusCategoryChangedAnalyticsEvent;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DefaultStatusService
implements StatusService {
    private final StatusManager statusManager;
    private final I18nHelper i18nHelper;
    private final ConstantsManager constantsManager;
    private final PermissionManager permissionManager;
    private final WorkflowManager workflowManager;
    private final EventPublisher eventPublisher;
    private final StatusCategoryManager statusCategoryManager;
    private final WorkflowSchemeManager workflowSchemeManager;

    public DefaultStatusService(StatusManager statusManager, I18nHelper i18nHelper, ConstantsManager constantsManager, PermissionManager permissionManager, WorkflowManager workflowManager, EventPublisher eventPublisher, StatusCategoryManager statusCategoryManager, WorkflowSchemeManager workflowSchemeManager) {
        this.statusManager = statusManager;
        this.i18nHelper = i18nHelper;
        this.constantsManager = constantsManager;
        this.permissionManager = permissionManager;
        this.workflowManager = workflowManager;
        this.eventPublisher = eventPublisher;
        this.statusCategoryManager = statusCategoryManager;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    public ServiceOutcome<Status> createStatus(ApplicationUser user, String name, String description, String iconUrl, StatusCategory statusCategory) {
        ServiceResult validation = this.validateCreateStatus(user, name = StringUtils.trimToNull((String)name), description = StringUtils.trimToNull((String)description), iconUrl = StringUtils.trimToNull((String)iconUrl), statusCategory);
        Status status = validation.isValid() ? (statusCategory == null ? this.statusManager.createStatus(name, description, iconUrl, this.statusCategoryManager.getDefaultStatusCategory()) : this.statusManager.createStatus(name, description, iconUrl, statusCategory)) : null;
        return ServiceOutcomeImpl.from(validation.getErrorCollection(), status);
    }

    public ServiceOutcome<Status> editStatus(ApplicationUser user, Status status, String name, String description, String iconUrl, StatusCategory statusCategory) {
        ServiceResult validation = this.validateEditStatus(user, status, name = StringUtils.trimToNull((String)name), description = StringUtils.trimToNull((String)description), iconUrl = StringUtils.trimToNull((String)iconUrl), statusCategory);
        if (validation.isValid()) {
            boolean categoriesPresent = status.getStatusCategory() != null && statusCategory != null;
            String oldCategoryKey = null;
            String newCategoryKey = null;
            String oldStatusName = null;
            if (categoriesPresent) {
                oldCategoryKey = status.getStatusCategory().getKey();
                newCategoryKey = statusCategory.getKey();
                oldStatusName = status.getName();
            }
            if (statusCategory == null) {
                this.statusManager.editStatus(status, name, description, iconUrl);
            } else {
                this.statusManager.editStatus(status, name, description, iconUrl, statusCategory);
            }
            if (categoriesPresent && !newCategoryKey.equals(oldCategoryKey)) {
                this.eventPublisher.publish((Object)new StatusCategoryChangedAnalyticsEvent(oldCategoryKey, newCategoryKey, oldStatusName, status.getName()));
            }
        }
        return ServiceOutcomeImpl.from(validation.getErrorCollection(), status);
    }

    public ServiceResult validateCreateStatus(ApplicationUser user, String name, String description, String iconUrl, StatusCategory statusCategory) {
        SimpleErrorCollection ec = this.genericPermissionCheck(user, "admin.errors.not.allowed.to.create.status");
        if (ec.hasAnyErrors()) {
            return new ServiceResultImpl((ErrorCollection)ec);
        }
        return this.validateCommon(user, null, name, description, iconUrl, statusCategory);
    }

    public ServiceResult validateEditStatus(ApplicationUser user, Status status, String name, String description, String iconUrl, StatusCategory statusCategory) {
        SimpleErrorCollection ec = this.genericPermissionCheck(user, "admin.errors.not.allowed.to.edit.status");
        if (ec.hasAnyErrors()) {
            return new ServiceResultImpl((ErrorCollection)ec);
        }
        ServiceResult serviceResult = this.validateCommon(user, status, name, description, iconUrl, statusCategory);
        if (status == null) {
            serviceResult.getErrorCollection().addErrorMessage(this.i18nHelper.getText("admin.errors.must.specify.valid.status.object"));
        }
        return serviceResult;
    }

    private ServiceResult validateCommon(ApplicationUser user, Status status, String name, String description, String iconUrl, StatusCategory statusCategory) {
        Status existingStatus;
        name = StringUtils.trimToNull((String)name);
        iconUrl = StringUtils.trimToNull((String)iconUrl);
        SimpleErrorCollection ec = new SimpleErrorCollection();
        if (StringUtils.isBlank((CharSequence)name)) {
            ec.addError("name", this.i18nHelper.getText("admin.errors.must.specify.name"));
        }
        if (StringUtils.length((CharSequence)name) > 60) {
            ec.addError("name", this.i18nHelper.getText("admin.common.errors.exceeds.max.name.length", (Object)60));
        }
        if (!((existingStatus = this.constantsManager.getStatusByNameIgnoreCase(name)) == null || status != null && existingStatus.getId().equals(status.getId()))) {
            ec.addError("name", this.i18nHelper.getText("admin.errors.status.with.name.exists"));
        }
        if (StringUtils.isBlank((CharSequence)iconUrl)) {
            ec.addError("iconurl", this.i18nHelper.getText("admin.errors.must.specify.url.for.status.edit"));
        }
        if (statusCategory == null && this.isStatusAsLozengeEnabled()) {
            ec.addError("statusCategory", this.i18nHelper.getText("admin.errors.must.specify.status.category"));
        }
        return new ServiceResultImpl((ErrorCollection)ec);
    }

    public Status getStatusById(ApplicationUser user, String id) {
        return this.statusManager.getStatus(id);
    }

    public ServiceResult validateRemoveStatus(ApplicationUser user, Status status) {
        SimpleErrorCollection ec = this.genericPermissionCheck(user, "admin.errors.not.allowed.to.remove.status");
        if (ec.hasAnyErrors()) {
            return new ServiceResultImpl((ErrorCollection)ec);
        }
        Status systemStatus = this.statusManager.getStatus(status.getId());
        if (systemStatus == null || !systemStatus.equals(status)) {
            ec.addErrorMessage(this.i18nHelper.getText("admin.error.given.status.does.not.exist"));
        }
        if (this.hasAssociatedWorkflows(status)) {
            ec.addErrorMessage(this.i18nHelper.getText("admin.error.status.is.associated.with.workflow"));
        }
        return new ServiceResultImpl((ErrorCollection)ec);
    }

    public ServiceResult removeStatus(ApplicationUser user, Status status) {
        ServiceResult validationResult = this.validateRemoveStatus(user, status);
        if (!validationResult.isValid()) {
            return validationResult;
        }
        SimpleErrorCollection ec = new SimpleErrorCollection();
        try {
            this.statusManager.removeStatus(((Status)Preconditions.checkNotNull((Object)status)).getId());
        }
        catch (IllegalArgumentException e) {
            ec.addErrorMessage(e.getLocalizedMessage());
        }
        return new ServiceResultImpl((ErrorCollection)ec);
    }

    private SimpleErrorCollection genericPermissionCheck(ApplicationUser user, String errorMessage) {
        SimpleErrorCollection ec = new SimpleErrorCollection();
        if (!this.permissionManager.hasPermission(0, user)) {
            ec.addErrorMessage(this.i18nHelper.getText(errorMessage));
        }
        return ec;
    }

    public ServiceOutcome<List<JiraWorkflow>> getAssociatedWorkflows(ApplicationUser user, Status status) {
        List allWorkflows = this.workflowManager.getWorkflowsIncludingDrafts();
        List workflows = (List)allWorkflows.stream().filter(workflow -> DefaultStatusService.containsStatus(status).test((JiraWorkflow)workflow)).collect(ImmutableList.toImmutableList());
        return ServiceOutcomeImpl.ok(workflows);
    }

    public ServiceResult moveStatusUp(ApplicationUser user, String id) {
        SimpleErrorCollection ec = this.genericPermissionCheck(user, "admin.errors.not.allowed.to.edit.status");
        if (ec.hasAnyErrors()) {
            return new ServiceResultImpl((ErrorCollection)ec);
        }
        this.statusManager.moveStatusUp(id);
        return new ServiceResultImpl((ErrorCollection)ec);
    }

    public ServiceResult moveStatusDown(ApplicationUser user, String id) {
        SimpleErrorCollection ec = this.genericPermissionCheck(user, "admin.errors.not.allowed.to.edit.status");
        if (ec.hasAnyErrors()) {
            return new ServiceResultImpl((ErrorCollection)ec);
        }
        this.statusManager.moveStatusDown(id);
        return new ServiceResultImpl((ErrorCollection)ec);
    }

    private boolean hasAssociatedWorkflows(Status status) {
        List workflows = this.workflowManager.getWorkflowsIncludingDrafts();
        return workflows.stream().anyMatch(DefaultStatusService.containsStatus(status));
    }

    public static Predicate<JiraWorkflow> containsStatus(Status status) {
        return input -> input.getLinkedStatusObjects().contains(status);
    }

    public boolean isStatusAsLozengeEnabled() {
        return this.statusCategoryManager.isStatusAsLozengeEnabled();
    }

    public Stream<Status> findStatuses(@Nonnull String substring, @Nonnull Set<Long> projectIds, @Nonnull Set<String> issueTypeIds) {
        Stream<Status> statusStream = this.findStatuses(projectIds, issueTypeIds).distinct();
        if (StringUtils.isNotEmpty((CharSequence)substring)) {
            Pattern searchPattern = ConstantsManager.createIssueConstantNameSearchPattern((String)substring);
            statusStream = statusStream.filter(status -> searchPattern.matcher(status.getNameTranslation()).matches());
        }
        return statusStream;
    }

    private Stream<Status> findStatuses(Set<Long> projectIds, Set<String> issueTypeIds) {
        if (projectIds.isEmpty()) {
            return this.workflowManager.getActiveWorkflows().stream().flatMap(workflow -> workflow.getLinkedStatusObjects().stream());
        }
        Set<String> finalIssueTypeIds = issueTypeIds.isEmpty() ? this.constantsManager.getAllIssueTypeIds() : issueTypeIds;
        return projectIds.stream().flatMap(projectId -> finalIssueTypeIds.stream().map(issueTypeId -> this.workflowManager.getWorkflow(projectId, issueTypeId))).flatMap(workflow -> workflow.getLinkedStatusObjects().stream());
    }
}

