/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.group;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.group.GroupRelationshipChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import io.atlassian.fugue.extras.ImmutableMaps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupsToApplicationsSeatingHelper {
    private static final Logger log = LoggerFactory.getLogger(GroupsToApplicationsSeatingHelper.class);
    private final ApplicationRoleManager applicationRoleManager;
    private final GroupRelationshipChecker relationshipChecker;

    public GroupsToApplicationsSeatingHelper(ApplicationRoleManager applicationRoleManager, GroupRelationshipChecker relationshipChecker) {
        this.applicationRoleManager = applicationRoleManager;
        this.relationshipChecker = relationshipChecker;
    }

    public Map<ApplicationRole, Set<ApplicationUser>> rolesToBeAddedForSeatingCountPurpose(Set<ApplicationUser> users, Set<String> groupsToBeAdded) {
        HashMultimap userToRoles = HashMultimap.create();
        for (ApplicationUser user : users) {
            userToRoles.putAll((Object)user, this.calculateRolesToBeAdded(user, groupsToBeAdded));
        }
        return ImmutableMaps.transformValue((Map)((HashMultimap)Multimaps.invertFrom((Multimap)userToRoles, (Multimap)HashMultimap.create())).asMap(), ImmutableSet::copyOf);
    }

    public Set<ApplicationRole> findEffectiveApplications(Optional<Long> userDirectoryId, Set<ApplicationRole> roles) {
        Set defaultGroupsNames = (Set)roles.stream().map(ApplicationRole::getDefaultGroups).flatMap(Collection::stream).map(Group::getName).collect(CollectorsUtil.toImmutableSet());
        return this.findEffectiveApplicationsByGroups(userDirectoryId, defaultGroupsNames);
    }

    public Set<ApplicationRole> findEffectiveApplicationsByGroups(Optional<Long> userDirectoryId, Set<String> groupsNames) {
        if (!userDirectoryId.isPresent()) {
            log.debug("Performing approximate Application Check check against {}", groupsNames);
        }
        return (Set)this.applicationRoleManager.getRoles().stream().filter(role -> role.getGroups().stream().map(Group::getName).anyMatch(roleGivingGroup -> groupsNames.stream().anyMatch(groupName -> this.relationshipChecker.isGroupEqualOrNested(userDirectoryId, (String)groupName, (String)roleGivingGroup)))).collect(CollectorsUtil.toImmutableSet());
    }

    private Set<ApplicationRole> calculateRolesToBeAdded(ApplicationUser user, Set<String> groupsToBeAdded) {
        if (log.isTraceEnabled()) {
            log.trace("Calculating application access for {} with groups {}", (Object)user, groupsToBeAdded);
        }
        Set existingUserRoles = this.applicationRoleManager.getRolesForUser(user);
        Set<ApplicationRole> rolesToBeAdded = this.findEffectiveApplicationsByGroups(Optional.ofNullable(user.getDirectoryId()), groupsToBeAdded);
        Set rolesToBeAddedToThisUser = Sets.difference(rolesToBeAdded, (Set)existingUserRoles).copyInto(new HashSet());
        Sets.SetView effectiveRolesAfterAdd = Sets.union((Set)existingUserRoles, rolesToBeAdded);
        if (effectiveRolesAfterAdd.stream().anyMatch(r -> !r.getKey().equals((Object)ApplicationKeys.CORE))) {
            rolesToBeAddedToThisUser.remove(this.applicationRoleManager.getRole(ApplicationKeys.CORE).getOrNull());
        }
        return rolesToBeAddedToThisUser;
    }
}

