/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.group.search;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.GroupComparator;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.jira.bc.group.search.GroupPickerSearchService;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;

public class GroupPickerSearchServiceImpl
implements GroupPickerSearchService {
    private static final GroupQuery<Group> ALL_GROUPS_QUERY = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
    private final CrowdService crowdService;
    private final UserManager userManager;

    public GroupPickerSearchServiceImpl(CrowdService crowdService, UserManager userManager) {
        this.crowdService = crowdService;
        this.userManager = userManager;
    }

    public List<Group> findGroups(String query) {
        TreeSet<Group> matchingGroups = new TreeSet<Group>(GroupComparator.GROUP_COMPARATOR);
        TreeSet<Group> exactMatches = new TreeSet<Group>(GroupComparator.GROUP_COMPARATOR);
        Set<Group> groups = this.getAllCrowdGroups();
        if (StringUtils.isBlank((CharSequence)query)) {
            matchingGroups.addAll(groups);
            return new ArrayList<Group>(matchingGroups);
        }
        for (Group group : groups) {
            if (group.getName().equalsIgnoreCase(query)) {
                exactMatches.add(group);
                continue;
            }
            if (!group.getName().contains(query)) continue;
            matchingGroups.add(group);
        }
        ArrayList<Group> ret = new ArrayList<Group>();
        ret.addAll(exactMatches);
        ret.addAll(matchingGroups);
        return ret;
    }

    public Group getGroupByName(String groupName) {
        return this.userManager.getGroup(groupName);
    }

    private Set<Group> getAllCrowdGroups() {
        Iterable crowdGroups = this.crowdService.search(ALL_GROUPS_QUERY);
        if (crowdGroups instanceof Set) {
            return (Set)crowdGroups;
        }
        if (crowdGroups instanceof Collection) {
            return new HashSet<Group>((Collection)crowdGroups);
        }
        return StreamSupport.stream(crowdGroups.spliterator(), false).collect(Collectors.toSet());
    }
}

