/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.issue.fields.FieldConfigSchemeParameters;
import com.atlassian.jira.bc.issue.fields.FieldConfigSchemeService;
import com.atlassian.jira.config.DCFeatureLicenseChecker;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DefaultValueField;
import com.atlassian.jira.issue.fields.FieldId;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@Internal
public class FieldConfigSchemeServiceImpl
implements FieldConfigSchemeService {
    private static final String REST_FIELD_CONFIG_SCHEME_ERROR_NOT_FOUND = "rest.field.config.scheme.error.not.found";
    private static final String REST_FIELD_CONFIG_SCHEME_ERROR_CONFIGURATION_LOCKED = "rest.field.config.scheme.error.configuration.locked";
    private static final String REST_FIELD_CONFIG_SCHEME_ERROR_CONFIGURATION_MANAGED = "rest.field.config.scheme.error.configuration.managed";
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final FieldConfigManager fieldConfigManager;
    private final ProjectManager projectManager;
    private final FieldManager fieldManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper i18n;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final DCFeatureLicenseChecker licenseChecker;
    protected final CustomFieldManager customFieldManager;

    public FieldConfigSchemeServiceImpl(FieldConfigSchemeManager fieldConfigSchemeManager, FieldConfigManager fieldConfigManager, ProjectManager projectManager, FieldManager fieldManager, GlobalPermissionManager globalPermissionManager, I18nHelper i18n, ManagedConfigurationItemService managedConfigurationItemService, DCFeatureLicenseChecker licenseChecker, CustomFieldManager customFieldManager) {
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.fieldConfigManager = fieldConfigManager;
        this.projectManager = projectManager;
        this.fieldManager = fieldManager;
        this.globalPermissionManager = globalPermissionManager;
        this.i18n = i18n;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.licenseChecker = licenseChecker;
        this.customFieldManager = customFieldManager;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ServiceOutcome<FieldConfigScheme> getFieldConfigScheme(ApplicationUser user, String fieldId, long configSchemeId) {
        FieldConfigScheme configScheme = this.fieldConfigSchemeManager.getFieldConfigScheme(Long.valueOf(configSchemeId));
        ErrorCollection validationResult = this.validateGetContext(user, fieldId, configScheme);
        if (validationResult.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(validationResult);
        }
        return ServiceOutcomeImpl.ok(configScheme);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ServiceOutcome<List<FieldConfigScheme>> getFieldConfigSchemesForField(ApplicationUser user, String fieldId) {
        ConfigurableField configurableField = this.fieldManager.getConfigurableField(fieldId);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.verifyUserHasPermissions((ErrorCollection)errors, user)) {
            return ServiceOutcomeImpl.from((ErrorCollection)errors);
        }
        if (Objects.isNull(configurableField)) {
            errors.addErrorMessage(this.i18n.getText("rest.field.config.scheme.error.field.not.found"), ErrorCollection.Reason.NOT_FOUND);
        }
        if (errors.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)errors);
        }
        List schemesForField = this.fieldConfigSchemeManager.getConfigSchemesForField(configurableField);
        return ServiceOutcomeImpl.ok(schemesForField);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ServiceOutcome<FieldConfigScheme> createFieldConfigScheme(ApplicationUser user, FieldConfigSchemeParameters parameters) {
        ErrorCollection validationResult = this.validateCreateOrUpdate(user, parameters);
        if (validationResult.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(validationResult);
        }
        List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)parameters.isGlobal(), (Long[])parameters.getProjectIds(), (ProjectManager)this.projectManager);
        FieldConfigScheme created = this.fieldConfigSchemeManager.createFieldConfigScheme(parameters.getFieldConfigScheme(), contexts, parameters.getIssueTypes(), parameters.getField());
        FieldConfigSchemeServiceImpl.setDefaultValueIfSupported(created, parameters.getDefaultValue());
        return ServiceOutcomeImpl.ok(created);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ServiceOutcome<FieldConfigScheme> updateFieldConfigScheme(ApplicationUser user, FieldConfigSchemeParameters parameters) {
        Preconditions.checkNotNull((Object)user, (Object)"User must be set");
        Preconditions.checkNotNull((Object)parameters.getFieldConfigScheme().getId(), (Object)"FieldConfigScheme has to have an ID");
        ErrorCollection errors = this.validateCreateOrUpdate(user, parameters);
        if (errors.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)parameters.isGlobal(), (Long[])parameters.getProjectIds(), (ProjectManager)this.projectManager);
        HashMap<String, FieldConfig> configs = new HashMap<String, FieldConfig>();
        for (IssueType issueType : parameters.getIssueTypes()) {
            configs.put(issueType == null ? null : issueType.getId(), this.fieldConfigManager.getFieldConfig(parameters.getFieldConfigScheme().getOneAndOnlyConfig().getId()));
        }
        FieldConfigScheme fieldConfigScheme = new FieldConfigScheme.Builder(parameters.getFieldConfigScheme()).setConfigs(configs).toFieldConfigScheme();
        FieldConfigScheme updated = this.fieldConfigSchemeManager.updateFieldConfigScheme(fieldConfigScheme, contexts, parameters.getField());
        FieldConfigSchemeServiceImpl.setDefaultValueIfSupported(updated, parameters.getDefaultValue());
        this.fieldManager.refresh();
        return ServiceOutcomeImpl.ok(updated);
    }

    private static void setDefaultValueIfSupported(FieldConfigScheme fieldConfigScheme, Object defaultValue) {
        if (fieldConfigScheme.getField() instanceof DefaultValueField) {
            ((DefaultValueField)fieldConfigScheme.getField()).getDefaultValueOperations().setDefaultValue(fieldConfigScheme.getOneAndOnlyConfig(), defaultValue);
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ServiceResult deleteFieldConfigScheme(ApplicationUser user, String fieldId, long configSchemeId) {
        FieldConfigScheme configScheme = this.fieldConfigSchemeManager.getFieldConfigScheme(Long.valueOf(configSchemeId));
        ErrorCollection validationResult = this.validateDelete(user, fieldId, configScheme);
        if (validationResult.hasAnyErrors()) {
            return new ServiceResultImpl(validationResult);
        }
        this.fieldConfigSchemeManager.removeFieldConfigScheme(Long.valueOf(configSchemeId));
        this.fieldManager.refresh();
        return new ServiceResultImpl();
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ServiceOutcome<Boolean> isGlobalAvailableForUpdate(ApplicationUser loggedInUser, String fieldId, long configSchemeId) {
        FieldId id = FieldId.fromFullId(fieldId);
        FieldConfigScheme configScheme = this.fieldConfigSchemeManager.getFieldConfigScheme(Long.valueOf(configSchemeId));
        ConfigurableField field = configScheme.getField();
        ErrorCollection validationResult = this.validateGetAvailableProjectsForUpdate(loggedInUser, field, fieldId);
        if (validationResult.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(validationResult);
        }
        return ServiceOutcomeImpl.ok(this.isGlobalAvailable(id, field, configScheme));
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ServiceOutcome<Boolean> isGlobalAvailableForCreate(ApplicationUser loggedInUser, String fieldId) {
        FieldId id = FieldId.fromFullId(fieldId);
        ConfigurableField field = this.fieldManager.getConfigurableField(fieldId);
        ErrorCollection validationResult = this.validateGetAvailableProjects(loggedInUser, field);
        if (validationResult.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(validationResult);
        }
        return ServiceOutcomeImpl.ok(this.isGlobalAvailable(id, field, null));
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ServiceOutcome<List<Project>> getAvailableProjectsForUpdate(ApplicationUser loggedInUser, String fieldId, long configSchemeId) {
        FieldConfigScheme configScheme = this.fieldConfigSchemeManager.getFieldConfigScheme(Long.valueOf(configSchemeId));
        if (Objects.isNull(configScheme)) {
            return ServiceOutcomeImpl.from((ErrorCollection)new SimpleErrorCollection(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_NOT_FOUND), ErrorCollection.Reason.NOT_FOUND));
        }
        ConfigurableField field = configScheme.getField();
        ErrorCollection validationResult = this.validateGetAvailableProjectsForUpdate(loggedInUser, field, fieldId);
        if (validationResult.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(validationResult);
        }
        List<Project> projects = this.getAvailableProjectsForField(field.getAssociatedProjectObjects(), configScheme.getAssociatedProjectObjects());
        return ServiceOutcomeImpl.ok(projects);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ServiceOutcome<List<Project>> getAvailableProjectsForCreate(ApplicationUser loggedInUser, String fieldId) {
        ConfigurableField field = this.fieldManager.getConfigurableField(fieldId);
        ErrorCollection validationResult = this.validateGetAvailableProjects(loggedInUser, field);
        if (validationResult.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(validationResult);
        }
        List<Project> projects = this.getAvailableProjectsForField(field.getAssociatedProjectObjects(), Collections.emptyList());
        return ServiceOutcomeImpl.ok(projects);
    }

    private ErrorCollection validateGetAvailableProjects(ApplicationUser user, ConfigurableField<?> field) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.verifyUserHasPermissions((ErrorCollection)errors, user)) {
            return errors;
        }
        if (Objects.isNull(field)) {
            errors.addErrorMessage("The field with given id does not exist or is not configurable", ErrorCollection.Reason.NOT_FOUND);
            return errors;
        }
        FieldId id = FieldId.fromFullId(field.getId());
        if (this.isFieldLocked(id, user)) {
            errors.addErrorMessage(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_CONFIGURATION_LOCKED, field.getId()), ErrorCollection.Reason.FORBIDDEN);
        } else if (this.isFieldManaged(id)) {
            errors.addErrorMessage(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_CONFIGURATION_MANAGED, field.getId()), ErrorCollection.Reason.FORBIDDEN);
        }
        return errors;
    }

    private ErrorCollection validateGetAvailableProjectsForUpdate(ApplicationUser user, ConfigurableField<?> field, String fieldId) {
        ErrorCollection errors = this.validateGetAvailableProjects(user, field);
        if (!field.getId().equals(fieldId)) {
            errors.addErrorMessage(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_NOT_FOUND), ErrorCollection.Reason.NOT_FOUND);
        }
        return errors;
    }

    private ErrorCollection validateDelete(ApplicationUser user, String fieldId, FieldConfigScheme configScheme) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        FieldId id = FieldId.fromFullId(fieldId);
        if (!this.verifyUserHasPermissions((ErrorCollection)errors, user)) {
            return errors;
        }
        if (Objects.isNull(configScheme)) {
            errors.addErrorMessage(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_NOT_FOUND), ErrorCollection.Reason.NOT_FOUND);
            return errors;
        }
        ConfigurableField field = configScheme.getField();
        if (Objects.isNull(field)) {
            errors.addErrorMessage("The field with given id does not exist or is not configurable", ErrorCollection.Reason.NOT_FOUND);
            return errors;
        }
        if (!field.getId().equals(fieldId)) {
            errors.addErrorMessage(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_NOT_FOUND), ErrorCollection.Reason.NOT_FOUND);
        }
        if (this.isFieldLocked(id, user) || !this.isDefaultValueAllowed(field)) {
            errors.addErrorMessage(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_CONFIGURATION_LOCKED, field.getId()), ErrorCollection.Reason.FORBIDDEN);
        }
        if (this.isFieldManaged(id)) {
            errors.addErrorMessage(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_CONFIGURATION_MANAGED, field.getId()), ErrorCollection.Reason.FORBIDDEN);
        }
        return errors;
    }

    private ErrorCollection validateGetContext(ApplicationUser user, String fieldId, FieldConfigScheme configScheme) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.verifyUserHasPermissions((ErrorCollection)errors, user)) {
            return errors;
        }
        if (Objects.isNull(configScheme)) {
            errors.addErrorMessage(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_NOT_FOUND), ErrorCollection.Reason.NOT_FOUND);
            return errors;
        }
        ConfigurableField field = configScheme.getField();
        if (Objects.isNull(field)) {
            errors.addErrorMessage("rest.field.config.scheme.error.field.not.found", ErrorCollection.Reason.NOT_FOUND);
        } else if (!field.getId().equals(fieldId)) {
            errors.addErrorMessage(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_NOT_FOUND), ErrorCollection.Reason.NOT_FOUND);
        }
        return errors;
    }

    private ErrorCollection validateCreateOrUpdate(ApplicationUser user, FieldConfigSchemeParameters parameters) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        ConfigurableField field = parameters.getField();
        FieldId fieldId = FieldId.fromFullId(field.getId());
        if (!this.verifyUserHasPermissions((ErrorCollection)errors, user)) {
            return errors;
        }
        if (this.isFieldLocked(fieldId, user) || !this.isDefaultValueAllowed(field)) {
            errors.addErrorMessage(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_CONFIGURATION_LOCKED, field.getId()), ErrorCollection.Reason.FORBIDDEN);
        }
        if (this.isFieldManaged(fieldId)) {
            errors.addErrorMessage(this.i18n.getText(REST_FIELD_CONFIG_SCHEME_ERROR_CONFIGURATION_MANAGED, field.getId()), ErrorCollection.Reason.FORBIDDEN);
        }
        if (this.isDefaultValueDisabled(fieldId)) {
            errors.addErrorMessage(this.i18n.getText("admin.issuefields.customfields.set.defaults.error.not.licensed", field.getId()), ErrorCollection.Reason.FORBIDDEN);
        }
        if (StringUtils.isBlank((CharSequence)parameters.getFieldConfigScheme().getName())) {
            errors.addErrorMessage(this.i18n.getText("admin.errors.empty.field.context.name"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (parameters.isGlobal() && !this.isGlobalAvailable(fieldId, parameters)) {
            errors.addErrorMessage(this.i18n.getText("admin.errors.global.contexts.not.available"), ErrorCollection.Reason.VALIDATION_FAILED);
        } else if (!parameters.isGlobal() && !this.selectedProjectsAvailable(parameters, field)) {
            errors.addErrorMessage(this.i18n.getText("admin.errors.some.of.selected.projects.not.available.for.context"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return errors;
    }

    private boolean selectedProjectsAvailable(FieldConfigSchemeParameters parameters, ConfigurableField<?> field) {
        List availableIds = this.getAvailableProjectsForField(field, parameters).stream().map(Project::getId).collect(Collectors.toList());
        return availableIds.containsAll(Arrays.asList(parameters.getProjectIds()));
    }

    private List<Project> getAvailableProjectsForField(ConfigurableField<?> field, FieldConfigSchemeParameters parameters) {
        return this.getAvailableProjectsForField(field.getAssociatedProjectObjects(), parameters.getFieldConfigScheme().getAssociatedProjectObjects());
    }

    private List<Project> getAvailableProjectsForField(Collection<Project> fieldProjects, Collection<Project> contextProjects) {
        ArrayList availableProjects = Lists.newArrayList((Iterable)this.projectManager.getProjects());
        availableProjects.removeAll(fieldProjects);
        availableProjects.addAll(contextProjects);
        return availableProjects;
    }

    private boolean isGlobalAvailable(FieldId fieldId, FieldConfigSchemeParameters parameters) {
        return this.isGlobalAvailable(fieldId, parameters.getField(), parameters.getFieldConfigScheme());
    }

    private boolean isGlobalAvailable(FieldId fieldId, ConfigurableField<?> field, FieldConfigScheme configScheme) {
        if (fieldId.isSystemField()) {
            return Objects.nonNull(configScheme) ? !this.isAlreadyConfiguredForAllProjects(field, configScheme) : !this.isAlreadyConfiguredForAllProjects(field);
        }
        return ((CustomField)field).getConfigurationSchemes().stream().filter(config -> configScheme == null || !configScheme.getId().equals(config.getId())).noneMatch(FieldConfigScheme::isAllProjects);
    }

    private boolean isAlreadyConfiguredForAllProjects(ConfigurableField<?> field, FieldConfigScheme configScheme) {
        return this.fieldConfigSchemeManager.getConfigSchemesForField(field).stream().filter(scheme -> !scheme.getId().equals(configScheme.getId())).anyMatch(FieldConfigScheme::isAllProjects);
    }

    private boolean isAlreadyConfiguredForAllProjects(ConfigurableField<?> field) {
        return this.fieldConfigSchemeManager.getConfigSchemesForField(field).stream().anyMatch(FieldConfigScheme::isAllProjects);
    }

    private boolean hasAdminPermission(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private boolean verifyUserHasPermissions(ErrorCollection errors, ApplicationUser user) {
        boolean hasPermission = this.hasAdminPermission(user);
        if (!hasPermission) {
            errors.addErrorMessage(this.i18n.getText("rest.field.config.scheme.error.forbidden"), ErrorCollection.Reason.FORBIDDEN);
        }
        return hasPermission;
    }

    private boolean isDefaultValueDisabled(FieldId fieldId) {
        if (fieldId.isSystemField()) {
            return !this.isLicensedForDefaultValues();
        }
        return false;
    }

    private boolean isLicensedForDefaultValues() {
        return this.licenseChecker.isEnabled(JiraFeatureFlagRegistrar.DEFAULT_VALUES_FOR_SYSTEM_FIELDS);
    }

    private boolean isFieldLocked(FieldId fieldId, ApplicationUser user) {
        ManagedConfigurationItem managedConfigurationItem = this.getManagedConfigurationItem(fieldId);
        if (managedConfigurationItem != null) {
            return !this.managedConfigurationItemService.doesUserHavePermission(user, managedConfigurationItem);
        }
        return false;
    }

    @Nullable
    private ManagedConfigurationItem getManagedConfigurationItem(FieldId fieldId) {
        if (fieldId.isCustomField()) {
            ConfigurableField configurableField = this.fieldManager.getConfigurableField(fieldId.toFullId());
            return this.managedConfigurationItemService.getManagedCustomField((CustomField)configurableField);
        }
        return null;
    }

    private boolean isFieldManaged(FieldId fieldId) {
        return Optional.ofNullable(this.getManagedConfigurationItem(fieldId)).map(ManagedConfigurationItem::isManaged).orElse(false);
    }

    private boolean isDefaultValueAllowed(ConfigurableField<?> configurableField) {
        if (configurableField instanceof DefaultValueField) {
            return ((DefaultValueField)configurableField).getDefaultValueOperations().isSupport();
        }
        return false;
    }
}

