/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.search;

import com.atlassian.jira.bc.issue.search.QueryCache;
import com.atlassian.jira.bc.issue.search.QueryContextConverter;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.RelevantSearcherVisitor;
import com.atlassian.jira.issue.search.searchers.util.TerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.jql.context.QueryContextImpl;
import com.atlassian.jira.jql.context.QueryContextVisitor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.parser.JqlParseErrorMessage;
import com.atlassian.jira.jql.parser.JqlParseErrorMessages;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.jql.permission.ClauseSanitisingVisitor;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.jql.validator.OrderByValidator;
import com.atlassian.jira.jql.validator.ValidatorVisitor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearchService
implements SearchService {
    private static final Logger log = LoggerFactory.getLogger(DefaultSearchService.class);
    private final JqlQueryParser jqlQueryParser;
    private final JqlStringSupport jqlStringSupport;
    private final ValidatorVisitor.ValidatorVisitorFactory validatorVisitorFactory;
    private final SearchHandlerManager searchHandlerManager;
    private final QueryContextVisitor.QueryContextVisitorFactory queryContextVisitorFactory;
    private final QueryContextConverter queryContextConverter;
    private final QueryCache queryCache;
    private final JqlOperandResolver jqlOperandResolver;
    private final OrderByValidator orderByValidator;
    private final SearchProvider searchProvider;
    private final IssueFactory issueFactory;
    private final I18nHelper.BeanFactory factory;

    public DefaultSearchService(SearchHandlerManager searchHandlerManager, JqlQueryParser jqlQueryParser, ValidatorVisitor.ValidatorVisitorFactory validatorVisitorFactory, QueryContextVisitor.QueryContextVisitorFactory queryContextVisitorFactory, JqlStringSupport jqlStringSupport, QueryContextConverter queryContextConverter, QueryCache queryCache, JqlOperandResolver jqlOperandResolver, OrderByValidator orderByValidator, SearchProvider searchProvider, IssueFactory issueFactory, I18nHelper.BeanFactory factory) {
        this.factory = factory;
        this.searchProvider = (SearchProvider)Assertions.notNull((String)"searchProvider", (Object)searchProvider);
        this.issueFactory = (IssueFactory)Assertions.notNull((String)"issueFactory", (Object)issueFactory);
        this.queryCache = (QueryCache)Assertions.notNull((String)"queryCache", (Object)queryCache);
        this.queryContextConverter = (QueryContextConverter)Assertions.notNull((String)"queryContextConverter", (Object)queryContextConverter);
        this.queryContextVisitorFactory = (QueryContextVisitor.QueryContextVisitorFactory)Assertions.notNull((String)"queryContextVisitorFactory", (Object)queryContextVisitorFactory);
        this.searchHandlerManager = (SearchHandlerManager)Assertions.notNull((String)"searchHandlerManager", (Object)searchHandlerManager);
        this.jqlQueryParser = (JqlQueryParser)Assertions.notNull((String)"jqlQueryParser", (Object)jqlQueryParser);
        this.jqlStringSupport = (JqlStringSupport)Assertions.notNull((String)"jqlStringSupport", (Object)jqlStringSupport);
        this.validatorVisitorFactory = (ValidatorVisitor.ValidatorVisitorFactory)Assertions.notNull((String)"validatorVisitorFactory", (Object)validatorVisitorFactory);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.orderByValidator = (OrderByValidator)Assertions.notNull((String)"orderByValidator", (Object)orderByValidator);
    }

    public boolean doesQueryFitFilterForm(ApplicationUser user, Query query) {
        Assertions.notNull((String)"query", (Object)query);
        if (query.getWhereClause() != null) {
            Boolean doesItFit = this.queryCache.getDoesQueryFitFilterFormCache(user, query);
            if (doesItFit == null) {
                doesItFit = this.calculateDoesQueryFitFilterForm(user, query);
                this.queryCache.setDoesQueryFitFilterFormCache(user, query, doesItFit);
            }
            return doesItFit;
        }
        return true;
    }

    public SearchResults<Issue> search(ApplicationUser searcher, Query query, PagerFilter pager) throws SearchException {
        return this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)searcher), pager).transform(docWithId -> this.issueFactory.getIssue(docWithId.getDocument()));
    }

    public SearchResults<Issue> searchOverrideSecurity(ApplicationUser searcher, Query query, PagerFilter pager) throws SearchException {
        return this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)searcher).overrideSecurity(true), pager).transform(docWithId -> this.issueFactory.getIssue(docWithId.getDocument()));
    }

    public long searchCount(ApplicationUser searcher, Query query) throws SearchException {
        return this.searchProvider.getHitCount(SearchQuery.create((Query)query, (ApplicationUser)searcher));
    }

    public long searchCount(ApplicationUser searcher, Query query, Long timeout) throws SearchException {
        return this.searchProvider.getHitCount(SearchQuery.create((Query)query, (ApplicationUser)searcher), timeout);
    }

    public long searchCountOverrideSecurity(ApplicationUser searcher, Query query) throws SearchException {
        return this.searchProvider.getHitCount(SearchQuery.create((Query)query, (ApplicationUser)searcher).overrideSecurity(true));
    }

    public SearchContext getSearchContext(ApplicationUser searcher, Query query) {
        SearchContext searchContext;
        QueryContext queryContext;
        if (query != null && (queryContext = this.getSimpleQueryContext(searcher, query)) != null && (searchContext = this.queryContextConverter.getSearchContext(queryContext)) != null) {
            return searchContext;
        }
        return this.createSearchContext(Collections.emptyList(), Collections.emptyList());
    }

    public String getQueryString(ApplicationUser user, Query query) {
        UrlBuilder url = this.createUrlBuilder();
        url.addParameter("jqlQuery", this.getJqlString(query));
        return url.asUrlString();
    }

    public String getIssueSearchPath(ApplicationUser user, SearchService.IssueSearchParameters params) {
        Assertions.notNull((String)"IssueSearchParameters", (Object)params);
        Assertions.stateFalse((String)"Cannot use both parameters", (params.filterId() != null && params.query() != null ? 1 : 0) != 0);
        UrlBuilder url = this.createAbsoluteUrlBuilder().addPath("/").addPath("issues").addPath("/");
        if (params.query() != null) {
            url.addParameter("jql", this.getJqlString(params.query()));
        }
        if (params.filterId() != null) {
            url.addParameter("filter", params.filterId().toString());
        }
        return url.asUrlString();
    }

    public SearchService.ParseResult parseQuery(ApplicationUser searcher, String query) {
        Assertions.notNull((String)"query", (Object)query);
        Query newQuery = null;
        MessageSetImpl errors = new MessageSetImpl();
        try {
            newQuery = this.jqlQueryParser.parseQuery(query);
        }
        catch (JqlParseException exception) {
            JqlParseErrorMessage errorMessage;
            if (log.isDebugEnabled()) {
                log.debug("Unable to parse query.", (Throwable)exception);
            }
            if ((errorMessage = exception.getParseErrorMessage()) == null) {
                errorMessage = JqlParseErrorMessages.genericParseError();
            }
            errors.addErrorMessage(errorMessage.getLocalizedErrorMessage(this.getI18n(searcher)));
        }
        return new SearchService.ParseResult(newQuery, (MessageSet)errors);
    }

    public QueryContext getQueryContext(ApplicationUser searcher, Query query) {
        Assertions.notNull((String)"query", (Object)query);
        Clause clause = query.getWhereClause();
        if (clause == null) {
            return new QueryContextImpl(ClauseContextImpl.createGlobalClauseContext());
        }
        QueryContext queryContext = this.queryCache.getQueryContextCache(searcher, query);
        if (queryContext == null) {
            QueryContextVisitor visitor = this.queryContextVisitorFactory.createVisitor(searcher);
            QueryContextVisitor.ContextResult result = (QueryContextVisitor.ContextResult)clause.accept((ClauseVisitor)visitor);
            queryContext = new QueryContextImpl(result.getFullContext());
            QueryContextImpl explicitQueryContext = new QueryContextImpl(result.getSimpleContext());
            this.queryCache.setQueryContextCache(searcher, query, queryContext);
            this.queryCache.setSimpleQueryContextCache(searcher, query, explicitQueryContext);
        }
        return queryContext;
    }

    public QueryContext getSimpleQueryContext(ApplicationUser searcher, Query query) {
        Assertions.notNull((String)"query", (Object)query);
        Clause clause = query.getWhereClause();
        if (clause == null) {
            return new QueryContextImpl(ClauseContextImpl.createGlobalClauseContext());
        }
        QueryContext simpleQueryContext = this.queryCache.getSimpleQueryContextCache(searcher, query);
        if (simpleQueryContext == null) {
            QueryContextVisitor visitor = this.queryContextVisitorFactory.createVisitor(searcher);
            QueryContextVisitor.ContextResult result = (QueryContextVisitor.ContextResult)clause.accept((ClauseVisitor)visitor);
            simpleQueryContext = new QueryContextImpl(result.getSimpleContext());
            QueryContextImpl fullQueryContext = new QueryContextImpl(result.getFullContext());
            this.queryCache.setQueryContextCache(searcher, query, fullQueryContext);
            this.queryCache.setSimpleQueryContextCache(searcher, query, simpleQueryContext);
        }
        return simpleQueryContext;
    }

    @Nonnull
    public MessageSet validateQuery(ApplicationUser searcher, @Nonnull Query query) {
        return this.validateQuery(searcher, query, null);
    }

    @Nonnull
    public MessageSet validateQuery(ApplicationUser searcher, @Nonnull Query query, Long searchRequestId) {
        Assertions.notNull((String)"query", (Object)query);
        try (Ticker ignored = Timers.start((String)"DefaultSearchService.validateQuery()");){
            MessageSetImpl messageSet;
            Clause clause = query.getWhereClause();
            if (clause != null) {
                ValidatorVisitor visitor = this.validatorVisitorFactory.createVisitor(searcher, searchRequestId, clause);
                messageSet = (MessageSet)clause.accept((ClauseVisitor)visitor);
            } else {
                messageSet = new MessageSetImpl();
            }
            OrderBy orderBy = query.getOrderByClause();
            if (orderBy != null) {
                messageSet.addMessageSet(this.orderByValidator.validate(searcher, orderBy));
            }
            MessageSetImpl messageSetImpl = messageSet;
            return messageSetImpl;
        }
    }

    public String getJqlString(Query query) {
        Assertions.notNull((String)"query", (Object)query);
        if (query.getQueryString() != null) {
            return query.getQueryString();
        }
        return this.getGeneratedJqlString(query);
    }

    public String getGeneratedJqlString(Query query) {
        Assertions.notNull((String)"query", (Object)query);
        return this.jqlStringSupport.generateJqlString(query);
    }

    public Query sanitiseSearchQuery(ApplicationUser searcher, Query query) {
        return this.process(query, this.createClauseSanitisingVisitor(searcher));
    }

    private Query process(Query query, ClauseVisitor<Clause> visitor) {
        Assertions.notNull((String)"query", (Object)query);
        Clause clause = query.getWhereClause();
        if (clause == null) {
            return query;
        }
        Clause sanitisedClause = (Clause)clause.accept(visitor);
        if (!clause.equals(sanitisedClause)) {
            return new QueryImpl(sanitisedClause, query.getOrderByClause(), null);
        }
        return query;
    }

    ClauseSanitisingVisitor createClauseSanitisingVisitor(ApplicationUser searcher) {
        return new ClauseSanitisingVisitor(this.searchHandlerManager, this.jqlOperandResolver, searcher);
    }

    SearchContext createSearchContext(List<Long> projects, List<String> issueTypes) {
        return new SearchContextImpl(Collections.emptyList(), projects, issueTypes);
    }

    I18nHelper getI18n(ApplicationUser user) {
        return this.factory.getInstance(user);
    }

    Set<IssueSearcher> getRelevantQuerySearchers(ApplicationUser user, Query query) {
        Assertions.notNull((String)"query", (Object)query);
        RelevantSearcherVisitor relevantSearcherVisitor = this.createRelevantSearcherVisitor(user);
        boolean allHaveSearchers = (Boolean)query.getWhereClause().accept((ClauseVisitor)relevantSearcherVisitor);
        if (!allHaveSearchers) {
            return null;
        }
        return relevantSearcherVisitor.getRelevantSearchers();
    }

    boolean calculateDoesQueryFitFilterForm(ApplicationUser user, Query query) {
        boolean doesItFit = true;
        SearchContext simpleSearchContext = this.queryContextConverter.getSearchContext(this.getSimpleQueryContext(user, query));
        if (simpleSearchContext == null) {
            doesItFit = false;
        } else {
            Set<IssueSearcher> relevantSearchers = this.getRelevantQuerySearchers(user, query);
            if (relevantSearchers == null) {
                doesItFit = false;
            } else if (!relevantSearchers.isEmpty()) {
                for (IssueSearcher relevantSearcher : relevantSearchers) {
                    SearchInputTransformer searchInputTransformer = relevantSearcher.getSearchInputTransformer();
                    if (searchInputTransformer.doRelevantClausesFitFilterForm(user, query, simpleSearchContext)) continue;
                    doesItFit = false;
                    break;
                }
                if (doesItFit) {
                    doesItFit = this.calculateDoesQueryValidationFitFilterForm(user, simpleSearchContext, query);
                }
            }
        }
        return doesItFit;
    }

    boolean calculateDoesQueryValidationFitFilterForm(ApplicationUser user, SearchContext searchContext, Query query) {
        ValidatorVisitor validatorVisitor = this.validatorVisitorFactory.createVisitor(user, null, query.getWhereClause());
        TerminalClauseCollectingVisitor terminalClauseCollectingVisitor = new TerminalClauseCollectingVisitor();
        query.getWhereClause().accept((ClauseVisitor)terminalClauseCollectingVisitor);
        Collection<TerminalClause> clauses = terminalClauseCollectingVisitor.getClauses();
        for (TerminalClause clause : clauses) {
            Collection issueSearchers = this.searchHandlerManager.getSearchersByClauseName(user, clause.getName());
            for (IssueSearcher issueSearcher : issueSearchers) {
                if (this.checkValidationMatches(user, query, searchContext, clause, issueSearcher, validatorVisitor)) continue;
                return false;
            }
        }
        return true;
    }

    boolean checkValidationMatches(ApplicationUser user, Query query, SearchContext searchContext, TerminalClause clause, IssueSearcher searcher, ClauseVisitor<MessageSet> validatorVisitor) {
        MessageSet clauseErrors = (MessageSet)clause.accept(validatorVisitor);
        if (!clauseErrors.hasAnyMessages()) {
            return true;
        }
        SearchInputTransformer transformer = searcher.getSearchInputTransformer();
        FieldValuesHolderImpl holder = new FieldValuesHolderImpl();
        transformer.populateFromQuery(user, (FieldValuesHolder)holder, query, searchContext);
        SimpleErrorCollection searcherErrors = new SimpleErrorCollection();
        transformer.validateParams(user, searchContext, (FieldValuesHolder)holder, this.getI18n(user), (ErrorCollection)searcherErrors);
        return searcherErrors.hasAnyErrors();
    }

    RelevantSearcherVisitor createRelevantSearcherVisitor(ApplicationUser user) {
        return new RelevantSearcherVisitor(this.searchHandlerManager, user);
    }

    UrlBuilder createUrlBuilder() {
        return new UrlBuilder(true);
    }

    UrlBuilder createAbsoluteUrlBuilder() {
        return new UrlBuilder(false);
    }
}

