/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.watcher;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.watcher.plugin.AutoWatchOverride;
import com.atlassian.jira.bc.issue.watcher.plugin.AutoWatchOverrideModuleDescriptor;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import java.util.HashMap;
import java.util.List;

public class AutoWatchService
implements Startable {
    private static final String ISSUE = "issue";
    private final EventPublisher eventPublisher;
    private final WatcherService watcherService;
    private final UserPreferencesManager userPreferencesManager;
    private final PluginAccessor pluginAccessor;

    public AutoWatchService(EventPublisher eventPublisher, WatcherService watcherService, UserPreferencesManager userPreferencesManager, PluginAccessor pluginAccessor) {
        this.eventPublisher = eventPublisher;
        this.watcherService = watcherService;
        this.userPreferencesManager = userPreferencesManager;
        this.pluginAccessor = pluginAccessor;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onIssueEvent(IssueEvent event) {
        ApplicationUser user;
        if (this.watcherService.isWatchingEnabled() && this.shouldAutoWatchEvent(event, user = event.getUser())) {
            this.watcherService.addWatcher(event.getIssue(), user, user);
        }
    }

    private boolean shouldAutoWatchEvent(IssueEvent event, ApplicationUser user) {
        return user != null && this.isAutowatchEvent(event) && this.isAutoWatchEnabledForUser(user) && this.isAutoWatchAllowed(event.getIssue(), user, user);
    }

    private boolean isAutoWatchAllowed(Issue issue, ApplicationUser remoteUser, ApplicationUser potentialWatcher) {
        HashMap<String, Issue> context = new HashMap<String, Issue>();
        context.put(ISSUE, issue);
        List decisions = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor).forType(AutoWatchOverrideModuleDescriptor.class, (autoWatchOverrideModuleDescriptor, autoWatchOverride) -> {
            if (!autoWatchOverrideModuleDescriptor.getCondition().shouldDisplay(context)) {
                return AutoWatchOverride.Decision.ABSTAIN;
            }
            return autoWatchOverride.isAutoWatchAllowed(issue, remoteUser, potentialWatcher);
        });
        return decisions.stream().noneMatch(decision -> decision == AutoWatchOverride.Decision.DENY);
    }

    private boolean isAutowatchEvent(IssueEvent event) {
        Long eventTypeId = event.getEventTypeId();
        boolean createOrComment = eventTypeId != null && (eventTypeId.equals(EventType.ISSUE_CREATED_ID) || eventTypeId.equals(EventType.ISSUE_COMMENTED_ID));
        return createOrComment || event.getComment() != null;
    }

    public boolean isAutoWatchEnabledForUser(ApplicationUser user) {
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(user);
        boolean autoWatchForUserSet = preferences.containsValue("user.autowatch.disabled");
        if (autoWatchForUserSet) {
            return !preferences.getBoolean("user.autowatch.disabled");
        }
        ApplicationProperties jiraProperties = ComponentAccessor.getApplicationProperties();
        return !jiraProperties.getOption("user.autowatch.disabled");
    }
}

