/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issuetype.property;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.IssueTypePermissionService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.event.entity.EntityPropertyDeletedEvent;
import com.atlassian.jira.event.entity.EntityPropertySetEvent;
import com.atlassian.jira.event.issuetype.property.IssueTypePropertyDeletedEvent;
import com.atlassian.jira.event.issuetype.property.IssueTypePropertySetEvent;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeWithID;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import io.atlassian.fugue.Option;
import java.util.function.BiFunction;
import java.util.function.Function;

public class IssueTypePropertyHelper
implements EntityPropertyHelper<IssueTypeWithID> {
    private final IssueTypeManager issueTypeManager;
    private final IssueTypePermissionService issueTypePermissionService;
    private final I18nHelper i18n;
    private final EntityPropertyHelper.CheckPermissionFunction<IssueTypeWithID> hasEditPermissionFunction = new EntityPropertyHelper.CheckPermissionFunction<IssueTypeWithID>(){

        public ErrorCollection apply(ApplicationUser applicationUser, IssueTypeWithID issueTypeWithID) {
            if (IssueTypePropertyHelper.this.issueTypePermissionService.hasPermissionToEditIssueType(applicationUser)) {
                return IssueTypePropertyHelper.this.noError();
            }
            ErrorCollection canViewResult = (ErrorCollection)IssueTypePropertyHelper.this.hasViewPermissionFunction.apply((Object)applicationUser, (Object)issueTypeWithID);
            if (canViewResult.hasAnyErrors()) {
                return canViewResult;
            }
            return new SimpleErrorCollection(IssueTypePropertyHelper.this.i18n.getText("rest.authorization.admin.required"), ErrorCollection.Reason.FORBIDDEN);
        }
    };
    private final EntityPropertyHelper.CheckPermissionFunction<IssueTypeWithID> hasViewPermissionFunction = new EntityPropertyHelper.CheckPermissionFunction<IssueTypeWithID>(){

        public ErrorCollection apply(ApplicationUser applicationUser, IssueTypeWithID issueTypeWithID) {
            if (IssueTypePropertyHelper.this.issueTypePermissionService.hasPermissionToViewIssueType(applicationUser, issueTypeWithID.getId().toString())) {
                return IssueTypePropertyHelper.this.noError();
            }
            return new SimpleErrorCollection(IssueTypePropertyHelper.this.i18n.getText("admin.error.issue.type.get.not.exist"), ErrorCollection.Reason.NOT_FOUND);
        }
    };
    private final Function<Long, Option<IssueTypeWithID>> entityByIdFunction = new Function<Long, Option<IssueTypeWithID>>(){

        @Override
        public Option<IssueTypeWithID> apply(Long id) {
            return Option.option((Object)IssueTypeWithID.fromIssueType((IssueType)IssueTypePropertyHelper.this.issueTypeManager.getIssueType(String.valueOf(id))));
        }
    };
    private final BiFunction<ApplicationUser, EntityProperty, IssueTypePropertySetEvent> setPropertyEventFunction = new BiFunction<ApplicationUser, EntityProperty, IssueTypePropertySetEvent>(){

        @Override
        public IssueTypePropertySetEvent apply(ApplicationUser user, EntityProperty entityProperty) {
            return new IssueTypePropertySetEvent(entityProperty, user);
        }
    };
    private final BiFunction<ApplicationUser, EntityProperty, IssueTypePropertyDeletedEvent> deletePropertyEventFunction = new BiFunction<ApplicationUser, EntityProperty, IssueTypePropertyDeletedEvent>(){

        @Override
        public IssueTypePropertyDeletedEvent apply(ApplicationUser user, EntityProperty entityProperty) {
            return new IssueTypePropertyDeletedEvent(entityProperty, user);
        }
    };

    public IssueTypePropertyHelper(IssueTypeManager issueTypeManager, IssueTypePermissionService issueTypePermissionService, I18nHelper i18n) {
        this.issueTypeManager = issueTypeManager;
        this.issueTypePermissionService = issueTypePermissionService;
        this.i18n = i18n;
    }

    public EntityPropertyHelper.CheckPermissionFunction<IssueTypeWithID> hasEditPermissionFunction() {
        return this.hasEditPermissionFunction;
    }

    public EntityPropertyHelper.CheckPermissionFunction<IssueTypeWithID> hasReadPermissionFunction() {
        return this.hasViewPermissionFunction;
    }

    public Function<Long, Option<IssueTypeWithID>> getEntityByIdFunction() {
        return this.entityByIdFunction;
    }

    public BiFunction<ApplicationUser, EntityProperty, ? extends EntityPropertySetEvent> createSetPropertyEventBiFunction() {
        return this.setPropertyEventFunction;
    }

    public BiFunction<ApplicationUser, EntityProperty, ? extends EntityPropertyDeletedEvent> createDeletePropertyEventBiFunction() {
        return this.deletePropertyEventFunction;
    }

    public EntityPropertyType getEntityPropertyType() {
        return EntityPropertyType.ISSUE_TYPE_PROPERTY;
    }

    private SimpleErrorCollection noError() {
        return new SimpleErrorCollection();
    }
}

