/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.safeguards.config;

import com.atlassian.jira.bc.safeguards.config.RestrictedUsersComponent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DefaultRestrictedUsersComponent
implements RestrictedUsersComponent {
    private final ApplicationProperties applicationProperties;
    private final GroupManager groupManager;

    public DefaultRestrictedUsersComponent(ApplicationProperties applicationProperties, GroupManager groupManager) {
        this.applicationProperties = applicationProperties;
        this.groupManager = groupManager;
    }

    @Override
    public boolean isUserRestricted(@Nullable ApplicationUser user) {
        Set<String> restrictedGroups = this.getConfiguredRestrictedGroups();
        return this.groupManager.isUserInGroups(user, restrictedGroups);
    }

    @Override
    public Set<String> getConfiguredRestrictedGroups() {
        String restrictedGroupStr = this.applicationProperties.getDefaultBackedString("jira.safeguards.config.restricted.groups");
        return Arrays.stream(restrictedGroupStr.split(",")).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }
}

