/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.safeguards.issue.comment;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.safeguards.AbstractSafeguardsNotifier;
import com.atlassian.jira.bc.safeguards.issue.comment.CommentLimitContext;
import com.atlassian.jira.bc.safeguards.issue.comment.CommentNotificationType;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.safeguards.SafeguardsValidatorExecutionEventBuilder;
import com.atlassian.jira.mail.MailService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.server.MailServerManager;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

@Internal
public class CommentsPerIssueLimitNotifier
extends AbstractSafeguardsNotifier {
    @VisibleForTesting
    static final String COMMENTS_PER_ISSUE_TYPE = "COMMENTS_PER_ISSUE";
    private static final double LIMIT_APPROACH_EMAIL_NOTIFICATION_THRESHOLD = 0.9;
    private static final double REMIND_SOFT_LIMIT_THRESHOLD = 0.1;
    static final int APPROACHING_THRESHOLD_PERCENT = 90;
    static final String NOT_SPECIFIED_USER = "not specified";
    static final String EMAIL_SUBJECT_TEMPLATE = "templates/email/subject/issuecommentlimit.vm";
    static final String EMAIL_CONTENT_TEMPLATE = "templates/email/html/issuecommentlimit.vm";
    private static final String EVENT_PARAM = "event";
    private static final String THRESHOLD_PARAM = "threshold";
    private static final String HEADER_I18N_PARAM = "headerI18nString";
    private static final String BODY_I18N_PARAM = "bodyI18nString";

    public CommentsPerIssueLimitNotifier(MailService mailService, MailServerManager mailServerManager, FeatureManager featureManager, EventPublisher eventPublisher, DateTimeFormatterFactory dateTimeFormatterFactory, I18nHelper.BeanFactory i18nHelperFactory) {
        super(mailService, mailServerManager, featureManager, eventPublisher, dateTimeFormatterFactory, i18nHelperFactory);
    }

    public void notify(CommentLimitContext context) {
        Optional<CommentNotificationType> notificationType = this.matchNotificationType(context);
        if (!notificationType.isPresent()) {
            return;
        }
        notificationType.get().log(context);
        this.publishSafeguardsExecutionEvent(context);
        if (notificationType.get() == CommentNotificationType.BREACHED_SOFT && !this.shouldSendSoftLimitEmail(context)) {
            return;
        }
        this.sendEmail(context, notificationType.get());
    }

    private Optional<CommentNotificationType> matchNotificationType(CommentLimitContext context) {
        if (this.isLimitBreached(context)) {
            return Optional.of(CommentNotificationType.BREACHED_SOFT);
        }
        if (this.isLimitBreachAttempt(context)) {
            return Optional.of(CommentNotificationType.BREACHED_HARD);
        }
        if (this.isLimitJustReached(context)) {
            return Optional.of(CommentNotificationType.REACHED);
        }
        if (this.isLimitApproached(context)) {
            return Optional.of(CommentNotificationType.APPROACH);
        }
        return Optional.empty();
    }

    private boolean shouldSendSoftLimitEmail(CommentLimitContext context) {
        long softLimitThreshold = Math.max((long)((double)context.getLimit() * 0.1), 1L);
        return context.getCommentsCount() % softLimitThreshold == 0L;
    }

    private boolean isLimitBreached(CommentLimitContext context) {
        return context.getCommentsCount() > context.getLimit() && context.isValid();
    }

    private boolean isLimitBreachAttempt(CommentLimitContext context) {
        return context.getCommentsCount() >= context.getLimit() && !context.isValid();
    }

    private boolean isLimitJustReached(CommentLimitContext context) {
        return context.getCommentsCount() == context.getLimit();
    }

    private boolean isLimitApproached(CommentLimitContext context) {
        return context.getCommentsCount() == (long)((double)context.getLimit() * 0.9);
    }

    private void sendEmail(CommentLimitContext event, CommentNotificationType notificationType) {
        ImmutableMap mailContext = ImmutableMap.builder().put((Object)EVENT_PARAM, (Object)event).put((Object)THRESHOLD_PARAM, (Object)String.valueOf(90)).put((Object)HEADER_I18N_PARAM, (Object)notificationType.getHeaderI18nKey()).put((Object)BODY_I18N_PARAM, (Object)notificationType.getBodyI18nKey()).build();
        this.sendEmail(EMAIL_SUBJECT_TEMPLATE, EMAIL_CONTENT_TEMPLATE, (Map<String, Object>)mailContext);
    }

    private void publishSafeguardsExecutionEvent(CommentLimitContext context) {
        this.publishEvent(new SafeguardsValidatorExecutionEventBuilder().setEntityType(COMMENTS_PER_ISSUE_TYPE).setEntityId(context.getIssueId()).setEntitiesCount(context.getCommentsCount()).setLimitValue(context.getLimit()).setExecutor(context.getExecutor()).setAuthor(context.getAuthor()).setUserRestricted(context.getUserRestricted()).setValid(context.isValid()).createSafeguardsValidatorExecutionEvent());
    }
}

