/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.board.store;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.board.Board;
import com.atlassian.jira.board.BoardCreationData;
import com.atlassian.jira.board.BoardId;
import com.atlassian.jira.board.store.BoardStore;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.BoardDTO;
import com.atlassian.jira.model.querydsl.ProjectChangedTimeDTO;
import com.atlassian.jira.model.querydsl.QBoard;
import com.atlassian.jira.model.querydsl.QBoardProject;
import com.atlassian.jira.model.querydsl.QProjectChangedTime;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class QueryDslBoardStore
implements BoardStore {
    private static final String BOARD_ENTITY_NAME = "Board";
    private static final QBoard BOARD = new QBoard("Board");
    private final OfBizDelegator ofBizDelegator;
    private final QueryDslAccessor queryDslAccessor;

    public QueryDslBoardStore(OfBizDelegator ofBizDelegator, QueryDslAccessor queryDslAccessor) {
        this.ofBizDelegator = ofBizDelegator;
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public Board createBoard(BoardCreationData boardCreationData) {
        Long nextSeqId = this.ofBizDelegator.getDelegatorInterface().getNextSeqId(BOARD_ENTITY_NAME);
        this.queryDslAccessor.execute(dbConnection -> {
            dbConnection.insert(BOARD).set((Path)QueryDslBoardStore.BOARD.id, nextSeqId).set((Path)QueryDslBoardStore.BOARD.jql, boardCreationData.getJql()).execute();
            dbConnection.insert(QBoardProject.BOARD_PROJECT).set((Path)QBoardProject.BOARD_PROJECT.boardId, nextSeqId).set((Path)QBoardProject.BOARD_PROJECT.projectId, (Object)boardCreationData.getProjectId()).execute();
        });
        return this.getBoard(new BoardId(nextSeqId.longValue())).get();
    }

    @Override
    public Optional<Board> getBoard(BoardId boardId) {
        BoardDTO boardDto = this.queryDslAccessor.executeQuery(dbConnection -> (BoardDTO)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)BOARD).from((Expression)BOARD)).where((Predicate)QueryDslBoardStore.BOARD.id.eq((Object)boardId.getId()))).limit(1L)).fetchOne());
        if (boardDto == null) {
            return Optional.empty();
        }
        return Optional.of(new Board(new BoardId(boardDto.getId().longValue()), boardDto.getJql()));
    }

    @Override
    public boolean deleteBoard(BoardId boardId) {
        long deletedRecords = this.queryDslAccessor.executeQuery(dbConnection -> {
            long count = dbConnection.delete((RelationalPath<?>)BOARD).where((Predicate)QueryDslBoardStore.BOARD.id.eq((Object)boardId.getId())).execute();
            dbConnection.delete((RelationalPath<?>)QBoardProject.BOARD_PROJECT).where((Predicate)QBoardProject.BOARD_PROJECT.boardId.eq((Object)boardId.getId())).execute();
            return count;
        });
        return deletedRecords == 1L;
    }

    @Override
    public List<Board> getBoardsForProject(long projectId) {
        List boardDtos = this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)BOARD).from((Expression)BOARD)).innerJoin((EntityPath)QBoardProject.BOARD_PROJECT)).on((Predicate)QueryDslBoardStore.BOARD.id.eq(QBoardProject.BOARD_PROJECT.boardId))).where((Predicate)QBoardProject.BOARD_PROJECT.projectId.eq((Object)projectId))).fetch());
        return (List)boardDtos.stream().map(boardDto -> new Board(new BoardId(boardDto.getId().longValue()), boardDto.getJql())).collect(CollectorsUtil.toImmutableList());
    }

    @Override
    public boolean hasBoardForProject(long projectId) {
        long count = this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(QBoardProject.BOARD_PROJECT.projectId).from((Expression)QBoardProject.BOARD_PROJECT)).where((Predicate)QBoardProject.BOARD_PROJECT.projectId.eq((Object)projectId))).fetchCount());
        return count > 0L;
    }

    @Override
    public Optional<Date> getBoardDataChangedTime(BoardId boardId) {
        ProjectChangedTimeDTO projectChangedTimeDTO = this.queryDslAccessor.executeQuery(dbConnection -> (ProjectChangedTimeDTO)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QProjectChangedTime.PROJECT_CHANGED_TIME).from((Expression)QProjectChangedTime.PROJECT_CHANGED_TIME)).innerJoin((EntityPath)QBoardProject.BOARD_PROJECT)).on((Predicate)QProjectChangedTime.PROJECT_CHANGED_TIME.projectId.eq(QBoardProject.BOARD_PROJECT.projectId))).where((Predicate)QBoardProject.BOARD_PROJECT.boardId.eq((Object)boardId.getId()))).fetchFirst());
        if (projectChangedTimeDTO == null || projectChangedTimeDTO.getIssueChangedTime() == null) {
            return Optional.empty();
        }
        return Optional.of(new Date(projectChangedTimeDTO.getIssueChangedTime().getTime()));
    }
}

