/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.jira.issue.Issue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class BulkMoveBatchProcessingHelper {
    public List<List<Issue>> partition(@Nonnull List<Issue> selectedIssues, int batchSize) {
        if (batchSize < 2) {
            throw new IllegalArgumentException("Batch size should be equal or greater than 2");
        }
        if (selectedIssues.size() <= batchSize) {
            return Collections.singletonList(selectedIssues);
        }
        if (this.isLastBatchSizeDifferentThanOne(selectedIssues, batchSize)) {
            return Lists.partition(selectedIssues, (int)batchSize);
        }
        return this.mergeLastTwoBatchesToAvoidOneSizeBatch(selectedIssues, batchSize);
    }

    private List<List<Issue>> mergeLastTwoBatchesToAvoidOneSizeBatch(List<Issue> selectedIssues, int batchSize) {
        Issue orphan = selectedIssues.remove(selectedIssues.size() - 1);
        List batches = Lists.partition(selectedIssues, (int)batchSize);
        ArrayList mutableList = new ArrayList(batches);
        int lastIndex = mutableList.size();
        ArrayList<Issue> mutableLastBatch = new ArrayList<Issue>((Collection)mutableList.remove(lastIndex - 1));
        mutableLastBatch.add(orphan);
        mutableList.add(Collections.unmodifiableList(mutableLastBatch));
        return Collections.unmodifiableList(mutableList);
    }

    private boolean isLastBatchSizeDifferentThanOne(List<Issue> selectedIssues, int batchSize) {
        return selectedIssues.size() % batchSize != 1;
    }
}

