/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.jira.cache.CacheCompactor;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheCompactor
implements CacheCompactor,
Startable,
JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(EhCacheCompactor.class);
    private static final long FIVE_MINUTES = TimeUnit.MINUTES.toMillis(5L);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)EhCacheCompactor.class.getName());
    private static final JobId JOB_ID = JobId.of((String)EhCacheCompactor.class.getName());
    private final CacheManager cacheManager;

    public EhCacheCompactor(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public CacheCompactor.CacheCompactionResult purgeExpiredCacheEntries() {
        int cacheCount = 0;
        int totalEntriesCount = 0;
        int purgedEntriesCount = 0;
        for (String name : this.cacheManager.getCacheNames()) {
            try {
                Cache cache = this.cacheManager.getCache(name);
                if (cache == null || !cache.getStatus().equals(Status.STATUS_ALIVE)) continue;
                int before = cache.getSize();
                cache.evictExpiredElements();
                int after = cache.getSize();
                ++cacheCount;
                totalEntriesCount += before;
                purgedEntriesCount += before - after;
            }
            catch (Exception e) {
                LOG.warn("Unable to purge expired cache entries for cahe '" + name + "'", (Throwable)e);
            }
        }
        return new CacheCompactor.CacheCompactionResult(cacheCount, totalEntriesCount, purgedEntriesCount);
    }

    public void start() throws Exception {
        SchedulerService scheduler = (SchedulerService)ComponentAccessor.getComponent(SchedulerService.class);
        scheduler.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)FIVE_MINUTES, null));
        scheduler.scheduleJob(JOB_ID, jobConfig);
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        I18nHelper i18n = ComponentAccessor.getI18nHelperFactory().getInstance((ApplicationUser)null);
        try {
            CacheCompactor.CacheCompactionResult result = this.purgeExpiredCacheEntries();
            String message = i18n.getText("admin.service.cachecompactor.result", (Object)result.getCacheCount(), (Object)result.getTotalEntriesCount(), (Object)result.getPurgedEntriesCount());
            return JobRunnerResponse.success((String)message);
        }
        catch (Exception e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
    }
}

