/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.request;

import com.atlassian.jira.cache.request.RequestCacheConfiguration;
import com.atlassian.jira.cache.request.context.DiagnosticRequestCacheContext;
import com.atlassian.jira.cache.request.context.MapBasedRequestCacheContext;
import com.atlassian.jira.cache.request.context.ReentrantRequestCacheContext;
import com.atlassian.jira.cache.request.context.RequestCacheContext;
import java.time.Clock;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

public class RequestCacheContextFactory {
    private final Clock clock;
    private final RequestCacheConfiguration requestCacheConfiguration;

    RequestCacheContextFactory(Clock clock, RequestCacheConfiguration requestCacheConfiguration) {
        this.clock = clock;
        this.requestCacheConfiguration = requestCacheConfiguration;
    }

    public RequestCacheContext createContext(Runnable cleaningCallback) {
        ReentrantRequestCacheContext baseContext = new ReentrantRequestCacheContext(new MapBasedRequestCacheContext(this.getMapSupplier(), cleaningCallback));
        return new DiagnosticRequestCacheContext(baseContext, this.clock, this.clock.instant(), this.requestCacheConfiguration.getLongRunningThresholdSeconds());
    }

    private Supplier<Map<Object, Object>> getMapSupplier() {
        if (this.requestCacheConfiguration.isBoundedCacheEnabled()) {
            return () -> new BoundedCacheMap(this.requestCacheConfiguration.getBoundedCacheSize());
        }
        return HashMap::new;
    }

    class BoundedCacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int limit;

        BoundedCacheMap(int limit) {
            super(limit, 0.75f, true);
            this.limit = limit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.limit;
        }
    }
}

