/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.request;

import com.atlassian.cache.CacheLoader;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.RequestCacheController;
import com.atlassian.jira.cache.request.RequestCacheFactory;
import com.atlassian.jira.cache.request.RequestCacheRecorder;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class RequestCacheFactoryImpl
implements RequestCacheFactory {
    private final RequestCacheRecorder logger;

    public RequestCacheFactoryImpl(RequestCacheRecorder logger) {
        this.logger = logger;
    }

    public <K, V> RequestCache<K, V> createRequestCache(String name) {
        return this.createRequestCache(name, new ExceptionalCacheLoader(name));
    }

    public <K, V> RequestCache<K, V> createRequestCache(String name, CacheLoader<K, V> cacheLoader) {
        return RequestCacheController.createRequestCache(name, cacheLoader, this.logger);
    }

    static class ExceptionalCacheLoader<K, V>
    implements CacheLoader<K, V> {
        private final String name;

        ExceptionalCacheLoader(String name) {
            this.name = name;
        }

        @Nonnull
        public V load(@Nonnull K key) {
            throw new NoSuchElementException("Request cache '" + this.name + "' attempted to load missing key '" + key + "' without providing either a CacheLoader or a Supplier for it");
        }

        public String toString() {
            return "ExceptionalCacheLoader[name=" + this.name + ']';
        }
    }
}

