/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.serialcheck;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.cache.serialcheck.SerializationChecker;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SerializationCheckedCache<K, V>
implements Cache<K, V> {
    private final Cache<K, V> delegate;
    private final SerializationChecker checker;

    public SerializationCheckedCache(SerializationChecker checker, Cache<K, V> delegate) {
        this.delegate = delegate;
        this.checker = checker;
    }

    @Nonnull
    public String getName() {
        return this.delegate.getName();
    }

    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    @Nonnull
    public Collection<K> getKeys() {
        return this.delegate.getKeys();
    }

    @Nullable
    public V get(K key) {
        return (V)this.delegate.get(key);
    }

    @Nonnull
    public V get(K key, Supplier<? extends V> supplier) {
        return (V)this.delegate.get(key, supplier);
    }

    public void put(K key, V value) {
        this.checker.checkValue(this, key, value);
        this.delegate.put(key, value);
    }

    @Nullable
    public V putIfAbsent(K key, V value) {
        this.checker.checkValue(this, key, value);
        return (V)this.delegate.putIfAbsent(key, value);
    }

    public void remove(K key) {
        this.delegate.remove(key);
    }

    public boolean remove(K key, V value) {
        return this.delegate.remove(key, value);
    }

    public void removeAll() {
        this.delegate.removeAll();
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.checker.checkValue(this, key, newValue);
        return this.delegate.replace(key, oldValue, newValue);
    }

    public void addListener(CacheEntryListener<K, V> listener, boolean includeValues) {
        this.delegate.addListener(listener, includeValues);
    }

    public void removeListener(CacheEntryListener<K, V> cacheEntryListener) {
        this.delegate.removeListener(cacheEntryListener);
    }
}

