/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.stats;

import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.jira.cache.stats.CacheStats;
import java.util.Optional;
import javax.annotation.Nonnull;

public class CachedReferenceWithStats<V>
implements CachedReference<V> {
    private final CachedReference<V> delegate;
    private final String name;
    private final CacheStats stats;

    public CachedReferenceWithStats(CachedReference<V> delegate, String name, CacheStats stats) {
        this.delegate = delegate;
        this.name = name;
        this.stats = stats;
    }

    @Nonnull
    public V get() {
        return (V)this.delegate.get();
    }

    public void reset() {
        this.delegate.reset();
        this.stats.incrementClearCacheUsage(this.name);
    }

    public boolean isPresent() {
        return this.delegate.isPresent();
    }

    @Nonnull
    public Optional<V> getIfPresent() {
        return this.delegate.getIfPresent();
    }

    public void addListener(@Nonnull CachedReferenceListener<V> cachedReferenceListener, boolean b) {
        this.delegate.addListener(cachedReferenceListener, b);
    }

    public void removeListener(@Nonnull CachedReferenceListener<V> cachedReferenceListener) {
        this.delegate.removeListener(cachedReferenceListener);
    }
}

