/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.AverageAgeChart;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.CreatedVsResolvedChart;
import com.atlassian.jira.charts.DateRangeTimeChart;
import com.atlassian.jira.charts.PieChart;
import com.atlassian.jira.charts.RecentlyCreatedChart;
import com.atlassian.jira.charts.TimeSinceChart;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;

public class DefaultChartFactory
implements ChartFactory {
    private final SearchProvider searchProvider;
    private final VersionManager versionManager;
    private final IssueSearcherManager issueSearcherManager;
    private final ConstantsManager constantsManager;
    private final CustomFieldManager customFieldManager;
    private final FieldManager fieldManager;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final ProjectManager projectManager;
    private final TimeZoneManager timeZoneManager;

    public DefaultChartFactory(SearchProvider searchProvider, VersionManager versionManager, IssueSearcherManager issueSearcherManager, ConstantsManager constantsManager, CustomFieldManager customFieldManager, FieldManager fieldManager, SearchService searchService, ApplicationProperties applicationProperties, ProjectManager projectManager, TimeZoneManager timeZoneManager) {
        this.searchProvider = searchProvider;
        this.versionManager = versionManager;
        this.issueSearcherManager = issueSearcherManager;
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
        this.fieldManager = fieldManager;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.projectManager = projectManager;
        this.timeZoneManager = timeZoneManager;
    }

    public Chart generateCreatedVsResolvedChart(ChartFactory.ChartContext context, int days, ChartFactory.PeriodName periodName, ChartFactory.VersionLabel versionLabel, boolean cumulative, boolean showUnresolvedTrend) {
        try (Ticker ignored = Timers.start((String)"Generating Created vs Resolved chart");){
            CreatedVsResolvedChart createdVsResolvedChart = new CreatedVsResolvedChart(this.searchProvider, this.versionManager, this.issueSearcherManager, this.projectManager, this.applicationProperties, this.searchService, this.timeZoneManager);
            Chart chart = createdVsResolvedChart.generateChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, versionLabel, cumulative, showUnresolvedTrend, context.getWidth(), context.getHeight(), context.isInline());
            return chart;
        }
    }

    public Chart generateDateRangeTimeChart(ChartFactory.ChartContext context, int days, ChartFactory.PeriodName periodName, long yAxisTimePeriod, String labelSuffixKey, String dateFieldId) {
        try (Ticker ignored = Timers.start((String)"Generating Date Range Time chart");){
            DateRangeTimeChart dateRangeChart = new DateRangeTimeChart(this.searchProvider, this.searchService, this.applicationProperties, this.timeZoneManager);
            Chart chart = dateRangeChart.generateChart(context.getRemoteUser(), dateFieldId, context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight(), yAxisTimePeriod, labelSuffixKey, context.isInline());
            return chart;
        }
    }

    public Chart generatePieChart(ChartFactory.ChartContext context, String statisticType) {
        try (Ticker ignored = Timers.start((String)"Generating Pie chart");){
            PieChart pieChart = new PieChart(this.constantsManager, this.customFieldManager, this.searchService, this.applicationProperties);
            Chart chart = pieChart.generateChart(context.getRemoteUser(), context.getSearchRequest(), statisticType, context.getWidth(), context.getHeight(), context.isInline());
            return chart;
        }
    }

    public Chart generateAverageAgeChart(ChartFactory.ChartContext context, int days, ChartFactory.PeriodName periodName) {
        try (Ticker ignored = Timers.start((String)"Generating Average Age chart");){
            AverageAgeChart averageAgeChart = new AverageAgeChart(this.searchProvider, this.timeZoneManager.getLoggedInUserTimeZone());
            Chart chart = averageAgeChart.generateChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight(), context.isInline());
            return chart;
        }
    }

    public Chart generateRecentlyCreated(ChartFactory.ChartContext context, int days, ChartFactory.PeriodName periodName) {
        try (Ticker ignored = Timers.start((String)"Generating Recently Created chart");){
            RecentlyCreatedChart recentlyCreatedChart = new RecentlyCreatedChart(this.searchProvider, this.searchService, this.applicationProperties, this.timeZoneManager);
            Chart chart = recentlyCreatedChart.generateChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight(), context.isInline());
            return chart;
        }
    }

    public Chart generateTimeSinceChart(ChartFactory.ChartContext context, int days, ChartFactory.PeriodName periodName, boolean cumulative, String dateFieldId) {
        try (Ticker ignored = Timers.start((String)"Generating Time Since chart");){
            TimeSinceChart timeSinceChart = new TimeSinceChart(this.fieldManager, this.searchProvider, this.searchService, this.applicationProperties, this.timeZoneManager.getLoggedInUserTimeZone());
            Chart chart = timeSinceChart.generateChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight(), cumulative, dateFieldId, context.isInline());
            return chart;
        }
    }
}

