/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.cache.ehcache;

import com.atlassian.jira.cache.ehcache.customserialization.CustomSerializedValue;
import com.atlassian.jira.cluster.cache.pauser.ReplicationPauserManager;
import java.io.Serializable;
import java.util.function.Supplier;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.RemoteCacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJiraCacheReplicator
implements CacheReplicator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJiraCacheReplicator.class);
    volatile Status status;
    protected final boolean replicatePuts;
    protected final boolean replicatePutsViaCopy;
    protected final boolean replicateUpdates;
    protected final boolean replicateUpdatesViaCopy;
    protected final boolean replicateRemovals;
    protected final Supplier<ReplicationPauserManager> replicationPauserManager;

    protected AbstractJiraCacheReplicator(boolean replicatePuts, boolean replicatePutsViaCopy, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals, Supplier<ReplicationPauserManager> replicationPauserManager) {
        this.replicatePuts = replicatePuts;
        this.replicatePutsViaCopy = replicatePutsViaCopy;
        this.replicateUpdates = replicateUpdates;
        this.replicateUpdatesViaCopy = replicateUpdatesViaCopy;
        this.replicateRemovals = replicateRemovals;
        this.replicationPauserManager = replicationPauserManager;
        this.status = Status.STATUS_ALIVE;
    }

    public boolean isReplicateUpdatesViaCopy() {
        return this.replicateUpdatesViaCopy;
    }

    public boolean notAlive() {
        return !this.alive();
    }

    public boolean alive() {
        return Status.STATUS_ALIVE.equals(this.status);
    }

    private boolean isCacheReplicationPaused() {
        return this.replicationPauserManager.get().isReplicationPaused();
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (this.isCacheReplicationPaused() || this.notAlive() || !this.replicateRemovals) {
            return;
        }
        if (!AbstractJiraCacheReplicator.isElementKeySerializable(element)) {
            this.logUnserializableKey(element, cache);
            return;
        }
        this.replicateRemovalNotification(cache, (Serializable)element.getObjectKey());
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.isCacheReplicationPaused() || this.notAlive() || !this.replicatePuts) {
            return;
        }
        if (this.replicatePutsViaCopy) {
            this.replicateViaCopy(cache, element);
        } else {
            this.replicateViaKeyInvalidation(cache, element);
        }
    }

    static boolean isElementSerializable(Element element) {
        return AbstractJiraCacheReplicator.isElementKeySerializable(element) && element.isSerializable() && (!(element.getObjectValue() instanceof CustomSerializedValue) || ((CustomSerializedValue)element.getObjectValue()).isValueSerializable());
    }

    static boolean isElementKeySerializable(Element element) {
        return element.isKeySerializable() && (!(element.getObjectKey() instanceof CustomSerializedValue) || ((CustomSerializedValue)element.getObjectKey()).isValueSerializable());
    }

    static boolean isElementValueSerializable(Element element) {
        return !(!(element.getObjectValue() instanceof Serializable) && element.getObjectValue() != null || element.getObjectValue() instanceof CustomSerializedValue && !((CustomSerializedValue)element.getObjectValue()).isValueSerializable());
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.isCacheReplicationPaused() || this.notAlive() || !this.replicateUpdates) {
            return;
        }
        if (this.replicateUpdatesViaCopy) {
            if (!AbstractJiraCacheReplicator.isElementSerializable(element)) {
                LOG.warn("Object with key {} is not Serializable and cannot be updated via copy. Cache: {}", element.getObjectKey(), (Object)cache.getName());
                return;
            }
            this.replicatePutNotification(cache, element);
        } else {
            if (!AbstractJiraCacheReplicator.isElementKeySerializable(element)) {
                this.logUnserializableKey(element, cache);
                return;
            }
            this.replicateRemovalNotification(cache, (Serializable)element.getObjectKey());
        }
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (this.isCacheReplicationPaused() || this.notAlive() || !this.replicateRemovals) {
            return;
        }
        this.replicateRemoveAllNotification(cache);
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    private void replicateViaCopy(Ehcache cache, Element element) {
        if (AbstractJiraCacheReplicator.isElementSerializable(element)) {
            this.replicatePutNotification(cache, element);
            return;
        }
        if (!AbstractJiraCacheReplicator.isElementKeySerializable(element)) {
            this.logUnserializableKey(element, cache);
        }
        if (!AbstractJiraCacheReplicator.isElementValueSerializable(element)) {
            this.logUnserializableValue(element, cache);
        }
    }

    private void replicateViaKeyInvalidation(Ehcache cache, Element element) {
        if (AbstractJiraCacheReplicator.isElementKeySerializable(element)) {
            this.replicateRemovalNotification(cache, (Serializable)element.getObjectKey());
            return;
        }
        this.logUnserializableKey(element, cache);
    }

    protected abstract void replicatePutNotification(Ehcache var1, Element var2) throws RemoteCacheException;

    protected abstract void replicateRemovalNotification(Ehcache var1, Serializable var2) throws RemoteCacheException;

    protected abstract void replicateRemoveAllNotification(Ehcache var1);

    private void logUnserializableKey(Element element, Ehcache cache) {
        Object objectKey = element.getObjectKey();
        String objectKeyClassName = objectKey == null ? null : objectKey.getClass().getName();
        LOG.error("Key object {} of class {} is not Serializable => cannot be replicated. Cache: {}", new Object[]{objectKey, objectKeyClassName, cache.getName()});
    }

    private void logUnserializableValue(Element element, Ehcache cache) {
        Object objectValue = element.getObjectValue();
        String objectValueClassName = objectValue == null ? null : objectValue.getClass().getName();
        LOG.error("Value object {} of class {} is not Serializable => cannot be replicated. Cache: {}", new Object[]{objectValue, objectValueClassName, cache.getName()});
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public void dispose() {
        this.status = Status.STATUS_SHUTDOWN;
    }
}

