/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.cache.ehcache;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.ehcache.replication.EhCacheReplicatorConfigFactory;
import com.atlassian.jira.cluster.cache.ehcache.ReplicatorFactory;
import javax.annotation.Nonnull;
import net.sf.ehcache.config.CacheConfiguration;

public class ReplicatorConfigFactory
implements EhCacheReplicatorConfigFactory {
    private static final String CACHE_PROPERTIES = "replicateAsynchronously=%s,replicatePuts=%s,replicatePutsViaCopy=%s,replicateUpdates=%s,replicateUpdatesViaCopy=%s,replicateRemovals=true";

    @Nonnull
    public CacheConfiguration.CacheEventListenerFactoryConfiguration createCacheReplicatorConfiguration(CacheSettings settings, boolean selfLoadingCache) {
        String cacheProperties = String.format(CACHE_PROPERTIES, settings.getReplicateAsynchronously(false), this.shouldReplicatePuts(settings, selfLoadingCache), settings.getReplicateViaCopy(false), this.shouldReplicateUpdates(selfLoadingCache), settings.getReplicateViaCopy(false));
        return (CacheConfiguration.CacheEventListenerFactoryConfiguration)((CacheConfiguration.CacheEventListenerFactoryConfiguration)new CacheConfiguration.CacheEventListenerFactoryConfiguration().className(ReplicatorFactory.class.getName())).properties(cacheProperties);
    }

    private boolean shouldReplicatePuts(CacheSettings settings, boolean selfLoadingCache) {
        return !selfLoadingCache && settings.getReplicateViaCopy(false);
    }

    private boolean shouldReplicateUpdates(boolean selfLoadingCache) {
        return !selfLoadingCache;
    }
}

