/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.dbr;

import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import java.util.List;
import org.apache.lucene.document.Document;

class DBRMessageUpdateWithRelatedData {
    private transient boolean detached = true;
    private Document issue;
    private List<Document> comments;
    private List<Document> worklogs;
    private List<Document> changes;

    private DBRMessageUpdateWithRelatedData() {
    }

    private DBRMessageUpdateWithRelatedData(Document issue, List<Document> comments, List<Document> worklogs, List<Document> changes, boolean detached) {
        this.issue = issue;
        this.comments = comments;
        this.worklogs = worklogs;
        this.changes = changes;
        this.detached = detached;
    }

    static DBRMessageUpdateWithRelatedData create(DefaultIssueIndexer.Documents document) {
        return new DBRMessageUpdateWithRelatedData(document.getIssue(), document.getComments(), document.getWorklogs(), document.getChanges(), false);
    }

    boolean isDetached() {
        return this.detached;
    }

    public Document getIssue() {
        return this.issue;
    }

    public List<Document> getComments() {
        return this.comments;
    }

    public List<Document> getWorklogs() {
        return this.worklogs;
    }

    public List<Document> getChanges() {
        return this.changes;
    }
}

