/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.dbr.transport;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.dbr.DBRMessage;
import com.atlassian.jira.cluster.dbr.transport.DBRTransportManager;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDBRTransportManager
implements DBRTransportManager {
    private static final String DBR_KEY = "DBR";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDBRTransportManager.class);
    private final ClusterManager clusterManager;
    private final Cache<String, DBRMessage> cache;
    private final Set<Consumer<DBRMessage>> consumers = new CopyOnWriteArraySet<Consumer<DBRMessage>>();

    public DefaultDBRTransportManager(ClusterManager clusterManager, CacheManager cacheManager) {
        this.clusterManager = clusterManager;
        this.cache = cacheManager.getCache(DBRMessage.class.getName(), null, new CacheSettingsBuilder().remote().maxEntries(1).replicateViaCopy().build());
        this.cache.addListener((CacheEntryListener)new CacheListener(), true);
    }

    @Override
    public void send(DBRMessage message) {
        Preconditions.checkNotNull((Object)message);
        this.cache.put((Object)DBR_KEY, (Object)message);
    }

    @Override
    public void register(Consumer<DBRMessage> consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void unregister(Consumer<DBRMessage> consumer) {
        this.consumers.remove(consumer);
    }

    private void receive(CacheEntryEvent<String, DBRMessage> event) {
        Preconditions.checkNotNull(event);
        Preconditions.checkNotNull((Object)event.getValue());
        if (!Objects.equals(this.clusterManager.getNodeId(), ((DBRMessage)event.getValue()).getSourceNode())) {
            for (Consumer<DBRMessage> dbrMessageConsumer : this.consumers) {
                try {
                    dbrMessageConsumer.accept((DBRMessage)event.getValue());
                }
                catch (Exception t) {
                    LOGGER.warn("{}An exception occurred during consumming DBRMessage by a consumer. The exception is skipped and the next consumer will receive the message. The bad consumer is {} and the DBRMessage: {}", new Object[]{"[DBR] ", dbrMessageConsumer.getClass().getName(), event.getValue(), t});
                }
            }
        }
    }

    private class CacheListener
    implements CacheEntryListener<String, DBRMessage> {
        private CacheListener() {
        }

        public void onAdd(@Nonnull CacheEntryEvent<String, DBRMessage> event) {
            DefaultDBRTransportManager.this.receive((CacheEntryEvent<String, DBRMessage>)event);
        }

        public void onEvict(@Nonnull CacheEntryEvent<String, DBRMessage> event) {
            LOGGER.warn("{}The DBR cache got an evict signal. it's supposed to be a one-item cache with '{}' key and not get an evict signal. it seems one node had put an entry with different key.", new Object[]{"[DBR] ", DefaultDBRTransportManager.DBR_KEY, new RuntimeException()});
        }

        public void onRemove(@Nonnull CacheEntryEvent<String, DBRMessage> event) {
            LOGGER.warn("{}The DBR cache got a remove signal. it's supposed to be a one-item cache and not get a remove signal. it seems one node had removed an entry.", (Object)"[DBR] ", (Object)new RuntimeException());
        }

        public void onUpdate(@Nonnull CacheEntryEvent<String, DBRMessage> event) {
            DefaultDBRTransportManager.this.receive((CacheEntryEvent<String, DBRMessage>)event);
        }
    }
}

