/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.disasterrecovery;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.api.compat.FilesystemAccess;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.avatar.AvatarFileStoreProvider;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;

public class JiraHomeChangeEventPublisher {
    private final EventPublisher eventPublisher;
    private final AvatarFileStoreProvider avatarFileStoreProvider;

    public JiraHomeChangeEventPublisher(EventPublisher eventPublisher, AvatarFileStoreProvider avatarFileStoreProvider) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.avatarFileStoreProvider = Objects.requireNonNull(avatarFileStoreProvider);
    }

    public void publishIfApplicable(@Nonnull JiraHomeChangeEvent.Action action, @Nonnull JiraHomeChangeEvent.FileType fileType, @Nonnull Collection<FileStore.Path> filesPaths) {
        block3: {
            block2: {
                if (fileType != JiraHomeChangeEvent.FileType.AVATAR) break block2;
                if (!this.avatarFileStoreProvider.isStoreInJiraHome()) break block3;
            }
            File[] files = (File[])filesPaths.stream().filter(FilesystemPath.class::isInstance).map(FilesystemPath.class::cast).map(FilesystemAccess::asJavaFile).toArray(File[]::new);
            this.eventPublisher.publish((Object)new JiraHomeChangeEvent(action, fileType, files));
        }
    }
}

