/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.disasterrecovery;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.api.compat.FilesystemAccess;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.avatar.AvatarFileStoreProvider;
import com.atlassian.jira.cluster.disasterrecovery.CopyTask;
import com.atlassian.jira.cluster.disasterrecovery.DeleteTask;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.AttachmentConfigStore;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.config.util.SecondaryJiraHome;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.filestore.AttachmentFileStoreProvider;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import io.atlassian.util.concurrent.ThreadFactories;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class JiraHomeReplicatorService
extends AbstractService
implements Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraHomeReplicatorService.class);
    private static final String CLASS_NAME = JiraHomeReplicatorService.class.getName();
    private static final JobRunnerKey DELAYED_REPLICATION_KEY = JobRunnerKey.of((String)(CLASS_NAME + ".delayedReplicationKey"));
    private static final JobId DELAYED_REPLICATION_ID = JobId.of((String)(CLASS_NAME + ".delayedReplicationId"));
    private static final JobRunnerKey FULL_REPLICATION_KEY = JobRunnerKey.of((String)(CLASS_NAME + ".fullReplicationKey"));
    private static final JobId FULL_REPLICATION_ID = JobId.of((String)(CLASS_NAME + ".fullReplicationId"));
    private static final String SCHEDULED_REPLICATION_KEY = "homereplicator";
    @VisibleForTesting
    static final String FULL_REPLICATION_LOCK = CLASS_NAME + ".fullReplicationLock";
    private static final int REPLICATOR_THREADS = 4;
    private static final int DEFAULT_IDLE_SECONDS = 60;
    private static final File[] EMPTY_DIR = new File[0];
    private final ApplicationProperties applicationProperties;
    private final AttachmentConfigStore attachmentConfigStore;
    private final AttachmentFileStoreProvider attachmentFileStoreProvider;
    private final AvatarFileStoreProvider avatarFileStoreProvider;
    private final BlockingQueue<JiraHomeChangeEvent> delayedFileReplicationQueue;
    private final ClusterLock fullReplicationLock;
    private final ExecutorService executorService;
    private final Integer idleSeconds;
    private final JiraHome jiraHome;
    private final PluginPath pluginPath;
    private final SchedulerService schedulerService;
    private final SecondaryJiraHome secondaryJiraHome;

    public JiraHomeReplicatorService(JiraHome jiraHome, SecondaryJiraHome secondaryHome, ApplicationProperties applicationProperties, AttachmentConfigStore attachmentConfigStore, PluginPath pluginPath, ClusterLockService clusterLockService, SchedulerService schedulerService, JiraProperties jiraProperties, AvatarFileStoreProvider avatarFileStoreProvider, AttachmentFileStoreProvider attachmentFileStoreProvider) {
        this(jiraHome, secondaryHome, applicationProperties, attachmentConfigStore, pluginPath, clusterLockService.getLockForName(FULL_REPLICATION_LOCK), schedulerService, Executors.newFixedThreadPool(4, ThreadFactories.namedThreadFactory((String)"JiraHomeReplicatorService")), jiraProperties.getInteger("jira.secondary.home.idleSeconds", Integer.valueOf(60)), avatarFileStoreProvider, attachmentFileStoreProvider);
    }

    @VisibleForTesting
    JiraHomeReplicatorService(JiraHome jiraHome, SecondaryJiraHome secondaryHome, ApplicationProperties applicationProperties, AttachmentConfigStore attachmentConfigStore, PluginPath pluginPath, ClusterLock fullReplicationLock, SchedulerService schedulerService, ExecutorService executorService, int idleSeconds, AvatarFileStoreProvider avatarFileStoreProvider, AttachmentFileStoreProvider attachmentFileStoreProvider) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.attachmentConfigStore = Objects.requireNonNull(attachmentConfigStore);
        this.avatarFileStoreProvider = Objects.requireNonNull(avatarFileStoreProvider);
        this.attachmentFileStoreProvider = Objects.requireNonNull(attachmentFileStoreProvider);
        this.delayedFileReplicationQueue = new LinkedBlockingQueue<JiraHomeChangeEvent>();
        this.executorService = Objects.requireNonNull(executorService);
        this.fullReplicationLock = Objects.requireNonNull(fullReplicationLock);
        this.idleSeconds = idleSeconds;
        this.jiraHome = Objects.requireNonNull(jiraHome);
        this.pluginPath = Objects.requireNonNull(pluginPath);
        this.schedulerService = Objects.requireNonNull(schedulerService);
        this.secondaryJiraHome = Objects.requireNonNull(secondaryHome);
    }

    public void start() throws Exception {
        this.schedulerService.registerJobRunner(DELAYED_REPLICATION_KEY, (JobRunner)new QueueDrainingJob());
        this.schedulerService.registerJobRunner(FULL_REPLICATION_KEY, (JobRunner)new FullReplicationJob());
    }

    @EventListener
    public void onFileChangeEvent(JiraHomeChangeEvent event) {
        if (!this.secondaryJiraHome.isEnabled()) {
            return;
        }
        JiraHomeChangeEvent.FileType fileType = event.getFileType();
        if (!this.isEnabled(fileType)) {
            return;
        }
        if (JiraHomeReplicatorService.shouldDelayReplication(fileType)) {
            this.queueDelayedEvent(event);
        } else {
            this.submitEvent(event);
        }
    }

    private static boolean shouldDelayReplication(JiraHomeChangeEvent.FileType fileType) {
        return fileType == JiraHomeChangeEvent.FileType.PLUGIN;
    }

    private void queueDelayedEvent(JiraHomeChangeEvent event) {
        this.delayedFileReplicationQueue.add(event);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)DELAYED_REPLICATION_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce((Date)DateTime.now().plusSeconds(this.idleSeconds.intValue()).toDate()));
        try {
            this.schedulerService.scheduleJob(DELAYED_REPLICATION_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            LOGGER.error("Failed to schedule delayed replication", (Throwable)e);
        }
    }

    private void submitEvent(JiraHomeChangeEvent event) {
        if (event.getAction() == JiraHomeChangeEvent.Action.FILE_ADD) {
            for (File file : event.getFiles()) {
                this.submitCopyTask(file);
            }
        } else {
            for (File file : event.getFiles()) {
                this.submitDeleteTask(file);
            }
        }
    }

    private void submitDeleteTask(File file) {
        LOGGER.debug("submitDeleteTask: file={}", (Object)file);
        this.executorService.submit(new DeleteTask(file, this.jiraHome, this.secondaryJiraHome));
    }

    private void submitCopyTask(File file) {
        LOGGER.debug("submitCopyTask: file={}", (Object)file);
        this.executorService.submit(new CopyTask(file, this.jiraHome, this.secondaryJiraHome, this.executorService));
    }

    @EventListener
    public void shutDown(ComponentManagerShutdownEvent shutdownEvent) {
        LOGGER.debug("Shutting down");
        do {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOGGER.debug("Replication service has not shut down; cancelling replications in progress.");
                    this.executorService.shutdownNow();
                    if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        throw new IllegalStateException("Replicate executor did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        } while (!this.executorService.isTerminated());
    }

    public boolean isEnabled(JiraHomeChangeEvent.FileType fileType) {
        if (fileType == JiraHomeChangeEvent.FileType.ATTACHMENT && !this.attachmentFileStoreProvider.isStoreInJiraHome()) {
            return false;
        }
        if (fileType == JiraHomeChangeEvent.FileType.AVATAR && !this.avatarFileStoreProvider.isStoreInJiraHome()) {
            return false;
        }
        return this.applicationProperties.getOption(fileType.getKey());
    }

    public boolean isReplicating() {
        if (this.fullReplicationLock.tryLock()) {
            this.fullReplicationLock.unlock();
            return false;
        }
        return true;
    }

    public void replicateJiraHome() throws SchedulerServiceException {
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)FULL_REPLICATION_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce(null));
        this.schedulerService.scheduleJob(FULL_REPLICATION_ID, jobConfig);
    }

    public void run() {
        this.performReplication();
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration(SCHEDULED_REPLICATION_KEY, "services/com/atlassian/jira/service/services/homereplicator.xml", null);
    }

    @Nonnull
    public Collection<JiraHomeChangeEvent.FileType> getReplicableFileTypes() {
        EnumSet<JiraHomeChangeEvent.FileType> replicableFileTypes = EnumSet.of(JiraHomeChangeEvent.FileType.INDEX_SNAPSHOT, JiraHomeChangeEvent.FileType.PLUGIN);
        if (this.attachmentFileStoreProvider.isStoreInJiraHome()) {
            replicableFileTypes.add(JiraHomeChangeEvent.FileType.ATTACHMENT);
        }
        if (this.avatarFileStoreProvider.isStoreInJiraHome()) {
            replicableFileTypes.add(JiraHomeChangeEvent.FileType.AVATAR);
        }
        return replicableFileTypes;
    }

    @VisibleForTesting
    void drainQueue() {
        ArrayList events = new ArrayList(this.delayedFileReplicationQueue.size());
        this.delayedFileReplicationQueue.drainTo(events);
        for (JiraHomeChangeEvent jiraHomeChangeEvent : events) {
            this.submitEvent(jiraHomeChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @VisibleForTesting
    Map<JiraHomeChangeEvent.FileType, ReplicationResult> performReplication() {
        try {
            if (!this.fullReplicationLock.tryLock(500L, TimeUnit.MILLISECONDS)) {
                LOGGER.debug("Full replication is already in progress; aborting...");
                return null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.debug("Full replication is already in progress; aborting...");
            return null;
        }
        try {
            LOGGER.debug("Replicating Jira Home with secondary home...");
            EnumMap<JiraHomeChangeEvent.FileType, ReplicationResult> results = new EnumMap<JiraHomeChangeEvent.FileType, ReplicationResult>(JiraHomeChangeEvent.FileType.class);
            for (JiraHomeChangeEvent.FileType fileType : JiraHomeChangeEvent.FileType.values()) {
                this.replicateFileType(results, fileType);
            }
            LOGGER.debug("Jira Home replicated");
            EnumMap<JiraHomeChangeEvent.FileType, ReplicationResult> enumMap = results;
            return enumMap;
        }
        finally {
            this.fullReplicationLock.unlock();
        }
    }

    private void replicateFileType(Map<JiraHomeChangeEvent.FileType, ReplicationResult> results, JiraHomeChangeEvent.FileType fileType) {
        if (this.isEnabled(fileType)) {
            LOGGER.debug("Replicating: {}", (Object)fileType);
            ReplicationResult result = fileType.replicate(this);
            results.put(fileType, result);
            LOGGER.debug("Replicated {}: {}", (Object)fileType, (Object)result);
        } else {
            LOGGER.debug("Not replicated: {}", (Object)fileType);
        }
    }

    ReplicationResult replicateAttachments() {
        if (!this.attachmentFileStoreProvider.isStoreInJiraHome()) {
            LOGGER.debug("Skipping replication of Attachments because they are not stored at a filesystem path.");
            return new ReplicationResult();
        }
        Optional<FileStore.Path> attachmentPath = this.attachmentConfigStore.getConfig().getAttachmentPath();
        return attachmentPath.filter(FilesystemPath.class::isInstance).map(FilesystemPath.class::cast).map(FilesystemAccess::asJavaFile).map(this::replicateDir).orElseGet(ReplicationResult::new);
    }

    ReplicationResult replicateAvatars() {
        if (this.isEnabled(JiraHomeChangeEvent.FileType.AVATAR)) {
            return this.replicateDir(new File(this.jiraHome.getDataDirectory(), "avatars"));
        }
        LOGGER.debug("Skipping avatar replication");
        return new ReplicationResult();
    }

    ReplicationResult replicateIndexSnapshots() {
        return this.replicateDir(this.jiraHome.getIndexSnapshotsDirectory());
    }

    ReplicationResult replicatePlugins() {
        ReplicationResult replicationResult = this.replicateDir(this.pluginPath.getInstalledPluginsDirectory());
        File source = this.pluginPath.getPluginsFreezeFile();
        this.replicateFile(replicationResult, source);
        return replicationResult;
    }

    private void replicateFile(ReplicationResult replicationResult, File source) {
        File destination = new File(StringUtils.replaceOnce((String)source.getAbsolutePath(), (String)this.jiraHome.getHomePath(), (String)this.secondaryJiraHome.getHomePath()));
        boolean sourceExists = source.exists();
        boolean destinationExists = destination.exists();
        if (sourceExists) {
            replicationResult.incrementSourceFileCount();
        }
        if (destinationExists) {
            replicationResult.incrementDestinationFileCount();
        }
        if (sourceExists && (!destinationExists || source.length() != destination.length())) {
            replicationResult.incrementCopiedFileCount();
            this.submitCopyTask(source);
        } else if (!sourceExists && destinationExists) {
            replicationResult.incrementDeletedFileCount();
            this.submitDeleteTask(source);
        }
    }

    private ReplicationResult replicateDir(File sourceDir) {
        String sourcePath = sourceDir.getAbsolutePath();
        File destinationDir = new File(StringUtils.replaceOnce((String)sourcePath, (String)this.jiraHome.getHomePath(), (String)this.secondaryJiraHome.getHomePath()));
        String destPath = destinationDir.getAbsolutePath();
        ReplicationResult result = new ReplicationResult();
        if (destPath.startsWith(sourcePath)) {
            result.setError(new IllegalStateException("Destination [" + destPath + "] is a subdirectory of source [" + sourcePath + "]"));
        } else if (sourcePath.startsWith(destPath)) {
            result.setError(new IllegalStateException("Source [" + sourcePath + "] is a subdirectory of destination [" + destPath + "]"));
        } else {
            this.replicateContents(sourceDir, destinationDir, result);
        }
        return result;
    }

    private void replicateContents(File sourceDir, File destinationDir, ReplicationResult result) {
        HashMap<String, File> filesToProcess = new HashMap<String, File>();
        HashMap<String, File> dirsToProcess = new HashMap<String, File>();
        JiraHomeReplicatorService.processSourceDir(sourceDir, result, filesToProcess, dirsToProcess);
        this.processDestinationDir(destinationDir, result, filesToProcess, dirsToProcess);
        for (File file : filesToProcess.values()) {
            result.incrementCopiedFileCount();
            this.submitCopyTask(file);
        }
        for (File file : dirsToProcess.values()) {
            this.replicateContents(file, null, result);
        }
    }

    private void processDestinationDir(File destinationDir, ReplicationResult result, Map<String, File> filesToProcess, Map<String, File> dirsToProcess) {
        File[] destinationFiles;
        for (File file : destinationFiles = JiraHomeReplicatorService.getFiles(destinationDir)) {
            File original;
            if (file.isDirectory()) {
                original = dirsToProcess.remove(file.getName());
                this.replicateContents(original, file, result);
                continue;
            }
            result.incrementDestinationFileCount();
            original = filesToProcess.remove(file.getName());
            if (original == null) {
                result.incrementDeletedFileCount();
                File deletedFile = new File(StringUtils.replaceOnce((String)file.getAbsolutePath(), (String)this.secondaryJiraHome.getHomePath(), (String)this.jiraHome.getHomePath()));
                this.submitDeleteTask(deletedFile);
                continue;
            }
            if (original.length() == file.length()) continue;
            result.incrementCopiedFileCount();
            this.submitCopyTask(original);
        }
    }

    private static void processSourceDir(File sourceDir, ReplicationResult result, Map<String, File> filesToProcess, Map<String, File> dirsToProcess) {
        File[] sourceFiles;
        for (File file : sourceFiles = JiraHomeReplicatorService.getFiles(sourceDir)) {
            if (file.isDirectory()) {
                dirsToProcess.put(file.getName(), file);
                continue;
            }
            result.incrementSourceFileCount();
            filesToProcess.put(file.getName(), file);
        }
    }

    @Nonnull
    private static File[] getFiles(@Nullable File dir) {
        if (dir == null) {
            return EMPTY_DIR;
        }
        File[] result = dir.listFiles();
        if (result == null) {
            return EMPTY_DIR;
        }
        return result;
    }

    public class FullReplicationJob
    implements JobRunner {
        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            Map<JiraHomeChangeEvent.FileType, ReplicationResult> result = JiraHomeReplicatorService.this.performReplication();
            if (result == null) {
                return JobRunnerResponse.aborted((String)"Full replication is already in progress");
            }
            return JobRunnerResponse.success((String)result.toString());
        }
    }

    public class QueueDrainingJob
    implements JobRunner {
        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            JiraHomeReplicatorService.this.drainQueue();
            return JobRunnerResponse.success();
        }
    }

    public static class ReplicationResult {
        private int sourceFileCount;
        private int destinationFileCount;
        private int copiedFileCount;
        private int deletedFileCount;
        private Exception error;

        public void incrementSourceFileCount() {
            ++this.sourceFileCount;
        }

        public void incrementDestinationFileCount() {
            ++this.destinationFileCount;
        }

        public void incrementCopiedFileCount() {
            ++this.copiedFileCount;
        }

        public void incrementDeletedFileCount() {
            ++this.deletedFileCount;
        }

        public void setError(Exception error) {
            this.error = error;
        }

        public int getSourceFileCount() {
            return this.sourceFileCount;
        }

        public int getDestinationFileCount() {
            return this.destinationFileCount;
        }

        public int getCopiedFileCount() {
            return this.copiedFileCount;
        }

        public int getDeletedFileCount() {
            return this.deletedFileCount;
        }

        public Exception getError() {
            return this.error;
        }

        public String toString() {
            return "ReplicationResult{sourceFileCount=" + this.sourceFileCount + ", destinationFileCount=" + this.destinationFileCount + ", copiedFileCount=" + this.copiedFileCount + ", deletedFileCount=" + this.deletedFileCount + '}';
        }
    }
}

