/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution;

import java.util.function.Supplier;

class ClassLoaderSwitchingSupplier<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private final ClassLoader taskClassLoader;

    ClassLoaderSwitchingSupplier(Supplier<T> supplier) {
        this.supplier = supplier;
        this.taskClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public T get() {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.taskClassLoader);
            T t = this.supplier.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadClassLoader);
        }
    }
}

