/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution;

import com.atlassian.jira.cluster.ReplicatorExecutorServiceFactory;
import com.atlassian.jira.cluster.distribution.JiraCacheManagerPeerProvider;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthRMIClientSocketFactoryHelper;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.RMICacheManagerPeerProviderFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraRMICacheManagerPeerProviderFactory
extends RMICacheManagerPeerProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JiraRMICacheManagerPeerProviderFactory.class);
    public static final String PEER_DISCOVERY = "peerDiscovery";
    public static final String SOCKET_TIMEOUT_MILLIS = "socketTimeoutMillis";

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) throws CacheException {
        String peerDiscovery = PropertyUtil.extractAndLogProperty((String)PEER_DISCOVERY, (Properties)properties);
        Integer socketTimeoutMillis = this.getInteger(PropertyUtil.extractAndLogProperty((String)SOCKET_TIMEOUT_MILLIS, (Properties)properties));
        LOG.info(" Starting Jira instance with {} cache replication strategy", (Object)(peerDiscovery == null ? "default" : peerDiscovery));
        if (peerDiscovery == null || StringUtils.equalsIgnoreCase((CharSequence)peerDiscovery, (CharSequence)"default")) {
            return new JiraCacheManagerPeerProvider(cacheManager, ReplicatorExecutorServiceFactory.getExecutorService(), this.createSocketFactory(socketTimeoutMillis));
        }
        return super.createCachePeerProvider(cacheManager, properties);
    }

    private RMIClientSocketFactory createSocketFactory(Integer socketTimeoutMillis) {
        LOG.debug("Setting up lookup timeout to {}", (Object)socketTimeoutMillis);
        return ClusterAuthRMIClientSocketFactoryHelper.getInstance(socketTimeoutMillis);
    }

    private Integer getInteger(String integer) {
        return integer != null && integer.length() > 0 ? Integer.valueOf(Integer.parseInt(integer)) : null;
    }
}

