/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq;

import com.atlassian.diagnostics.internal.ipd.IpdMetricRegistry;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOp;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOpQueue;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.ipd.JiraIpdMainRegistry;
import com.atlassian.jira.ipd.node.IpdInterNodeStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongUnaryOperator;
import javax.annotation.Nullable;

public class LocalQCacheOpQueueWithStats
implements LocalQCacheOpQueue {
    private final LocalQCacheOpQueue delegate;
    private final int sizeOnCreate;
    private final MutableQueueStats statsSnapshot;
    private final MutableQueueStats statsTotal;
    private final ReentrantLock statsSnapshotLock = new ReentrantLock();
    @Nullable
    private final IpdInterNodeStats ipdNodeStats;

    LocalQCacheOpQueueWithStats(LocalQCacheOpQueue delegate) {
        this(delegate, !delegate.id().replicatePutsViaCopy ? new IpdInterNodeStats((IpdMetricRegistry)JiraIpdMainRegistry.instance(), delegate.id().nodeId) : null);
    }

    LocalQCacheOpQueueWithStats(LocalQCacheOpQueue delegate, @Nullable IpdInterNodeStats ipdNodeStats) {
        this.delegate = delegate;
        this.sizeOnCreate = delegate.size();
        this.statsTotal = MutableQueueStats.create();
        this.statsSnapshot = MutableQueueStats.create();
        this.ipdNodeStats = ipdNodeStats;
    }

    LocalQCacheOpQueue getDelegate() {
        return this.delegate;
    }

    QueueStats statsTotal() {
        return QueueStats.create(this.statsTotal, this);
    }

    QueueStats statsSnapshot() {
        return this.statsSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueueStats statsSnapshot(boolean reset) {
        this.statsSnapshotLock.lock();
        try {
            QueueStats queueStats = QueueStats.create(this.statsSnapshot, this);
            if (reset) {
                this.statsSnapshot.reset();
            }
            QueueStats queueStats2 = queueStats;
            return queueStats2;
        }
        finally {
            this.statsSnapshotLock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        catch (Throwable t) {
            this.closeErrorIncrement();
            throw t;
        }
        finally {
            this.closeIncrement();
            if (this.ipdNodeStats != null) {
                this.ipdNodeStats.close();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    private void closeErrorIncrement() {
        this.statsTotal.closeErrorsCounter.incrementAndGet();
        this.statsSnapshot.closeErrorsCounter.incrementAndGet();
    }

    private void closeIncrement() {
        this.statsTotal.closeCounter.incrementAndGet();
        this.statsSnapshot.closeCounter.incrementAndGet();
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public LocalQCacheOpQueue.QueueId id() {
        return this.delegate.id();
    }

    @Override
    public boolean add(LocalQCacheOp localQCacheOp) throws IllegalStateException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            boolean isAdded = this.delegate.add(localQCacheOp);
            if (!isAdded) {
                this.droppedOnAddIncrement();
            }
            boolean bl = isAdded;
            return bl;
        }
        catch (Throwable t) {
            this.addErrorIncrement();
            throw t;
        }
        finally {
            this.addTime(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            this.addIncrement(localQCacheOp.getCacheName());
            this.addLastTimestamp();
        }
    }

    private void addTime(long millis) {
        this.statsTotal.timeToAddMillis.accept(millis);
        this.statsSnapshot.timeToAddMillis.accept(millis);
    }

    private void addErrorIncrement() {
        this.statsTotal.addErrorsCounter.incrementAndGet();
        this.statsSnapshot.addErrorsCounter.incrementAndGet();
    }

    void addIncrement(String cacheName) {
        this.statsTotal.addIncrement(cacheName);
        this.statsSnapshot.addIncrement(cacheName);
    }

    private void droppedOnAddIncrement() {
        this.statsTotal.droppedOnAddCounter.incrementAndGet();
        this.statsSnapshot.droppedOnAddCounter.incrementAndGet();
    }

    private void addLastTimestamp() {
        long now = System.currentTimeMillis();
        this.statsTotal.lastAddTimestampMillis.set(now);
        this.statsSnapshot.lastAddTimestampMillis.set(now);
    }

    @Override
    @Nullable
    public LocalQCacheOp peek() throws IllegalStateException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            LocalQCacheOp localQCacheOp = this.delegate.peek();
            return localQCacheOp;
        }
        catch (Throwable t) {
            this.peekErrorIncrement();
            throw t;
        }
        finally {
            this.peekTime(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            this.peekIncrement();
            this.peekLastTimestamp();
        }
    }

    private void peekTime(long millis) {
        this.statsTotal.timeToPeekMillis.accept(millis);
        this.statsSnapshot.timeToPeekMillis.accept(millis);
    }

    private void peekErrorIncrement() {
        this.statsTotal.peekErrorsCounter.incrementAndGet();
        this.statsSnapshot.peekErrorsCounter.incrementAndGet();
    }

    private void peekIncrement() {
        this.statsTotal.peekCounter.incrementAndGet();
        this.statsSnapshot.peekCounter.incrementAndGet();
    }

    private void peekLastTimestamp() {
        long now = System.currentTimeMillis();
        this.statsTotal.lastPeekTimestampMillis.set(now);
        this.statsSnapshot.lastPeekTimestampMillis.set(now);
    }

    @Override
    @Nullable
    public LocalQCacheOp peekOrBlock() throws InterruptedException, IllegalStateException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            LocalQCacheOp localQCacheOp = this.delegate.peekOrBlock();
            return localQCacheOp;
        }
        catch (Throwable t) {
            this.peekOrBlockErrorIncrement();
            throw t;
        }
        finally {
            this.peekOrBlockTime(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            this.peekOrBlockIncrement();
            this.peekOrBlockLastTimestamp();
        }
    }

    private void peekOrBlockTime(long millis) {
        this.statsTotal.timeToPeekOrBlockMillis.accept(millis);
        this.statsSnapshot.timeToPeekOrBlockMillis.accept(millis);
    }

    private void peekOrBlockErrorIncrement() {
        this.statsTotal.peekOrBlockErrorsCounter.incrementAndGet();
        this.statsSnapshot.peekOrBlockErrorsCounter.incrementAndGet();
    }

    private void peekOrBlockIncrement() {
        this.statsTotal.peekOrBlockCounter.incrementAndGet();
        this.statsSnapshot.peekOrBlockCounter.incrementAndGet();
    }

    private void peekOrBlockLastTimestamp() {
        long now = System.currentTimeMillis();
        this.statsTotal.lastPeekOrBlockTimestampMillis.set(now);
        this.statsSnapshot.lastPeekOrBlockTimestampMillis.set(now);
    }

    @Override
    public void remove() throws NoSuchElementException, IllegalStateException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.delegate.remove();
        }
        catch (Throwable t) {
            this.removeErrorIncrement();
            throw t;
        }
        finally {
            this.removeTime(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            this.removeIncrement();
            this.removeLastTimestamp();
        }
    }

    private void removeTime(long millis) {
        this.statsTotal.timeToRemoveMillis.accept(millis);
        this.statsSnapshot.timeToRemoveMillis.accept(millis);
    }

    private void removeErrorIncrement() {
        this.statsTotal.removeErrorsCounter.incrementAndGet();
        this.statsSnapshot.removeErrorsCounter.incrementAndGet();
    }

    private void removeIncrement() {
        this.statsTotal.removeCounter.incrementAndGet();
        this.statsSnapshot.removeCounter.incrementAndGet();
    }

    private void removeLastTimestamp() {
        long now = System.currentTimeMillis();
        this.statsTotal.lastRemoveTimestampMillis.set(now);
        this.statsSnapshot.lastRemoveTimestampMillis.set(now);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void backupQueue(String prefix) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.delegate.backupQueue(prefix);
        }
        catch (Throwable t) {
            this.backupQueueErrorIncrement();
            throw t;
        }
        finally {
            this.backupQueueTime(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            this.backupQueueIncrement();
            this.backupQueueLastTimestamp();
        }
    }

    private void backupQueueTime(long millis) {
        this.statsTotal.timeToBackupQueueMillis.accept(millis);
        this.statsSnapshot.timeToBackupQueueMillis.accept(millis);
    }

    private void backupQueueErrorIncrement() {
        this.statsTotal.backupQueueErrorsCounter.incrementAndGet();
        this.statsSnapshot.backupQueueErrorsCounter.incrementAndGet();
    }

    private void backupQueueIncrement() {
        this.statsTotal.backupQueueCounter.incrementAndGet();
        this.statsSnapshot.backupQueueCounter.incrementAndGet();
    }

    private void backupQueueLastTimestamp() {
        long now = System.currentTimeMillis();
        this.statsTotal.lastBackupQueueTimestampMillis.set(now);
        this.statsSnapshot.lastBackupQueueTimestampMillis.set(now);
    }

    void notifyStale() {
        this.statsTotal.staleCounter.incrementAndGet();
        this.statsSnapshot.staleCounter.incrementAndGet();
    }

    void notifySendWithTime(long timeInMillis) {
        this.statsTotal.sendCounter.incrementAndGet();
        this.statsSnapshot.sendCounter.incrementAndGet();
        this.statsTotal.timeToSendMillis.accept(timeInMillis);
        this.statsSnapshot.timeToSendMillis.accept(timeInMillis);
        if (this.ipdNodeStats != null) {
            this.ipdNodeStats.updateNodeLatency(timeInMillis);
        }
    }

    void notifyDroppedOnSend() {
        this.statsTotal.droppedOnSendCounter.incrementAndGet();
        this.statsSnapshot.droppedOnSendCounter.incrementAndGet();
    }

    void notifyRuntimeException() {
        this.statsTotal.sendRuntimeExceptionCounter.incrementAndGet();
        this.statsSnapshot.sendRuntimeExceptionCounter.incrementAndGet();
    }

    void notifyCheckedException() {
        this.statsTotal.sendCheckedExceptionCounter.incrementAndGet();
        this.statsSnapshot.sendCheckedExceptionCounter.incrementAndGet();
        if (this.ipdNodeStats != null) {
            this.ipdNodeStats.setDisconnectedState();
        }
    }

    void notifyNotBoundException() {
        this.statsTotal.sendNotBoundExceptionCounter.incrementAndGet();
        this.statsSnapshot.sendNotBoundExceptionCounter.incrementAndGet();
    }

    void notifyOtherException() {
        this.statsTotal.sendOtherExceptionCounter.incrementAndGet();
        this.statsSnapshot.sendOtherExceptionCounter.incrementAndGet();
    }

    void notifyCriticalAdd() {
        this.statsTotal.criticalAddCounter.incrementAndGet();
        this.statsSnapshot.criticalAddCounter.incrementAndGet();
    }

    void notifyCriticalPeek() {
        this.statsTotal.criticalPeekCounter.incrementAndGet();
        this.statsSnapshot.criticalPeekCounter.incrementAndGet();
    }

    void notifyCriticalRemove() {
        this.statsTotal.criticalRemoveCounter.incrementAndGet();
        this.statsSnapshot.criticalRemoveCounter.incrementAndGet();
    }

    @Override
    @Nullable
    public Long usableSpaceInBytes() {
        return this.delegate.usableSpaceInBytes();
    }

    @Override
    public boolean hasPermission() {
        return this.delegate.hasPermission();
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static class QueueStats {
        static final String SYSTEM_PROPERTY_TOP_N = "com.atlassian.jira.cluster.distribution.localq.stats.queue.names.topN";
        static final int TOP_N_CACHES = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.cluster.distribution.localq.stats.queue.names.topN", Integer.valueOf(10));
        private static final Comparator<Map.Entry<String, AtomicLong>> COMPARE_MAP_ENTRY_BY_VALUE_DESC_THEN_BY_KEY_ASC = Map.Entry.comparingByValue(Comparator.comparingLong(AtomicLong::longValue).reversed()).thenComparing(Map.Entry.comparingByKey());
        public final long timestampMillis;
        public final String nodeId;
        @Nullable
        public final Integer nodeQueueNumber;
        public final int queueSize;
        public final int startQueueSize;
        public final long startTimestampMillis;
        public final long startMillisAgo;
        public final long closeCounter;
        public final long addCounter;
        public final long droppedOnAddCounter;
        public final long criticalAddCounter;
        public final long criticalPeekCounter;
        public final long criticalRemoveCounter;
        public final long peekCounter;
        public final long peekOrBlockCounter;
        public final long removeCounter;
        public final long backupQueueCounter;
        public final long closeErrorsCounter;
        public final long addErrorsCounter;
        public final long peekErrorsCounter;
        public final long peekOrBlockErrorsCounter;
        public final long removeErrorsCounter;
        public final long backupQueueErrorsCounter;
        public final long lastAddTimestampMillis;
        public final long lastAddMillisAgo;
        public final long lastPeekTimestampMillis;
        public final long lastPeekMillisAgo;
        public final long lastPeekOrBlockTimestampMillis;
        public final long lastPeekOrBlockMillisAgo;
        public final long lastRemoveTimestampMillis;
        public final long lastRemoveMillisAgo;
        public final long lastBackupQueueTimestampMillis;
        public final long lastBackupQueueMillisAgo;
        public final LongStats timeToAddMillis;
        public final LongStats timeToPeekMillis;
        public final LongStats timeToPeekOrBlockMillis;
        public final LongStats timeToRemoveMillis;
        public final LongStats timeToBackupQueueMillis;
        public final long staleCounter;
        public final long sendCounter;
        public final long droppedOnSendCounter;
        public final LongStats timeToSendMillis;
        public final long sendRuntimeExceptionCounter;
        public final long sendCheckedExceptionCounter;
        public final long sendNotBoundExceptionCounter;
        public final long sendOtherExceptionCounter;
        public final int numberOfCaches;
        public final long addCounterTopN;
        public final long addCounterOthers;
        public final ImmutableMap<String, Long> addCounterByCacheTopN;

        public static QueueStats createWithEmptyStats(String nodeId, @Nullable Integer nodeQueueNumber, int queueSize, int startQueueSize) {
            return new QueueStats(MutableQueueStats.create(), nodeId, nodeQueueNumber, queueSize, startQueueSize);
        }

        QueueStats(MutableQueueStats mutableStats, String nodeId, @Nullable Integer nodeQueueNumber, int queueSize, int startQueueSize) {
            long nowInMillis;
            this.timestampMillis = nowInMillis = System.currentTimeMillis();
            this.nodeId = nodeId;
            this.nodeQueueNumber = nodeQueueNumber;
            this.queueSize = queueSize;
            this.startQueueSize = startQueueSize;
            this.startTimestampMillis = mutableStats.startTimestampMillis.get();
            this.startMillisAgo = QueueStats.lastTimestampToAgo(nowInMillis, this.startTimestampMillis);
            this.closeCounter = mutableStats.closeCounter.get();
            this.addCounter = mutableStats.addCounter.get();
            this.droppedOnAddCounter = mutableStats.droppedOnAddCounter.get();
            this.criticalAddCounter = mutableStats.criticalAddCounter.get();
            this.criticalPeekCounter = mutableStats.criticalPeekCounter.get();
            this.criticalRemoveCounter = mutableStats.criticalRemoveCounter.get();
            this.peekCounter = mutableStats.peekCounter.get();
            this.peekOrBlockCounter = mutableStats.peekOrBlockCounter.get();
            this.removeCounter = mutableStats.removeCounter.get();
            this.backupQueueCounter = mutableStats.backupQueueCounter.get();
            this.closeErrorsCounter = mutableStats.closeErrorsCounter.get();
            this.addErrorsCounter = mutableStats.addErrorsCounter.get();
            this.peekErrorsCounter = mutableStats.peekErrorsCounter.get();
            this.peekOrBlockErrorsCounter = mutableStats.peekOrBlockErrorsCounter.get();
            this.removeErrorsCounter = mutableStats.removeErrorsCounter.get();
            this.backupQueueErrorsCounter = mutableStats.backupQueueErrorsCounter.get();
            this.lastAddTimestampMillis = mutableStats.lastAddTimestampMillis.get();
            this.lastAddMillisAgo = QueueStats.lastTimestampToAgo(nowInMillis, this.lastAddTimestampMillis);
            this.lastPeekTimestampMillis = mutableStats.lastPeekTimestampMillis.get();
            this.lastPeekMillisAgo = QueueStats.lastTimestampToAgo(nowInMillis, this.lastPeekTimestampMillis);
            this.lastPeekOrBlockTimestampMillis = mutableStats.lastPeekOrBlockTimestampMillis.get();
            this.lastPeekOrBlockMillisAgo = QueueStats.lastTimestampToAgo(nowInMillis, this.lastPeekOrBlockTimestampMillis);
            this.lastRemoveTimestampMillis = mutableStats.lastRemoveTimestampMillis.get();
            this.lastRemoveMillisAgo = QueueStats.lastTimestampToAgo(nowInMillis, this.lastRemoveTimestampMillis);
            this.lastBackupQueueTimestampMillis = mutableStats.lastBackupQueueTimestampMillis.get();
            this.lastBackupQueueMillisAgo = QueueStats.lastTimestampToAgo(nowInMillis, this.lastBackupQueueTimestampMillis);
            this.timeToAddMillis = mutableStats.timeToAddMillis.get();
            this.timeToPeekMillis = mutableStats.timeToPeekMillis.get();
            this.timeToPeekOrBlockMillis = mutableStats.timeToPeekOrBlockMillis.get();
            this.timeToRemoveMillis = mutableStats.timeToRemoveMillis.get();
            this.timeToBackupQueueMillis = mutableStats.timeToBackupQueueMillis.get();
            this.staleCounter = mutableStats.staleCounter.get();
            this.sendCounter = mutableStats.sendCounter.get();
            this.droppedOnSendCounter = mutableStats.droppedOnSendCounter.get();
            this.timeToSendMillis = mutableStats.timeToSendMillis.get();
            this.sendRuntimeExceptionCounter = mutableStats.sendRuntimeExceptionCounter.get();
            this.sendCheckedExceptionCounter = mutableStats.sendCheckedExceptionCounter.get();
            this.sendNotBoundExceptionCounter = mutableStats.sendNotBoundExceptionCounter.get();
            this.sendOtherExceptionCounter = mutableStats.sendOtherExceptionCounter.get();
            this.numberOfCaches = mutableStats.addCounterByCache.size();
            this.addCounterByCacheTopN = (ImmutableMap)mutableStats.addCounterByCache.entrySet().stream().sorted(COMPARE_MAP_ENTRY_BY_VALUE_DESC_THEN_BY_KEY_ASC).limit(TOP_N_CACHES).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((AtomicLong)e.getValue()).get()));
            this.addCounterTopN = this.addCounterByCacheTopN.values().stream().mapToLong(Long::longValue).sum();
            this.addCounterOthers = this.addCounter - this.addCounterTopN;
        }

        private static long lastTimestampToAgo(long now, long lastTimestamp) {
            if (lastTimestamp > 0L) {
                return now - lastTimestamp;
            }
            return 0L;
        }

        static QueueStats merge(String nodeId, List<QueueStats> stats) {
            long initialMergeStatStartTimestamp = stats.isEmpty() ? 0L : Long.MAX_VALUE;
            MutableQueueStats mutableStats = new MutableQueueStats(initialMergeStatStartTimestamp);
            int sumQueueSize = 0;
            int sumStartQueueSize = 0;
            for (QueueStats queueStats : stats) {
                Preconditions.checkArgument((boolean)queueStats.nodeId.equals(nodeId));
                mutableStats.merge(queueStats);
                sumQueueSize += queueStats.queueSize;
                sumStartQueueSize += queueStats.startQueueSize;
            }
            return new QueueStats(mutableStats, nodeId, null, sumQueueSize, sumStartQueueSize);
        }

        static QueueStats create(MutableQueueStats mutableStats, LocalQCacheOpQueueWithStats delegate) {
            return new QueueStats(mutableStats, delegate.id().nodeId, delegate.id().nodeQueueNumber, delegate.size(), delegate.sizeOnCreate);
        }
    }

    static class MutableQueueStats {
        final AtomicLong startTimestampMillis;
        final AtomicLong closeCounter = new AtomicLong(0L);
        final AtomicLong addCounter = new AtomicLong(0L);
        final AtomicLong droppedOnAddCounter = new AtomicLong(0L);
        final AtomicLong criticalAddCounter = new AtomicLong(0L);
        final AtomicLong criticalPeekCounter = new AtomicLong(0L);
        final AtomicLong criticalRemoveCounter = new AtomicLong(0L);
        final AtomicLong peekCounter = new AtomicLong(0L);
        final AtomicLong peekOrBlockCounter = new AtomicLong(0L);
        final AtomicLong removeCounter = new AtomicLong(0L);
        final AtomicLong backupQueueCounter = new AtomicLong(0L);
        final AtomicLong closeErrorsCounter = new AtomicLong(0L);
        final AtomicLong addErrorsCounter = new AtomicLong(0L);
        final AtomicLong peekErrorsCounter = new AtomicLong(0L);
        final AtomicLong peekOrBlockErrorsCounter = new AtomicLong(0L);
        final AtomicLong removeErrorsCounter = new AtomicLong(0L);
        final AtomicLong backupQueueErrorsCounter = new AtomicLong(0L);
        final AtomicLong lastAddTimestampMillis = new AtomicLong(0L);
        final AtomicLong lastPeekTimestampMillis = new AtomicLong(0L);
        final AtomicLong lastPeekOrBlockTimestampMillis = new AtomicLong(0L);
        final AtomicLong lastRemoveTimestampMillis = new AtomicLong(0L);
        final AtomicLong lastBackupQueueTimestampMillis = new AtomicLong(0L);
        final MutableLongStats timeToAddMillis = new MutableLongStats(new long[]{10L, 20L, 50L, 100L});
        final MutableLongStats timeToPeekMillis = new MutableLongStats(new long[0]);
        final MutableLongStats timeToPeekOrBlockMillis = new MutableLongStats(new long[0]);
        final MutableLongStats timeToRemoveMillis = new MutableLongStats(new long[]{10L, 20L, 50L, 100L});
        final MutableLongStats timeToBackupQueueMillis = new MutableLongStats(new long[0]);
        final AtomicLong staleCounter = new AtomicLong(0L);
        final AtomicLong sendCounter = new AtomicLong(0L);
        final AtomicLong droppedOnSendCounter = new AtomicLong(0L);
        final MutableLongStats timeToSendMillis = new MutableLongStats(new long[]{10L, 20L, 50L, 100L, 200L, 500L, 1000L, 5000L});
        final AtomicLong sendRuntimeExceptionCounter = new AtomicLong(0L);
        final AtomicLong sendCheckedExceptionCounter = new AtomicLong(0L);
        final AtomicLong sendNotBoundExceptionCounter = new AtomicLong(0L);
        final AtomicLong sendOtherExceptionCounter = new AtomicLong(0L);
        final Map<String, AtomicLong> addCounterByCache = new ConcurrentHashMap<String, AtomicLong>();

        MutableQueueStats(long startTimestampMillis) {
            this.startTimestampMillis = new AtomicLong(startTimestampMillis);
        }

        private static long nowInMillis() {
            return System.currentTimeMillis();
        }

        static MutableQueueStats create() {
            return new MutableQueueStats(MutableQueueStats.nowInMillis());
        }

        void addIncrement(String cacheName) {
            this.addCounter.incrementAndGet();
            this.addCounterByCache.computeIfAbsent(cacheName, s -> new AtomicLong()).incrementAndGet();
        }

        private void reset() {
            this.startTimestampMillis.set(MutableQueueStats.nowInMillis());
            this.closeCounter.set(0L);
            this.addCounter.set(0L);
            this.droppedOnAddCounter.set(0L);
            this.criticalAddCounter.set(0L);
            this.criticalPeekCounter.set(0L);
            this.criticalRemoveCounter.set(0L);
            this.peekCounter.set(0L);
            this.peekOrBlockCounter.set(0L);
            this.removeCounter.set(0L);
            this.backupQueueCounter.set(0L);
            this.closeErrorsCounter.set(0L);
            this.addErrorsCounter.set(0L);
            this.peekErrorsCounter.set(0L);
            this.peekOrBlockErrorsCounter.set(0L);
            this.removeErrorsCounter.set(0L);
            this.backupQueueErrorsCounter.set(0L);
            this.lastAddTimestampMillis.set(0L);
            this.lastPeekTimestampMillis.set(0L);
            this.lastPeekOrBlockTimestampMillis.set(0L);
            this.lastRemoveTimestampMillis.set(0L);
            this.lastBackupQueueTimestampMillis.set(0L);
            this.timeToAddMillis.reset();
            this.timeToPeekMillis.reset();
            this.timeToPeekOrBlockMillis.reset();
            this.timeToRemoveMillis.reset();
            this.timeToBackupQueueMillis.reset();
            this.staleCounter.set(0L);
            this.sendCounter.set(0L);
            this.droppedOnSendCounter.set(0L);
            this.timeToSendMillis.reset();
            this.sendRuntimeExceptionCounter.set(0L);
            this.sendCheckedExceptionCounter.set(0L);
            this.sendNotBoundExceptionCounter.set(0L);
            this.sendOtherExceptionCounter.set(0L);
            this.addCounterByCache.clear();
        }

        LongUnaryOperator max(long otherValue) {
            return currentValue -> otherValue > currentValue ? otherValue : currentValue;
        }

        LongUnaryOperator min(long otherValue) {
            return currentValue -> otherValue < currentValue ? otherValue : currentValue;
        }

        public void merge(QueueStats queueStats) {
            this.startTimestampMillis.updateAndGet(this.min(queueStats.startTimestampMillis));
            this.closeCounter.addAndGet(queueStats.closeCounter);
            this.addCounter.addAndGet(queueStats.addCounter);
            this.droppedOnAddCounter.addAndGet(queueStats.droppedOnAddCounter);
            this.criticalAddCounter.addAndGet(queueStats.criticalAddCounter);
            this.criticalPeekCounter.addAndGet(queueStats.criticalPeekCounter);
            this.criticalRemoveCounter.addAndGet(queueStats.criticalRemoveCounter);
            this.peekCounter.addAndGet(queueStats.peekCounter);
            this.peekOrBlockCounter.addAndGet(queueStats.peekOrBlockCounter);
            this.removeCounter.addAndGet(queueStats.removeCounter);
            this.backupQueueCounter.addAndGet(queueStats.backupQueueCounter);
            this.closeErrorsCounter.addAndGet(queueStats.closeErrorsCounter);
            this.addErrorsCounter.addAndGet(queueStats.addErrorsCounter);
            this.peekErrorsCounter.addAndGet(queueStats.peekErrorsCounter);
            this.peekOrBlockErrorsCounter.addAndGet(queueStats.peekOrBlockErrorsCounter);
            this.removeErrorsCounter.addAndGet(queueStats.removeErrorsCounter);
            this.backupQueueErrorsCounter.addAndGet(queueStats.backupQueueErrorsCounter);
            this.lastAddTimestampMillis.updateAndGet(this.max(queueStats.lastAddTimestampMillis));
            this.lastPeekTimestampMillis.updateAndGet(this.max(queueStats.lastPeekTimestampMillis));
            this.lastPeekOrBlockTimestampMillis.updateAndGet(this.max(queueStats.lastPeekOrBlockTimestampMillis));
            this.lastRemoveTimestampMillis.updateAndGet(this.max(queueStats.lastRemoveTimestampMillis));
            this.lastBackupQueueTimestampMillis.updateAndGet(this.max(queueStats.lastBackupQueueTimestampMillis));
            this.timeToAddMillis.merge(queueStats.timeToAddMillis);
            this.timeToPeekMillis.merge(queueStats.timeToPeekMillis);
            this.timeToPeekOrBlockMillis.merge(queueStats.timeToPeekOrBlockMillis);
            this.timeToRemoveMillis.merge(queueStats.timeToRemoveMillis);
            this.timeToBackupQueueMillis.merge(queueStats.timeToBackupQueueMillis);
            this.staleCounter.addAndGet(queueStats.staleCounter);
            this.sendCounter.addAndGet(queueStats.sendCounter);
            this.droppedOnSendCounter.addAndGet(queueStats.droppedOnSendCounter);
            this.timeToSendMillis.merge(queueStats.timeToSendMillis);
            this.sendRuntimeExceptionCounter.addAndGet(queueStats.sendRuntimeExceptionCounter);
            this.sendCheckedExceptionCounter.addAndGet(queueStats.sendCheckedExceptionCounter);
            this.sendNotBoundExceptionCounter.addAndGet(queueStats.sendNotBoundExceptionCounter);
            this.sendOtherExceptionCounter.addAndGet(queueStats.sendOtherExceptionCounter);
            queueStats.addCounterByCacheTopN.forEach((k, v) -> this.addCounterByCache.merge((String)k, new AtomicLong((long)v), (v1, v2) -> {
                v2.addAndGet(v1.get());
                return v2;
            }));
        }
    }
}

