/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi.ehcache;

import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthRMIClientSocketFactoryHelper;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthRMIServerSocketFactory;
import com.atlassian.jira.cluster.distribution.localq.rmi.ehcache.RMICacheManagerPeerListener;
import com.atlassian.jira.cluster.distribution.localq.rmi.ehcache.RMICachePeer;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.RMICacheManagerPeerListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraRMICacheManagerPeerListenerFactory
extends RMICacheManagerPeerListenerFactory {
    private static final Logger log = LoggerFactory.getLogger(JiraRMICacheManagerPeerListenerFactory.class);

    protected CacheManagerPeerListener doCreateCachePeerListener(String hostName, Integer port, Integer remoteObjectPort, CacheManager cacheManager, Integer socketTimeoutMillis) {
        try {
            return new RMICacheManagerPeerListener(hostName, port, remoteObjectPort, cacheManager, socketTimeoutMillis){

                @Override
                protected void startRegistry() throws RemoteException {
                    try {
                        this.registry = LocateRegistry.getRegistry(this.hostName, this.port, ClusterAuthRMIClientSocketFactoryHelper.getInstance(this.socketTimeoutMillis));
                        try {
                            this.registry.list();
                        }
                        catch (RemoteException e) {
                            this.registry = LocateRegistry.createRegistry(this.port, ClusterAuthRMIClientSocketFactoryHelper.getInstance(this.socketTimeoutMillis), ClusterAuthRMIServerSocketFactory.getInstance());
                            this.registryCreated = true;
                        }
                    }
                    catch (ExportException exception) {
                        log.error("Exception starting RMI registry. Error was " + exception.getMessage(), (Throwable)exception);
                    }
                }

                @Override
                protected void bind(String peerName, RMICachePeer rmiCachePeer) throws Exception {
                    this.registry.rebind(peerName, rmiCachePeer);
                }

                @Override
                protected void unbind(RMICachePeer rmiCachePeer) throws Exception {
                    String url = rmiCachePeer.getUrl();
                    try {
                        this.registry.unbind(rmiCachePeer.getName());
                    }
                    catch (NotBoundException e) {
                        log.warn(url + " not bound therefore not unbinding.");
                    }
                    boolean unexported = UnicastRemoteObject.unexportObject(rmiCachePeer, false);
                    for (int count = 1; count < 10 && !unexported; ++count) {
                        try {
                            Thread.sleep(400L);
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                        unexported = UnicastRemoteObject.unexportObject(rmiCachePeer, false);
                    }
                    if (!unexported && !UnicastRemoteObject.unexportObject(rmiCachePeer, true)) {
                        log.warn("Unable to unexport rmiCachePeer: " + rmiCachePeer.getUrl() + ".  Skipping.");
                    }
                }
            };
        }
        catch (UnknownHostException e) {
            throw new CacheException("Unable to create CacheManagerPeerListener. Initial cause was " + e.getMessage(), (Throwable)e);
        }
    }
}

