/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.tape;

import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOp;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOpQueue;
import com.atlassian.jira.cluster.distribution.localq.LocalQCriticalHandler;
import com.atlassian.jira.cluster.distribution.localq.LogPrefix;
import com.atlassian.jira.cluster.distribution.localq.tape.TapeLocalQCacheOpConverter;
import com.atlassian.jira.component.pico.ContainerNotInitializedException;
import com.google.common.base.Stopwatch;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapeLocalQCriticalHandler
implements LocalQCriticalHandler {
    static final String CORRUPTED_PREFIX = "corrupted_";
    private static final AtomicLong containerUninitializedErrorFirstOccurrence = new AtomicLong(0L);
    private static final AtomicLong containerUninitializedErrorLogTimes = new AtomicLong(0L);
    private static final Logger LOG = LoggerFactory.getLogger(TapeLocalQCriticalHandler.class);
    private static final NotTooOftenLogger containerUninitializedErrorLogger = new NotTooOftenLogger(LOG, TimeUnit.SECONDS.toMillis(5L));

    @Override
    public boolean handleCriticalAdd(LocalQCacheOpQueue localQCacheOpQueue, LocalQCacheOp toAdd, Throwable t) {
        return TapeLocalQCriticalHandler.handleClosedQueue(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleNoPermission(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleNotEnoughSpace(localQCacheOpQueue, toAdd, t);
    }

    @Override
    public boolean handleCriticalPeek(LocalQCacheOpQueue localQCacheOpQueue, Throwable t) {
        return this.handlePeekWhileContainerIsUninitialized(t) || TapeLocalQCriticalHandler.handleClosedQueue(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handlePeekProblemByTryingToRemoveFromQueueHead(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleNoPermission(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleFileCorrupted(localQCacheOpQueue, t);
    }

    @Override
    public boolean handleCriticalRemove(LocalQCacheOpQueue localQCacheOpQueue, LocalQCacheOp toRemove, Throwable t) {
        return TapeLocalQCriticalHandler.handleClosedQueue(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleNoPermission(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleFileCorrupted(localQCacheOpQueue, t);
    }

    private static boolean handleClosedQueue(LocalQCacheOpQueue queue, Throwable t) {
        if (ExceptionUtils.indexOfType((Throwable)t, IllegalStateException.class) >= 0 && queue.isClosed()) {
            LOG.debug(LogPrefix.prefix() + "{} when performing an operation on a closed queue: {}.", new Object[]{t.getClass().getSimpleName(), queue.name(), t});
            return true;
        }
        return false;
    }

    private static boolean handlePeekProblemByTryingToRemoveFromQueueHead(LocalQCacheOpQueue queue, Throwable t) {
        if (ExceptionUtils.indexOfType((Throwable)t, ClassNotFoundException.class) >= 0) {
            LOG.warn(LogPrefix.prefix() + "Could not deserialize cache replication event from queue, error: {}. Trying to remove it from queue head: {}. ", new Object[]{t.getMessage(), queue.name(), t});
        }
        try {
            queue.remove();
            LOG.warn(LogPrefix.prefix() + "Removed cache replication event from queue head: {}. Note that this may cause the cluster to be out of sync.", (Object)queue.name(), (Object)t);
            return true;
        }
        catch (Throwable anything) {
            return false;
        }
    }

    private static boolean handleNoPermission(LocalQCacheOpQueue queue, Throwable t) {
        if (queue.hasPermission()) {
            return false;
        }
        LOG.error(LogPrefix.prefix() + "Jira needs read/write permissions to: {} in order to provide cache replication mechanism. This is a fatal error. Skipping replication. Cluster may be out of sync.", (Object)queue.name());
        return true;
    }

    private static boolean handleNotEnoughSpace(LocalQCacheOpQueue localQCacheOpQueue, LocalQCacheOp localQCacheOp, Throwable t) {
        Long usableSpaceInBytes = localQCacheOpQueue.usableSpaceInBytes();
        Integer estimateObjectSizeInBytes = null;
        Boolean possiblyNotEnoughSpace = null;
        if (usableSpaceInBytes != null && (estimateObjectSizeInBytes = TapeLocalQCriticalHandler.estimateObjectSizeInBytes(localQCacheOp)) != null) {
            possiblyNotEnoughSpace = (long)estimateObjectSizeInBytes.intValue() > usableSpaceInBytes;
        }
        if (possiblyNotEnoughSpace == null) {
            LOG.warn(LogPrefix.prefix() + "Unable to determine if enough space left for persisting localQCacheOp, usableSpaceInBytes: {}, estimateObjectSizeInBytes: {}", (Object)usableSpaceInBytes, (Object)estimateObjectSizeInBytes);
            return false;
        }
        if (possiblyNotEnoughSpace.booleanValue()) {
            LOG.error(LogPrefix.prefix() + "Not enough space left for persisting localQCacheOp, usableSpaceInBytes: {}, estimateObjectSizeInBytes: {}. Skipping replication of this cache event.", (Object)usableSpaceInBytes, (Object)estimateObjectSizeInBytes);
            return true;
        }
        return false;
    }

    private static Integer estimateObjectSizeInBytes(LocalQCacheOp localQCacheOp) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new TapeLocalQCacheOpConverter().toStream(localQCacheOp, (OutputStream)out);
            return out.size() * 2;
        }
        catch (IOException e) {
            LOG.error(LogPrefix.prefix() + "Unable to estimate localQCacheOp size: {}", (Object)localQCacheOp, (Object)e);
            return null;
        }
    }

    private static boolean handleFileCorrupted(LocalQCacheOpQueue queue, Throwable t) {
        if (queue.size() == 0) {
            return true;
        }
        String prefix = CORRUPTED_PREFIX + System.currentTimeMillis() + "_";
        try {
            queue.backupQueue(prefix);
        }
        catch (IOException e) {
            LOG.error(LogPrefix.prefix() + "Queue file possibly corrupted, but failed to create a backup for the cache replication queue file: {}, error: {}", new Object[]{queue.name(), e.getMessage(), e});
            return false;
        }
        try {
            TimeUnit.SECONDS.sleep(5L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    private boolean handlePeekWhileContainerIsUninitialized(Throwable t) {
        if (ExceptionUtils.indexOfType((Throwable)t, ContainerNotInitializedException.class) >= 0) {
            containerUninitializedErrorFirstOccurrence.compareAndSet(0L, System.currentTimeMillis());
            long times = containerUninitializedErrorLogTimes.getAndIncrement();
            containerUninitializedErrorLogger.warn("Could not peek from queue because PICO container is not initialized yet. Not removing message from queue. Already waiting for {}, did {} retries. Will retry in 5s...", DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - containerUninitializedErrorFirstOccurrence.get())), times, t);
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
        return false;
    }

    private static class NotTooOftenLogger {
        private final Logger log;
        private final long logPeriodMillis;
        private final Stopwatch lastPrintStats = Stopwatch.createUnstarted();

        public NotTooOftenLogger(Logger log, long logPeriodMillis) {
            this.log = log;
            this.logPeriodMillis = logPeriodMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void warn(String format, Object ... params) {
            if (this.canPrintContainerNotInitialized()) {
                NotTooOftenLogger notTooOftenLogger = this;
                synchronized (notTooOftenLogger) {
                    if (this.canPrintContainerNotInitialized()) {
                        this.log.warn(format, params);
                        this.lastPrintStats.reset().start();
                    }
                }
            }
        }

        private boolean canPrintContainerNotInitialized() {
            return LOG.isWarnEnabled() && (!this.lastPrintStats.isRunning() || this.lastPrintStats.elapsed(TimeUnit.MILLISECONDS) > this.logPeriodMillis);
        }
    }
}

