/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.events;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.events.EventSerializer;
import com.atlassian.jira.cluster.events.ReplicatedEvent;
import com.atlassian.jira.cluster.events.ReplicatedKey;
import com.atlassian.jira.cluster.events.SerializedEvent;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventReplicationManager {
    static final String CONTEXT = "REPLICATED-EVENT";
    private static final Logger log = LoggerFactory.getLogger(EventReplicationManager.class);
    private final EventSerializer eventSerializer;
    private final ClusterManager clusterManager;
    private final EventPublisher eventPublisher;
    private final Cache<ReplicatedKey, Object> cache;
    private final ThreadLocal<Boolean> sendEventOnReceiverContext = ThreadLocal.withInitial(() -> false);

    public EventReplicationManager(EventSerializer eventSerializer, ClusterManager clusterManager, CacheManager cacheManager, EventPublisher eventPublisher) {
        this.eventSerializer = eventSerializer;
        this.clusterManager = clusterManager;
        this.cache = cacheManager.getCache(EventReplicationManager.class.getName(), null, new CacheSettingsBuilder().remote().maxEntries(1).replicateViaInvalidation().build());
        this.cache.addListener((CacheEntryListener)new CacheListener(), true);
        this.eventPublisher = eventPublisher;
        this.eventPublisher.register((Object)this);
        log.info("[{}] Created.", (Object)CONTEXT);
    }

    @EventListener
    public void onReplicatedEvent(ReplicatedEvent replicatedEvent) {
        this.send(replicatedEvent);
    }

    private void send(Object event) {
        if (!this.sendEventOnReceiverContext.get().booleanValue()) {
            log.info("[{}] Event:{} will be replicated to cluster.", (Object)CONTEXT, (Object)EventReplicationManager.eventToString(event));
            Optional<SerializedEvent> serializedEvent = this.trySerialize(event);
            if (serializedEvent.isPresent()) {
                ReplicatedKey replicatedKey = ReplicatedKey.createFrom(serializedEvent.get(), this.clusterManager.getNodeId());
                this.cache.remove((Object)replicatedKey);
            }
        } else {
            log.info("[{}] Not re-replicating event: {}", (Object)CONTEXT, (Object)EventReplicationManager.eventToString(event));
        }
    }

    private Optional<SerializedEvent> trySerialize(Object event) {
        try {
            SerializedEvent serializedEvent = this.eventSerializer.serialize(event);
            return Optional.of(serializedEvent);
        }
        catch (Throwable throwable) {
            log.error("[{}] Error when serializing event: {}, error: {}. This event will not be replicated on other nodes.", new Object[]{CONTEXT, event, throwable.getMessage(), throwable});
            return Optional.empty();
        }
    }

    private static String eventToString(Object event) {
        return event.getClass().getSimpleName() + ":" + event;
    }

    private void receive(ReplicatedKey replicatedKey) {
        Preconditions.checkNotNull((Object)replicatedKey);
        if (!Objects.equals(this.clusterManager.getNodeId(), replicatedKey.sourceNode)) {
            log.info("[{}] On node: {} received event type: {} from node: {} ", new Object[]{CONTEXT, this.clusterManager.getNodeId(), replicatedKey.serializedEvent.getDataType(), replicatedKey.sourceNode});
            try {
                this.sendEventOnReceiverContext.set(true);
                Object deserializedEvent = this.eventSerializer.deserialize(replicatedKey.serializedEvent);
                this.eventPublisher.publish(deserializedEvent);
            }
            finally {
                this.sendEventOnReceiverContext.set(false);
            }
        }
    }

    private class CacheListener
    implements CacheEntryListener<ReplicatedKey, Object> {
        private CacheListener() {
        }

        public void onRemove(@Nonnull CacheEntryEvent<ReplicatedKey, Object> cacheEntryEvent) {
            log.info("[{}] cache.onRemove", (Object)EventReplicationManager.CONTEXT);
            EventReplicationManager.this.receive((ReplicatedKey)cacheEntryEvent.getKey());
        }

        public void onAdd(@Nonnull CacheEntryEvent<ReplicatedKey, Object> cacheEntryEvent) {
            log.info("[{}] cache.onAdd", (Object)EventReplicationManager.CONTEXT);
        }

        public void onEvict(@Nonnull CacheEntryEvent<ReplicatedKey, Object> cacheEntryEvent) {
            log.info("[{}] cache.onEvict", (Object)EventReplicationManager.CONTEXT);
        }

        public void onUpdate(@Nonnull CacheEntryEvent<ReplicatedKey, Object> cacheEntryEvent) {
            log.info("[{}] cache.onUpdate", (Object)EventReplicationManager.CONTEXT);
        }
    }
}

