/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatScheduledExecutorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatScheduledExecutorFactory.class);
    private static final String THREAD_NAMING_FORMAT = "heartbeat-scheduler-%s";
    private static final int CORE_POOL_SIZE = 1;
    private static final long DEFAULT_TIMEOUT_IN_SECONDS = 5L;
    private static ScheduledExecutorService scheduledExecutorService;

    public synchronized void init() {
        LOGGER.info("Heartbeat scheduler initialization");
        scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat(THREAD_NAMING_FORMAT).build());
    }

    ScheduledExecutorService getScheduledExecutorService() {
        return scheduledExecutorService;
    }

    public synchronized void stop() {
        if (scheduledExecutorService != null) {
            LOGGER.info("Heartbeat scheduler shutdown");
            scheduledExecutorService.shutdownNow();
            try {
                scheduledExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("Heartbeat scheduler shutdown failed", (Throwable)e);
            }
        }
    }
}

