/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.cluster.heartbeat.ClusterNodeHeartBeatDao;
import com.atlassian.jira.cluster.lock.JiraClusterLockQueryDSLDao;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.database.DatabaseSystemTimeReaderFactory;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QClusterLockStatus;
import com.atlassian.jira.model.querydsl.QClusterNodeHeartbeat;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLUpdateClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZDUAwareJiraClusterLockQueryDSLDao
extends JiraClusterLockQueryDSLDao {
    private final ClusterNodeHeartBeatDao clusterNodeHeartBeatDao;
    private static final Logger log = LoggerFactory.getLogger(ZDUAwareJiraClusterLockQueryDSLDao.class);

    public ZDUAwareJiraClusterLockQueryDSLDao(QueryDslAccessor queryDslAccessor, ClusterNodeHeartBeatDao clusterNodeHeartBeatDao, DatabaseSystemTimeReaderFactory databaseSystemTimeReaderFactory) {
        super(queryDslAccessor, clusterNodeHeartBeatDao, databaseSystemTimeReaderFactory);
        this.clusterNodeHeartBeatDao = clusterNodeHeartBeatDao;
    }

    @Override
    protected SQLQuery getHeldClusterLocksQuery(DbConnection dbConnection, Long dbTime) {
        return ((FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).isEnabled(JiraFeatureFlagRegistrar.USE_DC_LOCK_LEASING) ? this.getLeasingHeldClusterLocksQuery(dbConnection, dbTime) : this.getHeatbeatHeldClusterLocksQuery(dbConnection, dbTime);
    }

    private SQLQuery getLeasingHeldClusterLocksQuery(DbConnection dbConnection, Long dbTime) {
        return (SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QClusterLockStatus.CLUSTER_LOCK_STATUS).from((Expression)QClusterLockStatus.CLUSTER_LOCK_STATUS)).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.isNotNull())).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.updateTime.gt((Number)(dbTime - LEASE_EXPIRY_TIME_MS)));
    }

    private SQLQuery getHeatbeatHeldClusterLocksQuery(DbConnection dbConnection, Long dbTime) {
        return (SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QClusterLockStatus.CLUSTER_LOCK_STATUS).from((Expression)QClusterLockStatus.CLUSTER_LOCK_STATUS)).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.isNotNull())).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.in((SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression)QClusterNodeHeartbeat.CLUSTER_NODE_HEARTBEAT.nodeId).from((Expression)QClusterNodeHeartbeat.CLUSTER_NODE_HEARTBEAT)).where((Predicate)QClusterNodeHeartbeat.CLUSTER_NODE_HEARTBEAT.databaseTime.gt((Number)(dbTime - LEASE_EXPIRY_TIME_MS)))));
    }

    @Override
    protected SQLUpdateClause getAcquireLockQuery(DbConnection dbConnection, String lockName, Long dbTime) {
        return ((FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).isEnabled(JiraFeatureFlagRegistrar.USE_DC_LOCK_LEASING) ? this.getLeasingLockQuery(dbConnection, lockName, dbTime) : this.getHeatbeatLockQuery(dbConnection, lockName, dbTime);
    }

    private SQLUpdateClause getLeasingLockQuery(DbConnection dbConnection, String lockName, Long dbTime) {
        log.trace(JiraFeatureFlagRegistrar.USE_DC_LOCK_LEASING + ", using lock leases.");
        String nodeId = this.clusterNodeHeartBeatDao.getNodeId();
        return dbConnection.update((RelationalPath<?>)QClusterLockStatus.CLUSTER_LOCK_STATUS).set((Path)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode, (Object)nodeId).set(QClusterLockStatus.CLUSTER_LOCK_STATUS.updateTime, (Object)dbTime).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockName.eq((Object)lockName).andAnyOf(new Predicate[]{QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.isNull(), QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.eq((Object)nodeId), QClusterLockStatus.CLUSTER_LOCK_STATUS.updateTime.lt((Number)(dbTime - LEASE_EXPIRY_TIME_MS))}));
    }

    private SQLUpdateClause getHeatbeatLockQuery(DbConnection dbConnection, String lockName, Long dbTime) {
        log.trace(JiraFeatureFlagRegistrar.USE_DC_LOCK_LEASING + ", using heartbeat for lock eviction.");
        String nodeId = this.clusterNodeHeartBeatDao.getNodeId();
        return dbConnection.update((RelationalPath<?>)QClusterLockStatus.CLUSTER_LOCK_STATUS).set((Path)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode, (Object)nodeId).set(QClusterLockStatus.CLUSTER_LOCK_STATUS.updateTime, (Object)dbTime).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockName.eq((Object)lockName).andAnyOf(new Predicate[]{QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.isNull(), QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.eq((Object)nodeId), QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.in((SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression)QClusterNodeHeartbeat.CLUSTER_NODE_HEARTBEAT.nodeId).from((Expression)QClusterNodeHeartbeat.CLUSTER_NODE_HEARTBEAT)).where((Predicate)QClusterNodeHeartbeat.CLUSTER_NODE_HEARTBEAT.databaseTime.lt((Number)(dbTime - LEASE_EXPIRY_TIME_MS)))), QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.notIn((SubQueryExpression)SQLExpressions.select((Expression)QClusterNodeHeartbeat.CLUSTER_NODE_HEARTBEAT.nodeId).from((Expression)QClusterNodeHeartbeat.CLUSTER_NODE_HEARTBEAT))}));
    }
}

