/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.service.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import java.util.Objects;

@EventName(value="cluster.state.events")
public class ClusterStateChangedEvent {
    private final String actionName;
    private final int numberOfAffectedNodes;

    public ClusterStateChangedEvent(String actionName, int numberOfAffectedNodes) {
        this.actionName = actionName;
        this.numberOfAffectedNodes = numberOfAffectedNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateChangedEvent that = (ClusterStateChangedEvent)o;
        return this.numberOfAffectedNodes == that.numberOfAffectedNodes && Objects.equals(this.actionName, that.actionName);
    }

    public String toString() {
        return "ClusterStateChangedEvent{actionName='" + this.actionName + '\'' + ", numberOfAffectedNodes=" + this.numberOfAffectedNodes + '}';
    }

    public int hashCode() {
        return Objects.hash(this.actionName, this.numberOfAffectedNodes);
    }

    public String getActionName() {
        return this.actionName;
    }

    public int getNumberOfAffectedNodes() {
        return this.numberOfAffectedNodes;
    }

    public static enum ActionNames {
        NODES_REMOVED("NodesRemoved"),
        NODES_MOVED_TO_OFFLINE("NodesMovedToOffline");

        private final String actionName;

        private ActionNames(String actionName) {
            this.actionName = actionName;
        }

        public String getActionName() {
            return this.actionName;
        }
    }
}

