/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.zdu;

import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateDao;
import com.atlassian.jira.cluster.zdu.NodeBuildInfo;
import com.atlassian.jira.cluster.zdu.UpgradeState;
import com.atlassian.jira.database.DatabaseSystemTimeReader;
import com.atlassian.jira.database.DatabaseSystemTimeReaderFactory;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.ClusterUpgradeStateDTO;
import com.atlassian.jira.model.querydsl.QClusterUpgradeState;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class DefaultClusterUpgradeStateDao
implements ClusterUpgradeStateDao {
    private final DatabaseSystemTimeReader databaseSystemTimeReader;
    private final QueryDslAccessor queryDslAccessor;

    public DefaultClusterUpgradeStateDao(DatabaseSystemTimeReaderFactory databaseSystemTimeReaderFactory, QueryDslAccessor queryDslAccessor) {
        this.databaseSystemTimeReader = databaseSystemTimeReaderFactory.getReader();
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    @Nullable
    @GuardedBy(value="ClusterLock in DefaultClusterUpgradeStateManager#lock")
    public Optional<ClusterUpgradeStateDTO> getCurrent() {
        return Optional.ofNullable(this.queryDslAccessor.executeQuery(dbConnection -> (ClusterUpgradeStateDTO)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QClusterUpgradeState.CLUSTER_UPGRADE_STATE).from((Expression)QClusterUpgradeState.CLUSTER_UPGRADE_STATE)).where((Predicate)QClusterUpgradeState.CLUSTER_UPGRADE_STATE.clusterVersion.isNotNull().and((Predicate)QClusterUpgradeState.CLUSTER_UPGRADE_STATE.clusterBuildNumber.isNotNull()))).orderBy(new OrderSpecifier[]{QClusterUpgradeState.CLUSTER_UPGRADE_STATE.orderNumber.coalesce((Comparable[])new Long[]{0L}).desc(), QClusterUpgradeState.CLUSTER_UPGRADE_STATE.databaseTime.desc()})).limit(1L)).fetchFirst()));
    }

    @Override
    @GuardedBy(value="ClusterLock in DefaultClusterUpgradeStateManager#lock")
    public void writeState(NodeBuildInfo nodeBuildInfo, UpgradeState state) {
        QClusterUpgradeState clusterUpgradeStateAlias = new QClusterUpgradeState("c");
        this.queryDslAccessor.execute(connection -> connection.insert(QClusterUpgradeState.CLUSTER_UPGRADE_STATE).withId().set((Path)QClusterUpgradeState.CLUSTER_UPGRADE_STATE.databaseTime, (Object)this.getDatabaseTime()).set((Path)QClusterUpgradeState.CLUSTER_UPGRADE_STATE.clusterVersion, nodeBuildInfo.getVersion()).set((Path)QClusterUpgradeState.CLUSTER_UPGRADE_STATE.clusterBuildNumber, (Object)nodeBuildInfo.getBuildNumber()).set((Path)QClusterUpgradeState.CLUSTER_UPGRADE_STATE.state, state.name()).set((Path)QClusterUpgradeState.CLUSTER_UPGRADE_STATE.orderNumber, (Expression)SQLExpressions.select((Expression)clusterUpgradeStateAlias.orderNumber.max().add((Number)1).coalesce((Comparable[])new Long[]{1L})).from((Expression)clusterUpgradeStateAlias)).execute());
    }

    private long getDatabaseTime() {
        try {
            return this.databaseSystemTimeReader.getDatabaseSystemTimeMillis();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

