/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.zdu;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterInfo;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateDao;
import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateManager;
import com.atlassian.jira.cluster.zdu.DatabaseUpgradeStateManager;
import com.atlassian.jira.cluster.zdu.JiraDelayedUpgradeFailedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeApprovedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeCancelledEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFailedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFinishedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeStartedEvent;
import com.atlassian.jira.cluster.zdu.NodeBuildInfo;
import com.atlassian.jira.cluster.zdu.NodeBuildInfoFactory;
import com.atlassian.jira.cluster.zdu.UpgradeState;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.JiraDelayedUpgradeCompletedEvent;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.model.querydsl.ClusterUpgradeStateDTO;
import com.atlassian.jira.upgrade.UpgradeException;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.jira.upgrade.UpgradeScheduler;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultClusterUpgradeStateManager
implements ClusterUpgradeStateManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterUpgradeStateManager.class);
    private static final String CLUSTER_UPGRADE_STATE_LOCK_NAME = DefaultClusterUpgradeStateManager.class.getName() + ".clusterUpgradeState";
    private static final Runnable DO_NOTHING = () -> {};
    private static final EnumSet<UpgradeState> AUTO_TRANSITION_STATES = EnumSet.of(UpgradeState.MIXED, UpgradeState.READY_TO_UPGRADE, UpgradeState.READY_TO_RUN_UPGRADE_TASKS);
    private static final int RESCHEDULE_UPGRADE_TASKS_DELAY = Math.toIntExact(Duration.ofMinutes(2L).toMinutes());
    private final ClusterManager clusterManager;
    private final ClusterLock lock;
    private final ClusterUpgradeStateDao clusterUpgradeStateDao;
    private final ClusterInfo clusterInfo;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final MessageHandlerService messageHandlerService;
    private final NodeBuildInfoFactory nodeBuildInfoFactory;
    private final UpgradeScheduler upgradeScheduler;
    private final DatabaseUpgradeStateManager databaseUpgradeStateManager;

    public DefaultClusterUpgradeStateManager(ClusterManager clusterManager, ClusterLockService clusterLockService, ClusterUpgradeStateDao clusterUpgradeStateDao, ClusterInfo clusterInfo, EventPublisher eventPublisher, FeatureManager featureManager, MessageHandlerService messageHandlerService, NodeBuildInfoFactory nodeBuildInfoFactory, UpgradeScheduler upgradeScheduler, DatabaseUpgradeStateManager databaseUpgradeStateManager) {
        this.clusterManager = clusterManager;
        this.lock = clusterLockService.getLockForName(CLUSTER_UPGRADE_STATE_LOCK_NAME);
        this.clusterUpgradeStateDao = clusterUpgradeStateDao;
        this.clusterInfo = clusterInfo;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.messageHandlerService = messageHandlerService;
        this.nodeBuildInfoFactory = nodeBuildInfoFactory;
        this.upgradeScheduler = upgradeScheduler;
        this.databaseUpgradeStateManager = databaseUpgradeStateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUpgrade() {
        Runnable actionsAfterLockDropped;
        this.lock.lock();
        try {
            UpgradeState upgradeState = this.databaseUpgradeStateManager.getDatabaseUpgradeState();
            if (upgradeState != UpgradeState.STABLE) {
                throw new IllegalStateException("Can only transition to " + UpgradeState.READY_TO_UPGRADE + " from " + UpgradeState.STABLE + " but was in " + upgradeState);
            }
            Set<NodeBuildInfo> uniqueBuildNumbersInCluster = this.getUniqueBuildNumbersInCluster();
            if (uniqueBuildNumbersInCluster.size() > 1) {
                throw new IllegalStateException("Inconsistent build versions in cluster. All nodes should have the same version but got: " + uniqueBuildNumbersInCluster);
            }
            NodeBuildInfo nodeBuildInfo = this.getNodeBuildInfo();
            this.setUpgradeState(nodeBuildInfo, UpgradeState.READY_TO_UPGRADE);
            actionsAfterLockDropped = () -> {
                this.eventPublisher.publish((Object)new JiraUpgradeStartedEvent(nodeBuildInfo));
                this.notifyCluster(UpgradeState.READY_TO_UPGRADE);
            };
        }
        finally {
            this.lock.unlock();
        }
        actionsAfterLockDropped.run();
    }

    private Set<NodeBuildInfo> getUniqueBuildNumbersInCluster() {
        return this.clusterManager.findLiveNodes().stream().map(this.nodeBuildInfoFactory::create).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelUpgrade() {
        Runnable actionsAfterLockDropped;
        this.recalculateState();
        this.lock.lock();
        try {
            UpgradeState upgradeState = this.databaseUpgradeStateManager.getDatabaseUpgradeState();
            NodeBuildInfo clusterBuildInfo = this.getClusterBuildInfo();
            switch (upgradeState) {
                case READY_TO_UPGRADE: {
                    this.setUpgradeState(clusterBuildInfo, UpgradeState.STABLE);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cluster can not be rolled back to stable state until upgrade is completed. Current state is [%s]", upgradeState));
                }
            }
            actionsAfterLockDropped = () -> {
                this.eventPublisher.publish((Object)new JiraUpgradeCancelledEvent(clusterBuildInfo));
                this.notifyCluster(UpgradeState.STABLE);
                this.rescheduleUpgradeTasksInBackground();
            };
        }
        finally {
            this.lock.unlock();
        }
        actionsAfterLockDropped.run();
    }

    @Override
    public void approveUpgrade() {
        Runnable actionsAfterLockDropped;
        this.recalculateState();
        this.lock.lock();
        try {
            UpgradeState upgradeState = this.databaseUpgradeStateManager.getDatabaseUpgradeState();
            if (upgradeState != UpgradeState.READY_TO_RUN_UPGRADE_TASKS) {
                throw new IllegalStateException(String.format("Cluster not ready to run upgrade tasks yet, because it in [%s] state", upgradeState));
            }
            actionsAfterLockDropped = this.runUpgrade();
        }
        finally {
            this.lock.unlock();
        }
        actionsAfterLockDropped.run();
    }

    @Override
    public void retryUpgrade() {
        Runnable actionsAfterLockDropped;
        this.lock.lock();
        try {
            UpgradeState upgradeState = this.databaseUpgradeStateManager.getDatabaseUpgradeState();
            if (upgradeState != UpgradeState.UPGRADE_TASKS_FAILED) {
                throw new IllegalStateException(String.format("Can not retry upgrade when there are no errors, it was in [%s] state", upgradeState));
            }
            actionsAfterLockDropped = this.runUpgrade();
        }
        finally {
            this.lock.unlock();
        }
        actionsAfterLockDropped.run();
    }

    @GuardedBy(value="lock")
    private Runnable runUpgrade() {
        this.setUpgradeState(this.getClusterBuildInfo(), UpgradeState.RUNNING_UPGRADE_TASKS);
        return () -> {
            UpgradeResult upgradeResult = this.upgradeScheduler.scheduleUpgrades(0);
            if (!upgradeResult.successful()) {
                this.handleUpgradesFailed(upgradeResult);
                throw new UpgradeException(upgradeResult);
            }
            this.eventPublisher.publish((Object)new JiraUpgradeApprovedEvent(this.getClusterBuildInfo(), this.getNodeBuildInfo()));
            this.notifyCluster(UpgradeState.RUNNING_UPGRADE_TASKS);
        };
    }

    private void rescheduleUpgradeTasksInBackground() {
        UpgradeResult upgradeResult = this.upgradeScheduler.scheduleUpgrades(RESCHEDULE_UPGRADE_TASKS_DELAY);
        if (!upgradeResult.successful()) {
            log.warn("Upgrade tasks could not be rescheduled, some upgrade tasks may have been skipped!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpgradesCompleted() {
        Runnable actionsAfterLockDropped;
        block4: {
            this.lock.lock();
            try {
                UpgradeState currentUpgradeState = this.databaseUpgradeStateManager.getDatabaseUpgradeState();
                NodeBuildInfo nodeBuildInfo = this.getNodeBuildInfo();
                NodeBuildInfo clusterBuildInfo = this.getClusterBuildInfo();
                if (currentUpgradeState == UpgradeState.RUNNING_UPGRADE_TASKS) {
                    this.setUpgradeState(nodeBuildInfo, UpgradeState.STABLE);
                    actionsAfterLockDropped = () -> {
                        this.eventPublisher.publish((Object)new JiraUpgradeFinishedEvent(clusterBuildInfo, nodeBuildInfo));
                        this.notifyCluster(UpgradeState.STABLE);
                    };
                    break block4;
                }
                throw new IllegalStateException("Can not handle upgrade completion when state is not RUNNING_UPGRADE_TASKS");
            }
            finally {
                this.lock.unlock();
            }
        }
        actionsAfterLockDropped.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpgradesFailed(UpgradeResult result) {
        Runnable actionsAfterLockDropped;
        block4: {
            this.lock.lock();
            try {
                UpgradeState currentUpgradeState = this.databaseUpgradeStateManager.getDatabaseUpgradeState();
                NodeBuildInfo nodeBuildInfo = this.getNodeBuildInfo();
                NodeBuildInfo clusterBuildInfo = this.getClusterBuildInfo();
                if (currentUpgradeState == UpgradeState.RUNNING_UPGRADE_TASKS) {
                    this.setUpgradeState(clusterBuildInfo, UpgradeState.UPGRADE_TASKS_FAILED);
                    actionsAfterLockDropped = () -> {
                        this.eventPublisher.publish((Object)new JiraUpgradeFailedEvent(clusterBuildInfo, nodeBuildInfo, result.getErrors()));
                        this.notifyCluster(UpgradeState.UPGRADE_TASKS_FAILED);
                    };
                    break block4;
                }
                throw new IllegalStateException("Can not handle upgrade failures when state is not RUNNING_UPGRADE_TASKS");
            }
            finally {
                this.lock.unlock();
            }
        }
        actionsAfterLockDropped.run();
    }

    @EventListener
    public void updateState(JiraStartedEvent event) {
        this.recalculateState();
    }

    @EventListener
    public void onUpgradesFailed(JiraDelayedUpgradeFailedEvent event) {
        if (this.getUpgradeState() != UpgradeState.RUNNING_UPGRADE_TASKS) {
            return;
        }
        this.handleUpgradesFailed(new UpgradeResult(event.getErrors()));
    }

    @EventListener
    public void onUpgradesCompleted(JiraDelayedUpgradeCompletedEvent ignored) {
        if (this.getUpgradeState() != UpgradeState.RUNNING_UPGRADE_TASKS) {
            return;
        }
        this.handleUpgradesCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateState() {
        Runnable actionsAfterLockDropped;
        this.lock.lock();
        try {
            UpgradeState currentUpgradeState = this.databaseUpgradeStateManager.getDatabaseUpgradeState();
            if (AUTO_TRANSITION_STATES.contains(currentUpgradeState)) {
                Object targetUpgradeState;
                this.clusterManager.refreshLiveNodes();
                Set<NodeBuildInfo> uniqueBuildNumbers = this.getUniqueBuildNumbersInCluster();
                if (uniqueBuildNumbers.isEmpty()) {
                    if (this.clusterInfo.isClustered()) {
                        log.warn("No cluster node entries, cannot determine upgrade state transition.");
                        targetUpgradeState = null;
                    } else {
                        targetUpgradeState = Objects.equals(this.getNodeBuildInfo(), this.getClusterBuildInfo()) ? null : UpgradeState.READY_TO_RUN_UPGRADE_TASKS;
                    }
                } else if (uniqueBuildNumbers.size() > 1) {
                    targetUpgradeState = UpgradeState.MIXED;
                } else {
                    NodeBuildInfo nodesBuildNumber = uniqueBuildNumbers.iterator().next();
                    NodeBuildInfo clusterBuildNumber = this.getClusterBuildInfo();
                    targetUpgradeState = clusterBuildNumber.equals(nodesBuildNumber) ? UpgradeState.READY_TO_UPGRADE : UpgradeState.READY_TO_RUN_UPGRADE_TASKS;
                }
                if (targetUpgradeState != null && targetUpgradeState != currentUpgradeState) {
                    log.info("Transitioning cluster upgrade state from " + currentUpgradeState + " to " + targetUpgradeState);
                    this.setUpgradeState(this.getClusterBuildInfo(), (UpgradeState)targetUpgradeState);
                    actionsAfterLockDropped = () -> this.lambda$recalculateState$6((UpgradeState)targetUpgradeState);
                } else {
                    actionsAfterLockDropped = DO_NOTHING;
                }
            } else {
                actionsAfterLockDropped = DO_NOTHING;
            }
        }
        finally {
            this.lock.unlock();
        }
        actionsAfterLockDropped.run();
    }

    @Nonnull
    public UpgradeState getUpgradeState() {
        if (!this.featureManager.isEnabled("jira.zdu.cluster-upgrade-state")) {
            return UpgradeState.STABLE;
        }
        this.recalculateState();
        return this.databaseUpgradeStateManager.getDatabaseUpgradeState();
    }

    @Override
    public NodeBuildInfo getClusterBuildInfo() {
        if (!this.featureManager.isEnabled("jira.zdu.cluster-upgrade-state")) {
            return this.getNodeBuildInfo();
        }
        Optional<ClusterUpgradeStateDTO> currentState = this.clusterUpgradeStateDao.getCurrent();
        return currentState.map(this.nodeBuildInfoFactory::create).orElse(this.getNodeBuildInfo());
    }

    private NodeBuildInfo getNodeBuildInfo() {
        return this.nodeBuildInfoFactory.currentApplicationInfo();
    }

    private void setUpgradeState(NodeBuildInfo nodeBuildInfo, @Nonnull UpgradeState upgradeState) {
        this.clusterUpgradeStateDao.writeState(nodeBuildInfo, upgradeState);
    }

    private void notifyCluster(UpgradeState upgradeState) {
        this.messageHandlerService.sendRemote("Upgrade State", upgradeState.toString());
    }

    private /* synthetic */ void lambda$recalculateState$6(UpgradeState targetUpgradeState) {
        this.notifyCluster(targetUpgradeState);
    }
}

