/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.pico.registrar;

import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.ehcache.EhCacheManager;
import com.atlassian.cache.ehcache.replication.EhCacheReplicatorConfigFactory;
import com.atlassian.cache.ehcache.wrapper.ValueProcessor;
import com.atlassian.cache.impl.jmx.MBeanRegistrar;
import com.atlassian.cache.memory.JMXMemoryCacheManager;
import com.atlassian.jira.NoopCacheEventListenerFactory;
import com.atlassian.jira.cache.CacheCompactor;
import com.atlassian.jira.cache.EhCacheCompactor;
import com.atlassian.jira.cache.JiraVCacheRequestContextSupplier;
import com.atlassian.jira.cache.JiraVCacheServiceCreator;
import com.atlassian.jira.cache.NullCacheCompactor;
import com.atlassian.jira.cache.ehcache.customserialization.CustomSerializedValueProcessor;
import com.atlassian.jira.cache.serialcheck.DefaultSerializationChecker;
import com.atlassian.jira.cache.serialcheck.SerializationCheckedCacheManager;
import com.atlassian.jira.cache.serialcheck.SerializationChecker;
import com.atlassian.jira.cache.serialcheck.SerializationRecordingCacheManager;
import com.atlassian.jira.cache.slomo.SloMoCacheManager;
import com.atlassian.jira.cache.stats.CacheStats;
import com.atlassian.jira.cache.stats.CacheStatsCacheManager;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.cluster.EhCacheConfigurationFactory;
import com.atlassian.jira.cluster.ReplicatorExecutorServiceFactory;
import com.atlassian.jira.cluster.cache.ehcache.ReplicatorConfigFactory;
import com.atlassian.jira.component.pico.ComponentContainer;
import com.atlassian.jira.component.pico.osgi.OsgiServiceScope;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.internal.VCacheLifecycleManager;
import com.atlassian.vcache.internal.VCacheManagement;
import com.atlassian.vcache.internal.core.service.AbstractVCacheService;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Pair;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManagerRegistrar {
    private static final Logger log = LoggerFactory.getLogger(CacheManagerRegistrar.class);
    public static final String EHCACHE_CONFIGURATION = "atlassian.ehcache.config";
    public static final String ENABLE_JMX = "atlassian.cache.jmx";
    public static final String FORCE_EHCACHE = "atlassian.cache.ehcache";
    public static final String ENABLE_STATISTICS = "atlassian.cache.statistics.enabled";
    public static final String ENABLE_EHCACHE_STATISTICS = "atlassian.cache.statistics.enabled.ehcache";
    public static final String ENABLE_SLOMO = "atlassian.cache.slomo.millis";
    public static final String ENABLE_SERIALIZATION_CHECK = "atlassian.cache.serialization.check";
    public static final String SERIALIZATION_RECORDING_FILE = "atlassian.cache.serialization.recording";
    @Deprecated
    public static final String DISABLE_DEFERRED_CACHE_REPLICATION = "atlassian.disable.deferred.cache.replication";
    @VisibleForTesting
    static final OsgiServiceScope MANAGER_SCOPE = OsgiServiceScope.PROVIDED;
    static final OsgiServiceScope COMPACTOR_SCOPE = OsgiServiceScope.INTERNAL;
    @VisibleForTesting
    static final Class<com.atlassian.cache.CacheManager> MANAGER_KEY = com.atlassian.cache.CacheManager.class;
    static final Class<CacheCompactor> COMPACTOR_KEY = CacheCompactor.class;
    static final Class<CacheFactory> FACTORY_KEY = CacheFactory.class;
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheManagerRegistrar.class);

    public static void registerCacheManager(ComponentContainer container, MBeanServer mBeanServer) {
        CacheCompactor cacheCompactor;
        JMXMemoryCacheManager cacheManager;
        JiraProperties jiraProperties = JiraSystemProperties.getInstance();
        ClusterNodeProperties clusterNodeProperties = container.getComponentInstance(ClusterNodeProperties.class);
        boolean useEhcache = CacheManagerRegistrar.useEhcache(jiraProperties, clusterNodeProperties);
        LOGGER.debug("Using Ehcache = {}", (Object)useEhcache);
        JiraSettingsDefaultsProvider defaultSettingsProvider = new JiraSettingsDefaultsProvider(jiraProperties, clusterNodeProperties);
        if (useEhcache) {
            ReplicatorExecutorServiceFactory.init();
            CacheManager delegate = CacheManagerRegistrar.getCacheManagerDelegate(container, jiraProperties, clusterNodeProperties);
            ReplicatorConfigFactory replicatorConfigFactory = new ReplicatorConfigFactory();
            cacheManager = CacheManagerRegistrar.getEhCacheManager(delegate, replicatorConfigFactory, defaultSettingsProvider);
            cacheCompactor = new EhCacheCompactor(delegate);
        } else {
            cacheManager = new JMXMemoryCacheManager((CacheSettingsDefaultsProvider)defaultSettingsProvider);
            cacheCompactor = new NullCacheCompactor();
        }
        CacheManagerRegistrar.registerVCache(container, jiraProperties, (com.atlassian.cache.CacheManager)cacheManager, useEhcache);
        CacheManagerRegistrar.enableJmxIfNecessary(jiraProperties, (com.atlassian.cache.CacheManager)cacheManager, mBeanServer);
        container.instance(OsgiServiceScope.INTERNAL, CacheStats.class, JiraStats.create(CacheStats.class, CacheStats.MutableCacheStats::new, (boolean)true));
        container.implementation(OsgiServiceScope.PROVIDED, SerializationChecker.class, DefaultSerializationChecker.class);
        com.atlassian.cache.CacheManager result = CacheManagerRegistrar.wrapForSerializationCheck(CacheManagerRegistrar.wrapForSloMo((com.atlassian.cache.CacheManager)cacheManager), container);
        result = CacheManagerRegistrar.wrapForStatsLogs(result, container);
        container.instance(MANAGER_SCOPE, MANAGER_KEY, result);
        container.instance(MANAGER_SCOPE, FACTORY_KEY, result);
        container.instance(COMPACTOR_SCOPE, COMPACTOR_KEY, cacheCompactor);
    }

    private static void registerVCache(ComponentContainer container, JiraProperties jiraProperties, com.atlassian.cache.CacheManager cacheManager, boolean avoidCas) {
        JiraVCacheServiceCreator vCacheFactoryCreator = new JiraVCacheServiceCreator(jiraProperties, Optional.ofNullable(cacheManager), avoidCas);
        Pair<JiraVCacheRequestContextSupplier, AbstractVCacheService> pair = vCacheFactoryCreator.createVCacheService();
        container.instance(OsgiServiceScope.INTERNAL, JiraVCacheRequestContextSupplier.class, pair.left());
        AbstractVCacheService vCacheService = (AbstractVCacheService)pair.right();
        container.instance(OsgiServiceScope.INTERNAL, VCacheManagement.class, vCacheService);
        container.instance(OsgiServiceScope.INTERNAL, VCacheLifecycleManager.class, vCacheService);
        container.instance(OsgiServiceScope.PROVIDED, VCacheFactory.class, vCacheService);
    }

    public static void shutDownCacheManager(ComponentContainer container, MBeanServer mBeanServer) {
        ReplicatorExecutorServiceFactory.shutdown();
        JiraProperties jiraProperties = JiraSystemProperties.getInstance();
        com.atlassian.cache.CacheManager cacheManager = container.getComponentInstance(MANAGER_KEY);
        if (cacheManager instanceof CacheStatsCacheManager) {
            cacheManager = ((CacheStatsCacheManager)container.getComponentInstance(MANAGER_KEY)).getDelegate();
        }
        if (jiraProperties.getBoolean(ENABLE_JMX).booleanValue() && cacheManager instanceof MBeanRegistrar) {
            ((MBeanRegistrar)cacheManager).unregisterMBeans(mBeanServer);
        }
        if (cacheManager != null) {
            cacheManager.shutdown();
        }
    }

    private static com.atlassian.cache.CacheManager wrapForSloMo(com.atlassian.cache.CacheManager delegate) {
        int delay = JiraSystemProperties.getInstance().getInteger(ENABLE_SLOMO, Integer.valueOf(0));
        return delay > 0 ? new SloMoCacheManager(delegate, delay) : delegate;
    }

    private static com.atlassian.cache.CacheManager wrapForSerializationCheck(com.atlassian.cache.CacheManager cacheManager, ComponentContainer container) {
        String serializationRecordingFileName;
        JiraProperties jiraProperties = JiraSystemProperties.getInstance();
        if (jiraProperties.isDevMode() || Boolean.TRUE.equals(jiraProperties.getBoolean(ENABLE_SERIALIZATION_CHECK))) {
            SerializationChecker checker = container.getComponentInstance(SerializationChecker.class);
            cacheManager = new SerializationCheckedCacheManager(cacheManager, checker);
        }
        if ((serializationRecordingFileName = jiraProperties.getProperty(SERIALIZATION_RECORDING_FILE)) != null) {
            Path serializationRecordingFile = Paths.get(serializationRecordingFileName, new String[0]).toAbsolutePath();
            try {
                log.info("Recording cache serialization to " + serializationRecordingFile.toAbsolutePath());
                Files.createDirectories(serializationRecordingFile.getParent(), new FileAttribute[0]);
                cacheManager = new SerializationRecordingCacheManager(cacheManager, serializationRecordingFile);
            }
            catch (IOException e) {
                log.warn("Failed to create serialization recording file: " + serializationRecordingFile + ": " + e, (Throwable)e);
            }
        } else {
            log.debug("Serialization recording filename on property atlassian.cache.serialization.recording was not set.");
        }
        return cacheManager;
    }

    private static com.atlassian.cache.CacheManager wrapForStatsLogs(com.atlassian.cache.CacheManager cacheManager, ComponentContainer container) {
        CacheStats stats = container.getComponentInstance(CacheStats.class);
        return new CacheStatsCacheManager(cacheManager, stats);
    }

    private static CacheManager getCacheManagerDelegate(ComponentContainer container, JiraProperties jiraProperties, ClusterNodeProperties clusterNodeProperties) {
        URL configUrl = CacheManagerRegistrar.class.getResource("/ehcache.xml");
        String customEhcacheConfig = jiraProperties.getProperty(EHCACHE_CONFIGURATION);
        if (StringUtils.isNotBlank((CharSequence)customEhcacheConfig)) {
            File customEhcacheConfigFile = new File(customEhcacheConfig);
            if (customEhcacheConfigFile.isFile()) {
                try {
                    configUrl = customEhcacheConfigFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Could not create a URL from " + customEhcacheConfigFile);
                }
            } else {
                LOGGER.error(customEhcacheConfigFile + " is not a file; defaulting to JIRA's built-in Ehcache configuration");
            }
        }
        Configuration config = CacheManagerRegistrar.buildConfiguration(container, configUrl, clusterNodeProperties);
        return NoopCacheEventListenerFactory.workAroundCache95(CacheManager.newInstance((Configuration)config));
    }

    private static Configuration buildConfiguration(ComponentContainer container, URL configUrl, ClusterNodeProperties clusterNodeProperties) {
        EhCacheConfigurationFactory configurationFactory = container.getComponentInstance(EhCacheConfigurationFactory.class);
        return configurationFactory.newConfiguration(configUrl, clusterNodeProperties);
    }

    private static void enableJmxIfNecessary(JiraProperties jiraProperties, com.atlassian.cache.CacheManager cacheManager, MBeanServer mBeanServer) {
        if (CacheManagerRegistrar.isJMXEnabled(jiraProperties) && cacheManager instanceof MBeanRegistrar) {
            ((MBeanRegistrar)cacheManager).registerMBeans(mBeanServer);
        }
    }

    private static boolean useEhcache(JiraProperties jiraProperties, ClusterNodeProperties clusterNodeProperties) {
        boolean isEhCacheForced = jiraProperties.getBoolean(FORCE_EHCACHE);
        boolean isJiraClustered = CacheManagerRegistrar.isJiraClustered(clusterNodeProperties);
        return isEhCacheForced || isJiraClustered;
    }

    private static boolean isJiraClustered(ClusterNodeProperties clusterNodeProperties) {
        return clusterNodeProperties.getNodeId() != null;
    }

    private static boolean enableStatistics(JiraProperties jiraProperties, ClusterNodeProperties clusterNodeProperties) {
        if (CacheManagerRegistrar.isJiraClustered(clusterNodeProperties)) {
            return Boolean.parseBoolean(jiraProperties.getProperty(ENABLE_EHCACHE_STATISTICS, "true"));
        }
        return Boolean.parseBoolean(jiraProperties.getProperty(ENABLE_STATISTICS, "false"));
    }

    private static com.atlassian.cache.CacheManager getEhCacheManager(CacheManager delegate, ReplicatorConfigFactory replicatorConfigFactory, CacheSettingsDefaultsProvider defaultSettingsProvider) {
        String systemPropertyDisabelDeffered = JiraSystemProperties.getInstance().getProperty(DISABLE_DEFERRED_CACHE_REPLICATION);
        if (systemPropertyDisabelDeffered != null) {
            log.info("System property: {}={} is ignored. Deferred cache replication is always disabled.", (Object)DISABLE_DEFERRED_CACHE_REPLICATION, (Object)systemPropertyDisabelDeffered);
        }
        return new EhCacheManager(delegate, (EhCacheReplicatorConfigFactory)replicatorConfigFactory, defaultSettingsProvider, (ValueProcessor)new CustomSerializedValueProcessor());
    }

    private static boolean isJMXEnabled(JiraProperties jiraProperties) {
        return jiraProperties.getBoolean(ENABLE_JMX);
    }

    private static class JiraSettingsDefaultsProvider
    implements CacheSettingsDefaultsProvider {
        final boolean enableStatistics;

        private JiraSettingsDefaultsProvider(JiraProperties jiraProperties, ClusterNodeProperties clusterNodeProperties) {
            this.enableStatistics = CacheManagerRegistrar.enableStatistics(jiraProperties, clusterNodeProperties);
        }

        @Nonnull
        public CacheSettings getDefaults(@Nonnull String cacheName) {
            CacheSettingsBuilder cacheSettingsBuilder = new CacheSettingsBuilder();
            if (this.enableStatistics) {
                return cacheSettingsBuilder.statisticsEnabled().build();
            }
            return cacheSettingsBuilder.statisticsDisabled().build();
        }
    }
}

