/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.pico.web;

import com.atlassian.jira.component.pico.PicoContainerFactory;
import com.atlassian.jira.util.Optionals;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ServletActionContext;

@ParametersAreNonnullByDefault
public class RequestComponentManager {
    private static final Logger log = LoggerFactory.getLogger(RequestComponentManager.class);

    public MutablePicoContainer getContainer(PicoContainer parent) {
        MutablePicoContainer requestContainer = PicoContainerFactory.defaultJIRAContainer(parent);
        try {
            HttpServletRequest request = ServletActionContext.getRequest();
            if (request != null) {
                WorkflowManager workflowManager = (WorkflowManager)parent.getComponent(WorkflowManager.class);
                this.getRequestScopedComponents(request, workflowManager).forEach(arg_0 -> ((MutablePicoContainer)requestContainer).addComponent(arg_0));
            }
        }
        catch (PicoCompositionException e) {
            log.error(e.getMessage(), (Throwable)e);
            if (e.getCause() != null) {
                log.error("Cause: " + e.getCause(), e.getCause());
            }
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return requestContainer;
    }

    private Collection<Object> getRequestScopedComponents(HttpServletRequest request, WorkflowManager workflowManager) {
        String workflowName = request.getParameter("workflowName");
        if (StringUtils.isEmpty((CharSequence)workflowName)) {
            return Collections.emptySet();
        }
        String workflowMode = request.getParameter("workflowMode");
        if (workflowMode == null) {
            throw new IllegalStateException("Found a 'workflow' in the request parameters, but there is no 'workflowMode'. " + RequestComponentManager.getFullRequestUrl(request));
        }
        ArrayList<Object> requestScopedComponents = new ArrayList<Object>();
        JiraWorkflow workflow = this.getWorkflow(workflowManager, workflowMode, workflowName, request);
        requestScopedComponents.add(workflow);
        String workflowStep = request.getParameter("workflowStep");
        WorkflowDescriptor descriptor = workflow.getDescriptor();
        if (StringUtils.isBlank((CharSequence)workflowStep)) {
            requestScopedComponents.addAll(this.getActionComponents(descriptor, request));
        } else {
            requestScopedComponents.addAll(this.getWorkflowStepComponents(descriptor, workflowStep, request));
        }
        return requestScopedComponents;
    }

    private Collection<Object> getWorkflowStepComponents(WorkflowDescriptor descriptor, String workflowStep, HttpServletRequest request) {
        StepDescriptor step = descriptor.getStep(Integer.parseInt(workflowStep));
        if (step == null) {
            log.warn("No workflow step found for '{}'", (Object)workflowStep);
            return Collections.emptySet();
        }
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(step);
        Optional.ofNullable(request.getParameter("workflowTransition")).filter(StringUtils::isNotBlank).map(Integer::parseInt).map(arg_0 -> ((StepDescriptor)step).getAction(arg_0)).ifPresent(components::add);
        return components;
    }

    private Collection<Object> getActionComponents(WorkflowDescriptor descriptor, HttpServletRequest request) {
        String globalWorkflowTransition = request.getParameter("workflowTransition");
        if (StringUtils.isBlank((CharSequence)globalWorkflowTransition)) {
            return Collections.emptySet();
        }
        ArrayList<Object> components = new ArrayList<Object>();
        int actionId = Integer.parseInt(globalWorkflowTransition);
        Optional<ActionDescriptor> actionDescriptor = Optionals.fallBack(RequestComponentManager.findActionById(descriptor.getGlobalActions(), actionId), () -> RequestComponentManager.findActionById(descriptor.getInitialActions(), actionId));
        Optionals.foldToEffect(actionDescriptor, components::add, () -> log.error("Could not find any actions matching this workflow transition: {}", (Object)globalWorkflowTransition));
        return components;
    }

    private static Optional<ActionDescriptor> findActionById(List<?> actions, int actionId) {
        return actions.stream().filter(ActionDescriptor.class::isInstance).map(ActionDescriptor.class::cast).filter(actionDescriptor -> actionDescriptor.getId() == actionId).findFirst();
    }

    private JiraWorkflow getWorkflow(WorkflowManager workflowManager, String workflowMode, String workflowName, HttpServletRequest request) {
        JiraWorkflow workflow;
        switch (workflowMode) {
            case "live": {
                workflow = workflowManager.getWorkflowClone(workflowName);
                break;
            }
            case "draft": {
                workflow = workflowManager.getDraftWorkflow(workflowName);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid workflow mode '" + workflowMode + "'. " + RequestComponentManager.getFullRequestUrl(request));
            }
        }
        if (workflow == null) {
            throw new IllegalStateException("No " + workflowMode + " workflow was found for '" + workflowName + "'.");
        }
        return workflow;
    }

    private static String getFullRequestUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder(request.getRequestURL().toString());
        if (!StringUtils.isEmpty((CharSequence)request.getQueryString())) {
            url.append("?").append(request.getQueryString());
        }
        return url.toString();
    }
}

