/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueConstantImpl;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.util.IssueIdsIssueIterable;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.task.context.Contexts;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractIssueConstantsManager<T extends IssueConstant> {
    protected final ConstantsManager constantsManager;
    protected final OfBizDelegator ofBizDelegator;
    protected final IssueIndexingService issueIndexingService;
    protected final IssueManager issueManager;
    protected final QueryDslAccessor queryDslAccessor;

    protected AbstractIssueConstantsManager(ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, IssueIndexingService issueIndexingService, IssueManager issueManager, QueryDslAccessor queryDslAccessor) {
        this.constantsManager = constantsManager;
        this.ofBizDelegator = ofBizDelegator;
        this.issueIndexingService = issueIndexingService;
        this.issueManager = issueManager;
        this.queryDslAccessor = queryDslAccessor;
    }

    protected GenericValue createConstant(Map<String, Object> fields) {
        return this.ofBizDelegator.createValue(this.getIssueConstantField(), fields);
    }

    protected long getMaxSequenceNo() {
        return this.getAllValues().stream().map(IssueConstant::getSequence).max(Long::compare).orElse(0L);
    }

    protected String getNextStringId() {
        return this.ofBizDelegator.getDelegatorInterface().getNextSeqId(this.getIssueConstantField()).toString();
    }

    protected void removeConstant(StringPath field, T oldConstant, String newId) throws GenericEntityException, IndexException {
        List matchingIssues;
        long batchSize = 1000L;
        while (!(matchingIssues = this.queryDslAccessor.executeQuery(dbConnection -> {
            List issues = ((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(QIssue.ISSUE.id).from((Expression)QIssue.ISSUE)).where((Predicate)field.eq((Object)oldConstant.getId()))).limit(1000L)).fetch();
            if (!issues.isEmpty()) {
                dbConnection.update((RelationalPath<?>)QIssue.ISSUE).set((Path)field, (Object)newId).where((Predicate)QIssue.ISSUE.id.in((Collection)issues)).execute();
            }
            return issues;
        })).isEmpty()) {
            this.issueIndexingService.reIndexIssues((IssuesIterable)new IssueIdsIssueIterable(matchingIssues, this.issueManager), Contexts.nullContext());
        }
        GenericValue constantGv = ((IssueConstantImpl)((Object)oldConstant)).getGenericValue();
        String id = constantGv.getString("id");
        constantGv.set("id", (Object)new Long(id));
        this.removePropertySet(constantGv);
        constantGv.set("id", (Object)id);
        constantGv.remove();
        this.clearCaches();
        this.postProcess(oldConstant);
    }

    protected void removePropertySet(GenericValue constantGv) {
        OFBizPropertyUtils.removePropertySet(constantGv);
    }

    protected void postProcess(T constant) {
    }

    protected void clearCaches() {
    }

    protected abstract String getIssueConstantField();

    protected abstract List<T> getAllValues();

    protected void moveUp(T constant) {
        List<T> allValues = this.getAllValues();
        ArrayList<GenericValue> reordered = new ArrayList<GenericValue>(allValues.size());
        for (IssueConstant cons : allValues) {
            GenericValue value = ((IssueConstantImpl)cons).getGenericValue();
            if (cons.getId().equals(constant.getId()) && reordered.isEmpty()) break;
            if (cons.getId().equals(constant.getId())) {
                reordered.add(reordered.size() - 1, value);
                continue;
            }
            reordered.add(value);
        }
        this.storeAndClearCaches(reordered);
    }

    protected void moveDown(T constant) {
        List<T> allValues = this.getAllValues();
        ArrayList<GenericValue> reordered = new ArrayList<GenericValue>(allValues.size());
        Iterator<T> iterator = allValues.iterator();
        while (iterator.hasNext()) {
            IssueConstant cons = (IssueConstant)iterator.next();
            GenericValue value = ((IssueConstantImpl)cons).getGenericValue();
            if (cons.getId().equals(constant.getId()) && !iterator.hasNext()) break;
            if (cons.getId().equals(constant.getId())) {
                reordered.add(((IssueConstantImpl)((Object)iterator.next())).getGenericValue());
                reordered.add(value);
                continue;
            }
            reordered.add(value);
        }
        this.storeAndClearCaches(reordered);
    }

    private void storeAndClearCaches(List<GenericValue> reordered) {
        for (int i = 0; i < reordered.size(); ++i) {
            GenericValue value = reordered.get(i);
            value.set("sequence", (Object)((long)i + 1L));
        }
        this.ofBizDelegator.storeAll(reordered);
        this.clearCaches();
    }
}

