/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.config.IssueTypeDeletedEvent;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.TextIssueConstant;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.ClearStatusCacheEvent;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.model.querydsl.QIssueType;
import com.atlassian.jira.model.querydsl.QPriority;
import com.atlassian.jira.model.querydsl.QResolution;
import com.atlassian.jira.model.querydsl.QStatus;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultConstantsManager
implements ConstantsManager {
    public static final int MAX_NAME_LENGTH = 60;
    private static final Logger log = LoggerFactory.getLogger(DefaultConstantsManager.class);
    private CachedReference<ConstantsCache<Priority>> priorityCache;
    private CachedReference<ConstantsCache<Resolution>> resolutionCache;
    private CachedReference<ConstantsCache<Status>> statusCache;
    private CachedReference<IssueTypeCache> issueTypeCache;
    private final IssueConstant UNRESOLVED_RESOLUTION;
    private final JiraAuthenticationContext authenticationContext;
    private final OfBizDelegator ofBizDelegator;
    private final DbConnectionManager dbConnectionManager;
    private final EventPublisher eventPublisher;
    private final IssueConstantFactory issueConstantFactory;

    public DefaultConstantsManager(JiraAuthenticationContext authenticationContext, OfBizDelegator ofBizDelegator, DbConnectionManager dbConnectionManager, IssueConstantFactory issueConstantFactory, CacheManager cacheManager, EventPublisher eventPublisher) {
        this.dbConnectionManager = dbConnectionManager;
        this.issueConstantFactory = issueConstantFactory;
        this.authenticationContext = authenticationContext;
        this.ofBizDelegator = ofBizDelegator;
        this.eventPublisher = eventPublisher;
        this.UNRESOLVED_RESOLUTION = new TextIssueConstant("common.status.unresolved", "common.status.unresolved", null, authenticationContext);
        this.createCachedReferences(cacheManager);
    }

    private void createCachedReferences(CacheManager cacheManager) {
        this.priorityCache = cacheManager.getCachedReference(this.getClass().getName() + ".priorityCache", this::loadPriorityCache);
        this.resolutionCache = cacheManager.getCachedReference(this.getClass().getName() + ".resolutionCache", this::loadResolutionCache);
        this.statusCache = cacheManager.getCachedReference(this.getClass().getName() + ".statusCache", this::loadStatusCache);
        this.issueTypeCache = cacheManager.getCachedReference(this.getClass().getName() + ".issueTypeCache", this::loadIssueTypeCache);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent ignored) {
        this.invalidateAll();
    }

    @EventListener
    public void onIssueTypeDeleted(IssueTypeDeletedEvent event) {
        this.issueTypeCache.reset();
    }

    public Collection<Status> getStatuses() {
        return ((ConstantsCache)this.statusCache.get()).getObjects();
    }

    public Status getStatus(String id) {
        return (Status)((ConstantsCache)this.statusCache.get()).getObject(id);
    }

    public void refreshStatuses() {
        this.statusCache.reset();
        this.eventPublisher.publish((Object)ClearStatusCacheEvent.INSTANCE);
    }

    @Nullable
    public IssueConstant getConstantObject(String constantType, String id) {
        if (ConstantsManager.CONSTANT_TYPE.PRIORITY.getType().equalsIgnoreCase(constantType)) {
            return this.getPriorityObject(id);
        }
        if (ConstantsManager.CONSTANT_TYPE.STATUS.getType().equalsIgnoreCase(constantType)) {
            return this.getStatus(id);
        }
        if (ConstantsManager.CONSTANT_TYPE.RESOLUTION.getType().equalsIgnoreCase(constantType)) {
            return this.getResolution(id);
        }
        if (ConstantsManager.CONSTANT_TYPE.ISSUE_TYPE.getType().equalsIgnoreCase(constantType)) {
            return this.getIssueType(id);
        }
        return null;
    }

    @Nullable
    public Collection<? extends IssueConstant> getConstantObjects(String constantType) {
        if (ConstantsManager.CONSTANT_TYPE.PRIORITY.getType().equalsIgnoreCase(constantType)) {
            return this.getPriorities();
        }
        if (ConstantsManager.CONSTANT_TYPE.STATUS.getType().equalsIgnoreCase(constantType)) {
            return this.getStatuses();
        }
        if (ConstantsManager.CONSTANT_TYPE.RESOLUTION.getType().equalsIgnoreCase(constantType)) {
            return this.getResolutions();
        }
        if (ConstantsManager.CONSTANT_TYPE.ISSUE_TYPE.getType().equalsIgnoreCase(constantType)) {
            return this.getAllIssueTypeObjects();
        }
        return null;
    }

    private Function<String, ? extends IssueConstant> resolver(ConstantsManager.CONSTANT_TYPE constantType) {
        switch (constantType) {
            case PRIORITY: {
                return this::getPriorityObject;
            }
            case STATUS: {
                return this::getStatus;
            }
            case RESOLUTION: {
                return id -> "-1".equals(id) ? this.UNRESOLVED_RESOLUTION : this.getResolution((String)id);
            }
            case ISSUE_TYPE: {
                return this::getIssueType;
            }
        }
        throw new IllegalArgumentException("Constant type is not valid: " + constantType);
    }

    @Nonnull
    public List<IssueConstant> getConstantsByIds(@Nonnull ConstantsManager.CONSTANT_TYPE constantType, @Nonnull Collection<String> ids) {
        ArrayList<IssueConstant> list = new ArrayList<IssueConstant>(ids.size());
        Function<String, ? extends IssueConstant> resolver = this.resolver(constantType);
        for (String id : ids) {
            IssueConstant constant = resolver.apply(id);
            if (constant != null) {
                list.add(constant);
                continue;
            }
            log.debug(id + " returned a null constant of type " + constantType);
        }
        return list;
    }

    public boolean constantExists(String constantType, String name) {
        return this.getIssueConstantByName(constantType, name) != null;
    }

    public IssueConstant getIssueConstantByName(String constantType, String name) {
        ConstantsCache<? extends IssueConstant> constantsCache = this.getConstantsCache(constantType);
        return constantsCache.getObjectByName(name);
    }

    public IssueConstant getConstantByNameIgnoreCase(String constantType, String name) {
        ConstantsCache<? extends IssueConstant> constantsCache = this.getConstantsCache(constantType);
        return constantsCache.getObjectByNameIgnoreCase(name);
    }

    private ConstantsCache<? extends IssueConstant> getConstantsCache(String constantType) {
        if (ConstantsManager.CONSTANT_TYPE.PRIORITY.getType().equalsIgnoreCase(constantType)) {
            return (ConstantsCache)this.priorityCache.get();
        }
        if (ConstantsManager.CONSTANT_TYPE.STATUS.getType().equalsIgnoreCase(constantType)) {
            return (ConstantsCache)this.statusCache.get();
        }
        if (ConstantsManager.CONSTANT_TYPE.RESOLUTION.getType().equalsIgnoreCase(constantType)) {
            return (ConstantsCache)this.resolutionCache.get();
        }
        if (ConstantsManager.CONSTANT_TYPE.ISSUE_TYPE.getType().equalsIgnoreCase(constantType)) {
            return (ConstantsCache)this.issueTypeCache.get();
        }
        throw new IllegalArgumentException("Unknown constant type '" + constantType + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IssueType insertIssueType(String name, Long sequence, String style, String description, String iconurl) throws CreateException {
        Long nextSeqId = this.ofBizDelegator.getDelegatorInterface().getNextSeqId(ConstantsManager.CONSTANT_TYPE.ISSUE_TYPE.getType());
        try {
            this.dbConnectionManager.execute(dbConnection -> {
                QIssueType it = new QIssueType("it");
                dbConnection.insert(it).set((Path)it.id, String.valueOf(nextSeqId)).set((Path)it.name, name).set((Path)it.sequence, sequence).set((Path)it.style, StringUtils.trimToNull((String)style)).set((Path)it.description, description).set((Path)it.iconurl, iconurl).execute();
            });
        }
        finally {
            this.refreshIssueTypes();
        }
        return this.getIssueType(String.valueOf(nextSeqId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IssueType insertIssueType(String name, Long sequence, String style, String description, Long avatarId) throws CreateException {
        Long nextSeqId = this.ofBizDelegator.getDelegatorInterface().getNextSeqId(ConstantsManager.CONSTANT_TYPE.ISSUE_TYPE.getType());
        try {
            this.dbConnectionManager.execute(dbConnection -> {
                QIssueType it = new QIssueType("it");
                dbConnection.insert(it).set((Path)it.id, String.valueOf(nextSeqId)).set((Path)it.name, name).set((Path)it.sequence, sequence).set((Path)it.style, style).set((Path)it.description, description).set((Path)it.avatar, avatarId).execute();
            });
        }
        finally {
            this.refreshIssueTypes();
        }
        return this.getIssueType(String.valueOf(nextSeqId));
    }

    public void validateCreateIssueType(String name, String style, String description, String iconurl, ErrorCollection errors, String nameFieldName) {
        this.validateName(name, (Option<IssueType>)Option.none()).foreach(error -> errors.addError(nameFieldName, this.authenticationContext.getI18nHelper().getText((String)error.first()), (ErrorCollection.Reason)error.second()));
        if (StringUtils.isBlank((CharSequence)iconurl)) {
            errors.addError("iconurl", this.authenticationContext.getI18nHelper().getText("admin.errors.must.specify.url.for.issue.type"));
        }
    }

    public Option<Pair<String, ErrorCollection.Reason>> validateName(String name, Option<IssueType> issueTypeToUpdate) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return Option.some((Object)Pair.of((Object)this.authenticationContext.getI18nHelper().getText("admin.errors.must.specify.name"), (Object)ErrorCollection.Reason.VALIDATION_FAILED));
        }
        if (StringUtils.length((CharSequence)name) > 60) {
            return Option.some((Object)Pair.of((Object)this.authenticationContext.getI18nHelper().getText("admin.common.errors.exceeds.max.name.length", (Object)60), (Object)ErrorCollection.Reason.VALIDATION_FAILED));
        }
        for (IssueType issueType : this.getAllIssueTypeObjects()) {
            if ((!issueTypeToUpdate.isDefined() || ((IssueType)issueTypeToUpdate.get()).equals(issueType)) && !issueTypeToUpdate.isEmpty() || !name.trim().equalsIgnoreCase(issueType.getName())) continue;
            return Option.some((Object)Pair.of((Object)this.authenticationContext.getI18nHelper().getText("admin.errors.constant.already.exists"), (Object)ErrorCollection.Reason.CONFLICT));
        }
        return Option.none();
    }

    public void validateCreateIssueTypeWithAvatar(String name, String style, String description, String avatarId, final ErrorCollection errors, final String nameFieldName) {
        this.validateName(name, (Option<IssueType>)Option.none()).foreach((Effect)new Effect<Pair<String, ErrorCollection.Reason>>(){

            public void apply(Pair<String, ErrorCollection.Reason> error) {
                errors.addError(nameFieldName, DefaultConstantsManager.this.authenticationContext.getI18nHelper().getText((String)error.first()), (ErrorCollection.Reason)error.second());
            }
        });
        if (StringUtils.isBlank((CharSequence)avatarId)) {
            errors.addError("avatarId", this.authenticationContext.getI18nHelper().getText("admin.errors.issue.type.must.specify.avatar"));
        } else {
            try {
                Long.valueOf(avatarId);
            }
            catch (NumberFormatException e) {
                errors.addError("avatarId", this.authenticationContext.getI18nHelper().getText("admin.errors.issue.type.must.specify.avatar"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIssueType(String id, String name, Long sequence, String style, String description, String iconurl) throws DataAccessException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        try {
            this.dbConnectionManager.execute(dbConnection -> {
                long rowCount = dbConnection.update((RelationalPath<?>)QIssueType.ISSUE_TYPE).set((Path)QIssueType.ISSUE_TYPE.name, (Object)name).set(QIssueType.ISSUE_TYPE.sequence, (Object)sequence).set((Path)QIssueType.ISSUE_TYPE.style, (Object)style).set((Path)QIssueType.ISSUE_TYPE.description, (Object)description).set((Path)QIssueType.ISSUE_TYPE.iconurl, (Object)iconurl).where((com.querydsl.core.types.Predicate)QIssueType.ISSUE_TYPE.id.eq((Object)id)).execute();
                if (rowCount == 0L) {
                    throw new IllegalArgumentException("Issue Type with id '" + id + "' does not exist.");
                }
            });
        }
        finally {
            this.refreshIssueTypes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIssueType(String id, String name, Long sequence, String style, String description, Long avatarId) throws DataAccessException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        try {
            this.dbConnectionManager.execute(dbConnection -> {
                long rowCount = dbConnection.update((RelationalPath<?>)QIssueType.ISSUE_TYPE).set((Path)QIssueType.ISSUE_TYPE.name, (Object)name).set(QIssueType.ISSUE_TYPE.sequence, (Object)sequence).set((Path)QIssueType.ISSUE_TYPE.style, (Object)style).set((Path)QIssueType.ISSUE_TYPE.description, (Object)description).set(QIssueType.ISSUE_TYPE.avatar, (Object)avatarId).where((com.querydsl.core.types.Predicate)QIssueType.ISSUE_TYPE.id.eq((Object)id)).execute();
                if (rowCount == 0L) {
                    throw new IllegalArgumentException("Issue Type with id '" + id + "' does not exist.");
                }
            });
        }
        finally {
            this.refreshIssueTypes();
        }
    }

    public void removeIssueType(String id) throws RemoveException {
        IssueType issueType = this.getIssueType(id);
        if (issueType != null) {
            try {
                this.dbConnectionManager.execute(dbConnection -> dbConnection.delete((RelationalPath<?>)QIssueType.ISSUE_TYPE).where((com.querydsl.core.types.Predicate)QIssueType.ISSUE_TYPE.id.eq((Object)id)).execute());
            }
            finally {
                this.refreshIssueTypes();
            }
        } else {
            throw new RemoveException("Issue type with id '" + id + "' does not exist.");
        }
    }

    public void recalculateIssueTypeSequencesAndStore(List<IssueType> issueTypes) {
        try {
            this.recalculateSequenceAndStore((List<? extends IssueConstant>)issueTypes, (RelationalPath<?>)QIssueType.ISSUE_TYPE, QIssueType.ISSUE_TYPE.sequence, QIssueType.ISSUE_TYPE.id);
        }
        finally {
            this.refreshIssueTypes();
        }
    }

    public void recalculatePrioritySequencesAndStore(List<Priority> priorities) {
        try {
            this.recalculateSequenceAndStore((List<? extends IssueConstant>)priorities, (RelationalPath<?>)QPriority.PRIORITY, QPriority.PRIORITY.sequence, QPriority.PRIORITY.id);
        }
        finally {
            this.refreshPriorities();
        }
    }

    public void recalculateStatusSequencesAndStore(List<Status> statuses) {
        try {
            this.recalculateSequenceAndStore((List<? extends IssueConstant>)statuses, (RelationalPath<?>)QStatus.STATUS, QStatus.STATUS.sequence, QStatus.STATUS.id);
        }
        finally {
            this.refreshStatuses();
        }
    }

    public void recalculateResolutionSequencesAndStore(List<Resolution> resolutions) {
        try {
            this.recalculateSequenceAndStore((List<? extends IssueConstant>)resolutions, (RelationalPath<?>)QResolution.RESOLUTION, QResolution.RESOLUTION.sequence, QResolution.RESOLUTION.id);
        }
        finally {
            this.refreshResolutions();
        }
    }

    private void recalculateSequenceAndStore(List<? extends IssueConstant> constants, RelationalPath<?> entity, NumberPath<Long> sequencePath, StringPath idPath) {
        this.dbConnectionManager.execute(dbConnection -> {
            dbConnection.setAutoCommit(false);
            long sequence = 0L;
            for (IssueConstant constant : constants) {
                dbConnection.update(entity).set((Path)sequencePath, (Object)sequence).where((com.querydsl.core.types.Predicate)idPath.eq((Object)constant.getId())).execute();
                ++sequence;
            }
            dbConnection.commit();
        });
    }

    public void storeIssueTypes(List<GenericValue> issueTypes) throws DataAccessException {
        try {
            this.ofBizDelegator.storeAll(issueTypes);
        }
        catch (DataAccessException e) {
            throw new DataAccessException("Error occurred while storing issue types to the database.", (Throwable)e);
        }
        this.refreshIssueTypes();
    }

    public void invalidateAll() {
        this.priorityCache.reset();
        this.resolutionCache.reset();
        this.issueTypeCache.reset();
        this.statusCache.reset();
    }

    public void invalidate(IssueConstant constant) {
        if (constant instanceof Priority) {
            this.priorityCache.reset();
        } else if (constant instanceof Resolution) {
            this.resolutionCache.reset();
        } else if (constant instanceof IssueType) {
            this.issueTypeCache.reset();
        } else if (constant instanceof Status) {
            this.statusCache.reset();
        }
    }

    public List<String> expandIssueTypeIds(Collection<String> issueTypeIds) {
        if (issueTypeIds == null) {
            return Collections.emptyList();
        }
        for (String issueTypeId : issueTypeIds) {
            if ("-2".equals(issueTypeId)) {
                return DefaultConstantsManager.getConstantIds(this.getRegularIssueTypeObjects());
            }
            if ("-3".equals(issueTypeId)) {
                return DefaultConstantsManager.getConstantIds(this.getSubTaskIssueTypeObjects());
            }
            if (!"-4".equals(issueTypeId)) continue;
            return this.getAllIssueTypeIds();
        }
        return new ArrayList<String>(issueTypeIds);
    }

    public List<String> getAllIssueTypeIds() {
        return ((IssueTypeCache)this.issueTypeCache.get()).getCachedIds();
    }

    public IssueConstant getIssueConstant(GenericValue issueConstantGV) {
        if (issueConstantGV == null) {
            return null;
        }
        if (ConstantsManager.CONSTANT_TYPE.ISSUE_TYPE.getType().equals(issueConstantGV.getEntityName())) {
            return this.getIssueType(issueConstantGV.getString("id"));
        }
        if (ConstantsManager.CONSTANT_TYPE.STATUS.getType().equals(issueConstantGV.getEntityName())) {
            return this.getStatus(issueConstantGV.getString("id"));
        }
        if (ConstantsManager.CONSTANT_TYPE.PRIORITY.getType().equals(issueConstantGV.getEntityName())) {
            return this.getPriorityObject(issueConstantGV.getString("id"));
        }
        if (ConstantsManager.CONSTANT_TYPE.RESOLUTION.getType().equals(issueConstantGV.getEntityName())) {
            return this.getResolution(issueConstantGV.getString("id"));
        }
        throw new IllegalArgumentException("Unknown constant entity name '" + issueConstantGV.getEntityName() + "'.");
    }

    private static List<String> getConstantIds(Collection<? extends IssueConstant> issueConstants) {
        ArrayList<String> ids = new ArrayList<String>(issueConstants.size());
        for (IssueConstant issueConstant : issueConstants) {
            ids.add(issueConstant.getId());
        }
        return ids;
    }

    @Nonnull
    public Collection<Priority> getPriorities() {
        return ((ConstantsCache)this.priorityCache.get()).getObjects();
    }

    public Priority getPriorityObject(String id) {
        return (Priority)((ConstantsCache)this.priorityCache.get()).getObject(id);
    }

    public Priority getDefaultPriority() {
        String defaultPriorityId = ComponentAccessor.getApplicationProperties().getString("jira.constant.default.priority");
        if (defaultPriorityId == null) {
            Collection<Priority> priorities = this.getPriorities();
            Priority defaultPriority = null;
            Iterator<Priority> priorityIt = priorities.iterator();
            int times = (int)Math.ceil((double)priorities.size() / 2.0);
            for (int i = 0; i < times; ++i) {
                defaultPriority = priorityIt.next();
            }
            return defaultPriority;
        }
        return this.getPriorityObject(defaultPriorityId);
    }

    public String getPriorityName(String id) {
        if ("-1".equals(id)) {
            return this.authenticationContext.getI18nHelper().getText("constants.manager.no.priority");
        }
        Priority priorityObject = this.getPriorityObject(id);
        if (priorityObject == null) {
            return this.authenticationContext.getI18nHelper().getText("constants.manager.no.priority");
        }
        return priorityObject.getName();
    }

    public void refreshPriorities() {
        this.priorityCache.reset();
    }

    @Nonnull
    public Collection<Resolution> getResolutions() {
        return ((ConstantsCache)this.resolutionCache.get()).getObjects();
    }

    public Resolution getResolution(String id) {
        return (Resolution)((ConstantsCache)this.resolutionCache.get()).getObject(id);
    }

    public void refreshResolutions() {
        this.resolutionCache.reset();
    }

    public Collection<IssueType> getAllIssueTypeObjects() {
        return ((IssueTypeCache)this.issueTypeCache.get()).getObjects();
    }

    public Collection<IssueType> getRegularIssueTypeObjects() {
        return ((IssueTypeCache)this.issueTypeCache.get()).getRegularIssueTypeObjects();
    }

    @Nonnull
    public Collection<IssueType> getSubTaskIssueTypeObjects() {
        return ((IssueTypeCache)this.issueTypeCache.get()).getSubTaskIssueTypeObjects();
    }

    public Status getStatusByName(String name) {
        Collection<Status> statusObjects = this.getStatuses();
        return DefaultConstantsManager.findByName(name, statusObjects);
    }

    public Status getStatusByNameIgnoreCase(String name) {
        Collection<Status> statusObjects = this.getStatuses();
        return DefaultConstantsManager.findByNameIgnoreCase(name, statusObjects);
    }

    public Status getStatusByTranslatedName(String name) {
        Collection<Status> statusObjects = this.getStatuses();
        Status status = DefaultConstantsManager.findByTranslatedName(name, statusObjects);
        if (status == null) {
            status = DefaultConstantsManager.findByName(name, statusObjects);
        }
        return status;
    }

    @Nullable
    private static <T extends IssueConstant> T find(Collection<T> constants, Predicate<T> matcher) {
        return (T)((IssueConstant)constants.stream().filter(matcher).findAny().orElse(null));
    }

    private static <T extends IssueConstant> T findByName(String name, Collection<T> constants) {
        return (T)DefaultConstantsManager.find(constants, constant -> constant.getName().equals(name));
    }

    private static <T extends IssueConstant> T findByNameIgnoreCase(String name, Collection<T> constants) {
        return (T)DefaultConstantsManager.find(constants, constant -> constant.getName().equalsIgnoreCase(name));
    }

    private static <T extends IssueConstant> T findByTranslatedName(String name, Collection<T> constants) {
        return (T)DefaultConstantsManager.find(constants, constant -> constant.getNameTranslation().equals(name));
    }

    public List<IssueType> getEditableSubTaskIssueTypes() {
        List ids = this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)Projections.bean((Path)QIssueType.ISSUE_TYPE.id, (Expression[])new Expression[0])).from((Expression)QIssueType.ISSUE_TYPE)).where((com.querydsl.core.types.Predicate)QIssueType.ISSUE_TYPE.style.eq((Object)"jira_subtask"))).fetch());
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ids.stream().map(this::getIssueType).forEach(arg_0 -> ((ImmutableList.Builder)listBuilder).add(arg_0));
        return listBuilder.build();
    }

    public IssueType getIssueType(String id) {
        return (IssueType)((IssueTypeCache)this.issueTypeCache.get()).getObject(id);
    }

    public void refreshIssueTypes() {
        this.issueTypeCache.reset();
    }

    private ConstantsCache<Priority> loadPriorityCache() {
        List priorityList = this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QPriority.PRIORITY).from((Expression)QPriority.PRIORITY)).orderBy(QPriority.PRIORITY.sequence.asc())).fetch());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        priorityList.stream().map(this.issueConstantFactory::createPriority).forEach(p -> builder.put((Object)p.getId(), p));
        return new ConstantsCache<Priority>(builder.build());
    }

    private ConstantsCache<Resolution> loadResolutionCache() {
        List resolutionList = this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QResolution.RESOLUTION).from((Expression)QResolution.RESOLUTION)).orderBy(QResolution.RESOLUTION.sequence.asc())).fetch());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        resolutionList.stream().map(this.issueConstantFactory::createResolution).forEach(r -> builder.put((Object)r.getId(), r));
        return new ConstantsCache<Resolution>(builder.build());
    }

    private ConstantsCache<Status> loadStatusCache() {
        List statusList = this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QStatus.STATUS).from((Expression)QStatus.STATUS)).orderBy(QStatus.STATUS.sequence.asc())).fetch());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        statusList.stream().map(this.issueConstantFactory::createStatus).forEach(r -> builder.put((Object)r.getId(), r));
        return new ConstantsCache<Status>(builder.build());
    }

    private IssueTypeCache loadIssueTypeCache() {
        List issueTypeList = this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QIssueType.ISSUE_TYPE).from((Expression)QIssueType.ISSUE_TYPE)).orderBy(QIssueType.ISSUE_TYPE.style.asc())).orderBy(QIssueType.ISSUE_TYPE.sequence.asc())).fetch());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableList.Builder regularIssueTypesBuilder = ImmutableList.builder();
        ImmutableList.Builder subTaskIssueTypesBuilder = ImmutableList.builder();
        issueTypeList.stream().map(this.issueConstantFactory::createIssueType).forEach(issueType -> {
            if (issueType.isSubTask()) {
                subTaskIssueTypesBuilder.add(issueType);
            } else {
                regularIssueTypesBuilder.add(issueType);
            }
            builder.put((Object)issueType.getId(), issueType);
        });
        return new IssueTypeCache((ImmutableMap<String, IssueType>)builder.build(), (ImmutableList<IssueType>)regularIssueTypesBuilder.build(), (ImmutableList<IssueType>)subTaskIssueTypesBuilder.build());
    }

    private static class IssueTypeCache
    extends ConstantsCache<IssueType> {
        private final List<IssueType> regularIssueTypeObjects;
        private final List<IssueType> subTaskIssueTypeObjects;

        public IssueTypeCache(ImmutableMap<String, IssueType> idObjectMap, ImmutableList<IssueType> regularIssueTypeObjects, ImmutableList<IssueType> subTaskIssueTypeObjects) {
            super(idObjectMap);
            this.regularIssueTypeObjects = regularIssueTypeObjects;
            this.subTaskIssueTypeObjects = subTaskIssueTypeObjects;
        }

        public List<IssueType> getRegularIssueTypeObjects() {
            return this.regularIssueTypeObjects;
        }

        public List<IssueType> getSubTaskIssueTypeObjects() {
            return this.subTaskIssueTypeObjects;
        }
    }

    static class ConstantsCache<T extends IssueConstant> {
        private final Map<String, T> idObjectMap;
        private final Map<String, Collection<T>> nameObjectMap;
        private final List<String> idList;
        private T noNameObject;

        public ConstantsCache(ImmutableMap<String, T> issueConstantMap) {
            this.idObjectMap = issueConstantMap;
            List ids = DefaultConstantsManager.getConstantIds((Collection)issueConstantMap.values());
            this.idList = Collections.unmodifiableList(ids);
            this.nameObjectMap = new HashMap<String, Collection<T>>();
            for (IssueConstant t : issueConstantMap.values()) {
                if (t.getName() != null) {
                    this.nameObjectMap.computeIfAbsent(t.getName().toLowerCase(), k -> new ArrayList()).add(t);
                    continue;
                }
                this.noNameObject = t;
            }
        }

        Collection<T> getObjects() {
            return this.idObjectMap.values();
        }

        T getObject(String id) {
            return (T)((IssueConstant)this.idObjectMap.get(id));
        }

        T getObjectByName(String name) {
            if (name == null) {
                return this.noNameObject;
            }
            return (T)((IssueConstant)((Collection)this.nameObjectMap.getOrDefault(name.toLowerCase(), Collections.emptyList())).stream().filter(x -> name.equals(x.getName())).findFirst().orElse(null));
        }

        T getObjectByNameIgnoreCase(String name) {
            if (name == null) {
                return this.noNameObject;
            }
            return (T)((IssueConstant)((Collection)this.nameObjectMap.getOrDefault(name.toLowerCase(), Collections.emptyList())).stream().findFirst().orElse(null));
        }

        List<String> getCachedIds() {
            return this.idList;
        }
    }
}

